package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class AnalyzeTypeAbstract extends TopiaEntityAbstract implements AnalyzeType {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : durationDays
     */
    protected int durationDays;

    private static final long serialVersionUID = 7077235528453011511L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, DURATION_DAYS, int.class, durationDays);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
    }

    @Override
    public void setDurationDays(int durationDays) {
        int oldValue = this.durationDays;
        fireOnPreWrite(DURATION_DAYS, oldValue, durationDays);
        this.durationDays = durationDays;
        fireOnPostWrite(DURATION_DAYS, oldValue, durationDays);
    }

    @Override
    public int getDurationDays() {
        fireOnPreRead(DURATION_DAYS, durationDays);
        int result = this.durationDays;
        fireOnPostRead(DURATION_DAYS, durationDays);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(DURATION_DAYS, this.durationDays).
         toString();
        return result;
    }

} //AnalyzeTypeAbstract
