package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class AnalyzeAbstract extends TopiaEntityAbstract implements Analyze {

    /**
     * Nom de l'attribut en BD : creationDate
     */
    protected Date creationDate;

    /**
     * Nom de l'attribut en BD : sentDate
     */
    protected Date sentDate;

    /**
     * Nom de l'attribut en BD : receiptDate
     */
    protected Date receiptDate;

    /**
     * Nom de l'attribut en BD : analyzeType
     */
    protected AnalyzeType analyzeType;

    /**
     * Nom de l'attribut en BD : analyzeFile
     */
    protected Collection<AnalyzeFile> analyzeFile;

    /**
     * Nom de l'attribut en BD : batch
     */
    protected Batch batch;

    private static final long serialVersionUID = 7017512233592108646L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, CREATION_DATE, Date.class, creationDate);
        visitor.visit(this, SENT_DATE, Date.class, sentDate);
        visitor.visit(this, RECEIPT_DATE, Date.class, receiptDate);
        visitor.visit(this, ANALYZE_TYPE, AnalyzeType.class, analyzeType);
        visitor.visit(this, ANALYZE_FILE, Collection.class, AnalyzeFile.class, analyzeFile);
        visitor.visit(this, BATCH, Batch.class, batch);
        visitor.end(this);
    }

    @Override
    public void setCreationDate(Date creationDate) {
        Date oldValue = this.creationDate;
        fireOnPreWrite(CREATION_DATE, oldValue, creationDate);
        this.creationDate = creationDate;
        fireOnPostWrite(CREATION_DATE, oldValue, creationDate);
    }

    @Override
    public Date getCreationDate() {
        fireOnPreRead(CREATION_DATE, creationDate);
        Date result = this.creationDate;
        fireOnPostRead(CREATION_DATE, creationDate);
        return result;
    }

    @Override
    public void setSentDate(Date sentDate) {
        Date oldValue = this.sentDate;
        fireOnPreWrite(SENT_DATE, oldValue, sentDate);
        this.sentDate = sentDate;
        fireOnPostWrite(SENT_DATE, oldValue, sentDate);
    }

    @Override
    public Date getSentDate() {
        fireOnPreRead(SENT_DATE, sentDate);
        Date result = this.sentDate;
        fireOnPostRead(SENT_DATE, sentDate);
        return result;
    }

    @Override
    public void setReceiptDate(Date receiptDate) {
        Date oldValue = this.receiptDate;
        fireOnPreWrite(RECEIPT_DATE, oldValue, receiptDate);
        this.receiptDate = receiptDate;
        fireOnPostWrite(RECEIPT_DATE, oldValue, receiptDate);
    }

    @Override
    public Date getReceiptDate() {
        fireOnPreRead(RECEIPT_DATE, receiptDate);
        Date result = this.receiptDate;
        fireOnPostRead(RECEIPT_DATE, receiptDate);
        return result;
    }

    @Override
    public void setAnalyzeType(AnalyzeType analyzeType) {
        AnalyzeType oldValue = this.analyzeType;
        fireOnPreWrite(ANALYZE_TYPE, oldValue, analyzeType);
        this.analyzeType = analyzeType;
        fireOnPostWrite(ANALYZE_TYPE, oldValue, analyzeType);
    }

    @Override
    public AnalyzeType getAnalyzeType() {
        fireOnPreRead(ANALYZE_TYPE, analyzeType);
        AnalyzeType result = this.analyzeType;
        fireOnPostRead(ANALYZE_TYPE, analyzeType);
        return result;
    }

    @Override
    public void addAnalyzeFile(AnalyzeFile analyzeFile) {
        fireOnPreWrite(ANALYZE_FILE, null, analyzeFile);
        if (this.analyzeFile == null) {
            this.analyzeFile = new ArrayList<AnalyzeFile>();
        }

        this.analyzeFile.add(analyzeFile);
        fireOnPostWrite(ANALYZE_FILE, this.analyzeFile.size(), null, analyzeFile);
    }

    @Override
    public void addAllAnalyzeFile(Collection<AnalyzeFile> analyzeFile) {
        if (analyzeFile == null) {
            return;
        }
        for (AnalyzeFile item : analyzeFile) {
            addAnalyzeFile(item);
        }
    }

    @Override
    public void setAnalyzeFile(Collection<AnalyzeFile> analyzeFile) {
        // Copy elements to keep data for fire with new reference
        Collection<AnalyzeFile> oldValue = this.analyzeFile != null ? new ArrayList<AnalyzeFile>(this.analyzeFile) : null;
        fireOnPreWrite(ANALYZE_FILE, oldValue, analyzeFile);
        this.analyzeFile = analyzeFile;
        fireOnPostWrite(ANALYZE_FILE, oldValue, analyzeFile);
    }

    @Override
    public void removeAnalyzeFile(AnalyzeFile analyzeFile) {
        fireOnPreWrite(ANALYZE_FILE, analyzeFile, null);
        if (this.analyzeFile == null || !this.analyzeFile.remove(analyzeFile)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(ANALYZE_FILE, this.analyzeFile.size() + 1, analyzeFile, null);
    }

    @Override
    public void clearAnalyzeFile() {
        if (this.analyzeFile == null) {
            return;
        }
        Collection<AnalyzeFile> oldValue = new ArrayList<AnalyzeFile>(this.analyzeFile);
        fireOnPreWrite(ANALYZE_FILE, oldValue, this.analyzeFile);
        this.analyzeFile.clear();
        fireOnPostWrite(ANALYZE_FILE, oldValue, this.analyzeFile);
    }

    @Override
    public Collection<AnalyzeFile> getAnalyzeFile() {
        return analyzeFile;
    }

    @Override
    public AnalyzeFile getAnalyzeFileByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(analyzeFile, topiaId);
    }

    @Override
    public int sizeAnalyzeFile() {
        if (analyzeFile == null) {
            return 0;
        }
        return analyzeFile.size();
    }

    @Override
    public boolean isAnalyzeFileEmpty() {
        int size = sizeAnalyzeFile();
        return size == 0;
    }

    @Override
    public void setBatch(Batch batch) {
        Batch oldValue = this.batch;
        fireOnPreWrite(BATCH, oldValue, batch);
        this.batch = batch;
        fireOnPostWrite(BATCH, oldValue, batch);
    }

    @Override
    public Batch getBatch() {
        fireOnPreRead(BATCH, batch);
        Batch result = this.batch;
        fireOnPostRead(BATCH, batch);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(CREATION_DATE, this.creationDate).
            append(SENT_DATE, this.sentDate).
            append(RECEIPT_DATE, this.receiptDate).
            append(BATCH, this.batch).
            append(ANALYZE_TYPE, this.analyzeType).
            append(ANALYZE_FILE, this.analyzeFile).
            append(BATCH, this.batch).
         toString();
        return result;
    }

} //AnalyzeAbstract
