/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resource.wrapped;

import com.helger.base.io.EAppend;
import com.helger.io.resource.IWritableResource;
import com.helger.io.resource.wrapped.AbstractWrappedWritableResource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class GZIPWritableResource
extends AbstractWrappedWritableResource {
    public GZIPWritableResource(@NonNull IWritableResource iWritableResource) {
        super(iWritableResource);
    }

    public @Nullable OutputStream getOutputStream(@NonNull EAppend eAppend) {
        OutputStream outputStream = this.getWrappedWritableResource().getOutputStream(eAppend);
        if (outputStream == null) {
            return null;
        }
        try {
            return new GZIPOutputStream(outputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to open GZIP OutputStream", iOException);
        }
    }

    @Override
    public @NonNull GZIPWritableResource getWritableCloneForPath(@NonNull String string) {
        return new GZIPWritableResource(this.getWrappedWritableResource().getWritableCloneForPath(string));
    }
}

