/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser;

import com.google.javascript.jscomp.parsing.parser.LineNumberTable;
import com.google.javascript.jscomp.parsing.parser.util.SourcePosition;

public final class SourceFile {
    public final String name;
    public final String contents;
    public final LineNumberTable lineNumberTable;

    public SourceFile(String name, String contents) {
        this.name = name;
        this.contents = contents;
        this.lineNumberTable = new LineNumberTable(this);
    }

    public String getSnippet(SourcePosition position) {
        int lineStart = this.lineNumberTable.offsetOfLine(position.line);
        int lineEnd = this.lineNumberTable.offsetOfLine(position.line + 1);
        lineStart = Math.min(lineStart, this.contents.length() - 1);
        lineEnd = Math.min(lineEnd, this.contents.length() - 1);
        return this.contents.substring(lineStart, lineEnd);
    }
}

