/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NewTypeInference;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypeCreatorFromJSDoc;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.NamespaceLit;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.Typedef;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GlobalTypeInfo
implements CompilerPass {
    static final DiagnosticType DUPLICATE_JSDOC = DiagnosticType.warning("JSC_DUPLICATE_JSDOC", "Found two JsDoc comments for variable: {0}.\n");
    static final DiagnosticType REDECLARED_PROPERTY = DiagnosticType.warning("JSC_REDECLARED_PROPERTY", "Found two declarations for property {0} of type {1}.\n");
    static final DiagnosticType INVALID_PROP_OVERRIDE = DiagnosticType.warning("JSC_INVALID_PROP_OVERRIDE", "Invalid redeclaration of property {0}.\ninherited type  : {1}\noverriding type : {2}\n");
    static final DiagnosticType EXTENDS_NOT_ON_CTOR_OR_INTERF = DiagnosticType.warning("JSC_EXTENDS_NOT_ON_CTOR_OR_INTERF", "@extends used without @constructor or @interface for {0}.\n");
    static final DiagnosticType EXTENDS_NON_OBJECT = DiagnosticType.warning("JSC_EXTENDS_NON_OBJECT", "{0} extends non-object type {1}.\n");
    static final DiagnosticType CTOR_IN_DIFFERENT_SCOPE = DiagnosticType.warning("JSC_CTOR_IN_DIFFERENT_SCOPE", "Modifying the prototype is only allowed if the constructor is in the same scope\n");
    static final DiagnosticType UNRECOGNIZED_TYPE_NAME = DiagnosticType.warning("JSC_UNRECOGNIZED_TYPE_NAME", "Type annotation references non-existent type {0}.");
    static final DiagnosticType INTERFACE_WITH_A_BODY = DiagnosticType.warning("JSC_INTERFACE_WITH_A_BODY", "Interface definitions should have an empty body.");
    static final DiagnosticType INHERITANCE_CYCLE = DiagnosticType.warning("JSC_INHERITANCE_CYCLE", "Cycle detected in inheritance chain of type {0}");
    static final DiagnosticType DICT_IMPLEMENTS_INTERF = DiagnosticType.warning("JSC_DICT_IMPLEMENTS_INTERF", "Class {0} is a dict. Dicts can't implement interfaces.");
    static final DiagnosticType CONSTRUCTOR_REQUIRED = DiagnosticType.warning("JSC_CONSTRUCTOR_REQUIRED", "{0} used without @constructor.");
    static final DiagnosticType INEXISTENT_PARAM = DiagnosticType.warning("JSC_INEXISTENT_PARAM", "parameter {0} does not appear in {1}''s parameter list");
    static final DiagnosticType IMPLEMENTS_WITHOUT_CONSTRUCTOR = DiagnosticType.warning("JSC_IMPLEMENTS_WITHOUT_CONSTRUCTOR", "@implements used without @constructor or @interface for {0}");
    static final DiagnosticType CONST_WITHOUT_INITIALIZER = DiagnosticType.warning("JSC_CONST_WITHOUT_INITIALIZER", "Constants must be initialized when they are defined.");
    static final DiagnosticType COULD_NOT_INFER_CONST_TYPE = DiagnosticType.warning("JSC_COULD_NOT_INFER_CONST_TYPE", "All constants must be typed. The compiler could not infer the typeof this constant. Please use an explicit type annotation.");
    static final DiagnosticType MISPLACED_CONST_ANNOTATION = DiagnosticType.warning("JSC_MISPLACED_CONST_ANNOTATION", "This property cannot be @const.The @const annotation is only allowed for properties of namespaces, prototype properties, static properties of constructors, and properties of the form this.prop declared inside constructors.");
    static final DiagnosticType CANNOT_OVERRIDE_FINAL_METHOD = DiagnosticType.warning("JSC_CANNOT_OVERRIDE_FINAL_METHOD", "Final method {0} cannot be overriden.");
    static final DiagnosticType CANNOT_INIT_TYPEDEF = DiagnosticType.warning("JSC_CANNOT_INIT_TYPEDEF", "A typedef variable represents a type name; it cannot be assigned a value.");
    static final DiagnosticType ANONYMOUS_NOMINAL_TYPE = DiagnosticType.warning("JSC_ANONYMOUS_NOMINAL_TYPE", "Must specify a name when defining a class or interface.");
    static final DiagnosticType MALFORMED_ENUM = DiagnosticType.warning("JSC_MALFORMED_ENUM", "An enum must be initialized to a non-empty object literal.");
    static final DiagnosticType DUPLICATE_PROP_IN_ENUM = DiagnosticType.warning("JSC_DUPLICATE_PROP_IN_ENUM", "Property {0} appears twice in the enum declaration.");
    static final DiagnosticType UNDECLARED_NAMESPACE = DiagnosticType.warning("JSC_UNDECLARED_NAMESPACE", "Undeclared reference to {0}.");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(ANONYMOUS_NOMINAL_TYPE, CANNOT_INIT_TYPEDEF, CANNOT_OVERRIDE_FINAL_METHOD, CONSTRUCTOR_REQUIRED, CONST_WITHOUT_INITIALIZER, COULD_NOT_INFER_CONST_TYPE, CTOR_IN_DIFFERENT_SCOPE, DICT_IMPLEMENTS_INTERF, DUPLICATE_JSDOC, DUPLICATE_PROP_IN_ENUM, EXTENDS_NON_OBJECT, EXTENDS_NOT_ON_CTOR_OR_INTERF, REDECLARED_PROPERTY, IMPLEMENTS_WITHOUT_CONSTRUCTOR, INEXISTENT_PARAM, INHERITANCE_CYCLE, INTERFACE_WITH_A_BODY, INVALID_PROP_OVERRIDE, MALFORMED_ENUM, MISPLACED_CONST_ANNOTATION, UNDECLARED_NAMESPACE, UNRECOGNIZED_TYPE_NAME, RhinoErrorReporter.BAD_JSDOC_ANNOTATION, TypeCheck.CONFLICTING_EXTENDED_TYPE, TypeCheck.CONFLICTING_IMPLEMENTED_TYPE, TypeCheck.CONFLICTING_SHAPE_TYPE, TypeCheck.ENUM_NOT_CONSTANT, TypeCheck.INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, TypeCheck.MULTIPLE_VAR_DEF, TypeCheck.UNKNOWN_OVERRIDE, TypeValidator.INTERFACE_METHOD_NOT_IMPLEMENTED);
    private final List<Scope> scopes = new ArrayList<Scope>();
    private Scope globalScope;
    private NewTypeInference.WarningReporter warnings;
    private JSTypeCreatorFromJSDoc typeParser;
    private final AbstractCompiler compiler;
    private final CodingConvention convention;
    private final Map<Node, String> anonFunNames = new HashMap<Node, String>();
    private static final String ANON_FUN_PREFIX = "%anon_fun";
    private int freshId = 1;
    private Map<Node, NominalType.RawNominalType> nominaltypesByNode = new HashMap<Node, NominalType.RawNominalType>();
    private HashBasedTable<NominalType.RawNominalType, String, PropertyDef> propertyDefs = HashBasedTable.create();
    private Map<Node, JSType> castTypes = new HashMap<Node, JSType>();
    private Map<Node, JSType> declaredObjLitProps = new HashMap<Node, JSType>();

    GlobalTypeInfo(AbstractCompiler compiler) {
        this.warnings = new NewTypeInference.WarningReporter(compiler);
        this.compiler = compiler;
        this.convention = compiler.getCodingConvention();
        this.typeParser = new JSTypeCreatorFromJSDoc(this.convention);
    }

    Collection<Scope> getScopes() {
        return this.scopes;
    }

    Scope getGlobalScope() {
        return this.globalScope;
    }

    JSType getCastType(Node n) {
        JSType t = this.castTypes.get(n);
        Preconditions.checkNotNull((Object)t);
        return t;
    }

    JSType getPropDeclaredType(Node n) {
        return this.declaredObjLitProps.get(n);
    }

    String getFunInternalName(Node n) {
        Preconditions.checkArgument((boolean)n.isFunction());
        if (this.anonFunNames.containsKey(n)) {
            return this.anonFunNames.get(n);
        }
        Node fnNameNode = NodeUtil.getFunctionNameNode(n);
        Preconditions.checkState((fnNameNode != null && fnNameNode.isName() ? 1 : 0) != 0);
        return fnNameNode.getString();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkArgument((externs == null || externs.isSyntheticBlock() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)root.isSyntheticBlock());
        this.globalScope = new Scope(root, null, (List)ImmutableList.of());
        this.scopes.add(this.globalScope);
        CollectNamedTypes rootCnt = new CollectNamedTypes(this.globalScope);
        if (externs != null) {
            new NodeTraversal(this.compiler, rootCnt).traverse(externs);
        }
        new NodeTraversal(this.compiler, rootCnt).traverse(root);
        this.globalScope.resolveTypedefs(this.typeParser);
        this.globalScope.resolveEnums(this.typeParser);
        for (int i = 1; i < this.scopes.size(); ++i) {
            Scope s = this.scopes.get(i);
            CollectNamedTypes cnt = new CollectNamedTypes(s);
            new NodeTraversal(this.compiler, cnt).traverse(s.getBody());
            s.resolveTypedefs(this.typeParser);
            s.resolveEnums(this.typeParser);
            if (!NewTypeInference.measureMem) continue;
            NewTypeInference.updatePeakMem();
        }
        ProcessScope rootPs = new ProcessScope(this.globalScope);
        if (externs != null) {
            new NodeTraversal(this.compiler, rootPs).traverse(externs);
        }
        new NodeTraversal(this.compiler, rootPs).traverse(root);
        rootPs.finishProcessingScope();
        for (int i = 1; i < this.scopes.size(); ++i) {
            Scope s = this.scopes.get(i);
            ProcessScope ps = new ProcessScope(s);
            new NodeTraversal(this.compiler, ps).traverse(s.getBody());
            ps.finishProcessingScope();
            if (!NewTypeInference.measureMem) continue;
            NewTypeInference.updatePeakMem();
        }
        this.reportInheritanceErrors();
        this.nominaltypesByNode = null;
        this.propertyDefs = null;
        for (Scope s : this.scopes) {
            s.removeTmpData();
        }
        Map<Node, String> unknownTypes = this.typeParser.getUnknownTypesMap();
        for (Map.Entry<Node, String> unknownTypeEntry : unknownTypes.entrySet()) {
            this.warnings.add(JSError.make(unknownTypeEntry.getKey(), UNRECOGNIZED_TYPE_NAME, unknownTypeEntry.getValue()));
        }
        for (String warningText : this.typeParser.getWarnings()) {
            this.warnings.add(JSError.make(root, RhinoErrorReporter.BAD_JSDOC_ANNOTATION, warningText));
        }
        this.typeParser = null;
        this.compiler.setSymbolTable(this);
        this.warnings = null;
        Collections.reverse(this.scopes);
    }

    private Collection<PropertyDef> getPropDefsFromInterface(NominalType nominalType, String pname) {
        Preconditions.checkArgument((boolean)nominalType.isFinalized());
        Preconditions.checkArgument((boolean)nominalType.isInterface());
        if (nominalType.getPropDeclaredType(pname) == null) {
            return ImmutableSet.of();
        }
        if (this.propertyDefs.get((Object)nominalType.getId(), (Object)pname) != null) {
            return ImmutableSet.of((Object)this.propertyDefs.get((Object)nominalType.getId(), (Object)pname));
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (NominalType interf : nominalType.getInstantiatedInterfaces()) {
            result.addAll(this.getPropDefsFromInterface(interf, pname));
        }
        return result.build();
    }

    private PropertyDef getPropDefFromClass(NominalType nominalType, String pname) {
        while (nominalType.getPropDeclaredType(pname) != null) {
            Preconditions.checkArgument((boolean)nominalType.isFinalized());
            Preconditions.checkArgument((boolean)nominalType.isClass());
            if (this.propertyDefs.get((Object)nominalType.getId(), (Object)pname) != null) {
                return (PropertyDef)this.propertyDefs.get((Object)nominalType.getId(), (Object)pname);
            }
            nominalType = nominalType.getInstantiatedSuperclass();
        }
        return null;
    }

    private void reportInheritanceErrors() {
        LinkedList<Node> workset = new LinkedList<Node>(this.nominaltypesByNode.keySet());
        int iterations = 0;
        int MAX_ITERATIONS = 50000;
        block0: while (!workset.isEmpty()) {
            Preconditions.checkState((iterations < 50000 ? 1 : 0) != 0);
            Node funNode = (Node)workset.removeFirst();
            NominalType.RawNominalType rawNominalType = this.nominaltypesByNode.get(funNode);
            NominalType superClass = rawNominalType.getSuperClass();
            Set<String> nonInheritedPropNames = rawNominalType.getAllOwnProps();
            if (superClass != null && !superClass.isFinalized()) {
                workset.addLast(funNode);
                ++iterations;
                continue;
            }
            for (NominalType superInterf : rawNominalType.getInterfaces()) {
                if (superInterf.isFinalized()) continue;
                workset.addLast(funNode);
                ++iterations;
                continue block0;
            }
            HashMultimap propMethodTypesToProcess = HashMultimap.create();
            HashMultimap propTypesToProcess = HashMultimap.create();
            if (superClass != null) {
                Preconditions.checkState((boolean)superClass.isFinalized());
                for (String pname : superClass.getAllPropsOfClass()) {
                    nonInheritedPropNames.remove(pname);
                    this.checkSuperProperty(rawNominalType, superClass, pname, (Multimap<String, DeclaredFunctionType>)propMethodTypesToProcess, (Multimap<String, JSType>)propTypesToProcess);
                }
            }
            for (NominalType superInterf : rawNominalType.getInterfaces()) {
                Preconditions.checkState((boolean)superInterf.isFinalized());
                for (String pname : superInterf.getAllPropsOfInterface()) {
                    nonInheritedPropNames.remove(pname);
                    this.checkSuperProperty(rawNominalType, superInterf, pname, (Multimap<String, DeclaredFunctionType>)propMethodTypesToProcess, (Multimap<String, JSType>)propTypesToProcess);
                }
            }
            for (String pname : propMethodTypesToProcess.keySet()) {
                Collection methodTypes = propMethodTypesToProcess.get((Object)pname);
                Preconditions.checkState((!methodTypes.isEmpty() ? 1 : 0) != 0);
                PropertyDef localPropDef = (PropertyDef)this.propertyDefs.get((Object)rawNominalType, (Object)pname);
                DeclaredFunctionType superMethodType = DeclaredFunctionType.meet(methodTypes);
                DeclaredFunctionType updatedMethodType = localPropDef.methodType.withTypeInfoFromSuper(superMethodType);
                localPropDef.updateMethodType(updatedMethodType);
                propTypesToProcess.put((Object)pname, (Object)JSType.fromFunctionType(updatedMethodType.toFunctionType()));
            }
            block6: for (String pname : propTypesToProcess.keySet()) {
                Collection defs = propTypesToProcess.get((Object)pname);
                Preconditions.checkState((!defs.isEmpty() ? 1 : 0) != 0);
                JSType resultType = JSType.TOP;
                for (JSType inheritedType : defs) {
                    if (inheritedType.isSubtypeOf(resultType)) {
                        resultType = inheritedType;
                        continue;
                    }
                    if (resultType.isSubtypeOf(inheritedType)) continue;
                    this.warnings.add(JSError.make(funNode, TypeCheck.INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, NodeUtil.getFunctionName(funNode), pname, "", ""));
                    continue block6;
                }
                rawNominalType.addProtoProperty(pname, resultType, false);
            }
            for (String pname : nonInheritedPropNames) {
                Node defSite = ((PropertyDef)this.propertyDefs.get((Object)rawNominalType, (Object)pname)).defSite;
                JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(defSite);
                if (jsdoc == null || !jsdoc.isOverride()) continue;
                this.warnings.add(JSError.make(defSite, TypeCheck.UNKNOWN_OVERRIDE, pname, rawNominalType.getName()));
            }
            rawNominalType.finalizeNominalType();
        }
    }

    private void checkSuperProperty(NominalType.RawNominalType current, NominalType superType, String pname, Multimap<String, DeclaredFunctionType> propMethodTypesToProcess, Multimap<String, JSType> propTypesToProcess) {
        JSType localPropType;
        JSType inheritedPropType = superType.getPropDeclaredType(pname);
        if (inheritedPropType == null) {
            return;
        }
        ImmutableSet inheritedPropDefs = superType.isInterface() ? this.getPropDefsFromInterface(superType, pname) : ImmutableSet.of((Object)this.getPropDefFromClass(superType, pname));
        if (superType.isInterface() && current.isClass() && !current.mayHaveProp(pname)) {
            this.warnings.add(JSError.make(((PropertyDef)inheritedPropDefs.iterator().next()).defSite, TypeValidator.INTERFACE_METHOD_NOT_IMPLEMENTED, pname, superType.toString(), current.toString()));
            return;
        }
        PropertyDef localPropDef = (PropertyDef)this.propertyDefs.get((Object)current, (Object)pname);
        JSType jSType = localPropType = localPropDef == null ? null : current.getPropDeclaredType(pname);
        if (localPropDef != null && superType.isClass() && localPropType.getFunType() != null && superType.hasConstantProp(pname)) {
            this.warnings.add(JSError.make(localPropDef.defSite, CANNOT_OVERRIDE_FINAL_METHOD, pname));
            return;
        }
        if (localPropType != null && !localPropType.isSubtypeOf(inheritedPropType)) {
            this.warnings.add(JSError.make(localPropDef.defSite, INVALID_PROP_OVERRIDE, pname, inheritedPropType.toString(), localPropType.toString()));
        } else if (localPropType == null) {
            propTypesToProcess.put((Object)pname, (Object)inheritedPropType);
        } else if (localPropDef.methodType != null) {
            for (PropertyDef inheritedPropDef : inheritedPropDefs) {
                if (inheritedPropDef.methodType == null) continue;
                propMethodTypesToProcess.put((Object)pname, (Object)inheritedPropDef.methodType);
            }
        }
    }

    private JSType getTypeDeclarationFromJsdoc(JSDocInfo jsdoc, Scope s) {
        return this.typeParser.getNodeTypeDeclaration(jsdoc, null, s);
    }

    private static boolean isClassPropAccess(Node n, Scope s) {
        return n.isGetProp() && n.getFirstChild().isThis() && (s.isConstructor() || s.isPrototypeMethod());
    }

    private static boolean isStaticCtorProp(Node getProp, Scope s) {
        Preconditions.checkArgument((boolean)getProp.isGetProp());
        if (!getProp.isQualifiedName()) {
            return false;
        }
        String receiverObjName = getProp.getFirstChild().getQualifiedName();
        if (!s.isLocalFunDef(receiverObjName)) {
            return false;
        }
        DeclaredFunctionType ctorType = s.getScope(receiverObjName).getDeclaredType();
        return ctorType != null && ctorType.getNominalType() != null;
    }

    private static boolean isPropertyDeclaration(Node getProp) {
        Preconditions.checkArgument((boolean)getProp.isGetProp());
        Node parent = getProp.getParent();
        return parent.isExprResult() || parent.isAssign() && parent.getParent().isExprResult();
    }

    private static boolean isPrototypeProperty(Node getProp) {
        if (!getProp.isGetProp()) {
            return false;
        }
        Node recv = getProp.getFirstChild();
        return recv.isGetProp() && recv.getLastChild().getString().equals("prototype");
    }

    private static boolean isPrototypePropertyDeclaration(Node n) {
        return NodeUtil.isExprAssign(n) && GlobalTypeInfo.isPrototypeProperty(n.getFirstChild().getFirstChild());
    }

    static class Scope
    implements DeclaredTypeRegistry {
        private final Scope parent;
        private final Node root;
        private final String name;
        private final Map<String, JSType> locals = new HashMap<String, JSType>();
        private final Set<String> constVars = new HashSet<String>();
        private final List<String> formals;
        private final Set<String> outerVars = new HashSet<String>();
        private final Map<String, Scope> localFunDefs = new HashMap<String, Scope>();
        private Map<String, NominalType.RawNominalType> localClassDefs = new HashMap<String, NominalType.RawNominalType>();
        private Map<String, Typedef> localTypedefs = new HashMap<String, Typedef>();
        private Map<String, EnumType> localEnums = new HashMap<String, EnumType>();
        private Map<String, NamespaceLit> localNamespaces = new HashMap<String, NamespaceLit>();
        private Set<EnumType> qualifiedEnums = new HashSet<EnumType>();
        private DeclaredFunctionType declaredType;

        private Scope(Node root, Scope parent, List<String> formals) {
            String nameOnAst;
            this.name = parent == null ? null : ((nameOnAst = root.getFirstChild().getString()).isEmpty() ? null : nameOnAst);
            this.root = root;
            this.parent = parent;
            this.formals = formals;
        }

        private void setDeclType(DeclaredFunctionType declaredType) {
            this.declaredType = declaredType;
        }

        Node getRoot() {
            return this.root;
        }

        private Node getBody() {
            Preconditions.checkArgument((boolean)this.root.isFunction());
            return NodeUtil.getFunctionBody(this.root);
        }

        String getReadableName() {
            return this.parent == null ? null : NodeUtil.getFunctionName(this.root);
        }

        String getName() {
            return this.name;
        }

        private void setDeclaredType(DeclaredFunctionType declaredType) {
            this.declaredType = declaredType;
        }

        DeclaredFunctionType getDeclaredType() {
            return this.declaredType;
        }

        boolean isFunction() {
            return this.root.isFunction();
        }

        private boolean isConstructor() {
            if (!this.root.isFunction()) {
                return false;
            }
            JSDocInfo fnDoc = NodeUtil.getFunctionJSDocInfo(this.root);
            return fnDoc != null && fnDoc.isConstructor();
        }

        private boolean isPrototypeMethod() {
            Preconditions.checkArgument((this.root != null ? 1 : 0) != 0);
            return NodeUtil.isPrototypeMethod(this.root);
        }

        private void addLocalFunDef(String name, Scope scope) {
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            Preconditions.checkArgument((!this.isDefinedLocally(name) ? 1 : 0) != 0);
            this.localFunDefs.put(name, scope);
        }

        boolean isFormalParam(String name) {
            return this.formals.contains(name);
        }

        boolean isLocalVar(String name) {
            return this.locals.containsKey(name);
        }

        boolean isLocalFunDef(String name) {
            return this.localFunDefs.containsKey(name);
        }

        boolean isDefinedLocally(String name) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkState((!name.contains(".") ? 1 : 0) != 0);
            return this.locals.containsKey(name) || this.formals.contains(name) || this.localFunDefs.containsKey(name) || "this".equals(name) || this.localNamespaces != null && this.localNamespaces.containsKey(name) || this.localTypedefs != null && this.localTypedefs.containsKey(name) || this.localEnums != null && this.localEnums.containsKey(name);
        }

        private boolean isDefined(Node qnameNode) {
            Preconditions.checkArgument((boolean)qnameNode.isQualifiedName());
            if (qnameNode.isThis()) {
                return true;
            }
            if (qnameNode.isName()) {
                return this.isDefinedLocally(qnameNode.getString());
            }
            QualifiedName qname = QualifiedName.fromGetprop(qnameNode);
            String leftmost = qname.getLeftmostName();
            if (this.isNamespace(leftmost)) {
                return this.getNamespace(leftmost).isDefined(qname.getAllButLeftmost());
            }
            return this.parent == null ? null : Boolean.valueOf(this.parent.isDefined(qnameNode));
        }

        private boolean isNamespace(Node expr) {
            if (expr.isName()) {
                return this.isNamespace(expr.getString());
            }
            if (!expr.isGetProp()) {
                return false;
            }
            QualifiedName qname = QualifiedName.fromGetprop(expr);
            if (qname == null) {
                return false;
            }
            String leftmost = qname.getLeftmostName();
            if (!this.isNamespace(leftmost)) {
                return false;
            }
            return this.getNamespace(leftmost).hasSubnamespace(qname.getAllButLeftmost());
        }

        private boolean isNamespaceLiteral(String name) {
            return this.localNamespaces.containsKey(name);
        }

        private boolean isNamespace(String name) {
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            return this.localNamespaces.containsKey(name) || this.localClassDefs.containsKey(name) || this.localEnums.containsKey(name) || this.parent != null && this.parent.isNamespace(name);
        }

        private boolean isVisibleInScope(String name) {
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            return this.isDefinedLocally(name) || name.equals(this.name) || this.parent != null && this.parent.isVisibleInScope(name);
        }

        boolean isConstVar(String name) {
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            return this.constVars.contains(name) || this.parent != null && this.parent.isConstVar(name);
        }

        private boolean isOuterVarEarly(String name) {
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            return !this.isDefinedLocally(name) && this.parent != null && this.parent.isVisibleInScope(name);
        }

        boolean isUndeclaredFormal(String name) {
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            return this.formals.contains(name) && this.getDeclaredTypeOf(name) == null;
        }

        List<String> getFormals() {
            return new ArrayList<String>(this.formals);
        }

        Set<String> getOuterVars() {
            return new HashSet<String>(this.outerVars);
        }

        Set<String> getLocalFunDefs() {
            return new HashSet<String>(this.localFunDefs.keySet());
        }

        boolean isOuterVar(String name) {
            return this.outerVars.contains(name);
        }

        boolean hasThis() {
            return this.isFunction() && this.getDeclaredType().getThisType() != null;
        }

        private NominalType.RawNominalType getNominalType(QualifiedName qname) {
            if (qname.isIdentifier()) {
                String name = qname.getLeftmostName();
                NominalType.RawNominalType rnt = this.localClassDefs.get(name);
                if (rnt != null) {
                    return rnt;
                }
                return this.parent == null ? null : this.parent.getNominalType(qname);
            }
            Namespace ns = this.getNamespace(qname.getLeftmostName());
            if (ns == null) {
                return null;
            }
            return ns.getNominalType(qname.getAllButLeftmost());
        }

        @Override
        public JSType lookupTypeByName(String name) {
            if (name.contains(".")) {
                QualifiedName qname = QualifiedName.fromQname(name);
                Namespace ns = this.getNamespace(qname.getLeftmostName());
                if (ns == null) {
                    return null;
                }
                NominalType.RawNominalType rawType = ns.getNominalType(qname.getAllButLeftmost());
                if (rawType == null) {
                    return null;
                }
                return rawType.getInstanceAsJSType();
            }
            if (this.declaredType != null && this.declaredType.isGeneric() && this.declaredType.getTypeParameters().contains((Object)name)) {
                return JSType.fromTypeVar(name);
            }
            NominalType.RawNominalType rawNominalType = this.localClassDefs.get(name);
            if (rawNominalType != null) {
                return rawNominalType.getInstanceAsJSType();
            }
            return this.parent == null ? null : this.parent.lookupTypeByName(name);
        }

        JSType getDeclaredTypeOf(String name) {
            Namespace ns;
            Preconditions.checkArgument((name.indexOf(46) == -1 ? 1 : 0) != 0);
            if ("this".equals(name)) {
                if (!this.hasThis()) {
                    return null;
                }
                return JSType.fromObjectType(ObjectType.fromNominalType(this.getDeclaredType().getThisType()));
            }
            int formalIndex = this.formals.indexOf(name);
            if (formalIndex != -1) {
                JSType formalType = this.declaredType.getFormalType(formalIndex);
                if (formalType == null || formalType.isBottom()) {
                    return null;
                }
                return formalType;
            }
            JSType localType = this.locals.get(name);
            if (localType != null) {
                Preconditions.checkState((!localType.isBottom() ? 1 : 0) != 0);
                return localType;
            }
            Scope s = this.localFunDefs.get(name);
            if (s != null && s.getDeclaredType() != null) {
                return JSType.fromFunctionType(s.getDeclaredType().toFunctionType());
            }
            if (name.equals(this.name)) {
                return JSType.fromFunctionType(this.getDeclaredType().toFunctionType());
            }
            if (this.localNamespaces != null && (ns = (Namespace)this.localNamespaces.get(name)) != null) {
                return ns.toJSType();
            }
            if (this.parent != null) {
                return this.parent.getDeclaredTypeOf(name);
            }
            return null;
        }

        boolean hasUndeclaredFormalsOrOuters() {
            for (String formal : this.formals) {
                if (this.getDeclaredTypeOf(formal) != null) continue;
                return true;
            }
            for (String outer : this.outerVars) {
                JSType declType = this.getDeclaredTypeOf(outer);
                if (declType != null && (declType.getFunType() == null || !declType.getFunType().getReturnType().isUnknown())) continue;
                return true;
            }
            return false;
        }

        private Scope getScopeHelper(String fnName) {
            Scope s = this.localFunDefs.get(fnName);
            if (s != null) {
                return s;
            }
            if (this.parent != null && !this.isDefinedLocally(fnName)) {
                return this.parent.getScopeHelper(fnName);
            }
            return null;
        }

        boolean isKnownFunction(String fnName) {
            return this.getScopeHelper(fnName) != null;
        }

        Scope getScope(String fnName) {
            Scope s = this.getScopeHelper(fnName);
            Preconditions.checkState((s != null ? 1 : 0) != 0);
            return s;
        }

        Set<String> getLocals() {
            return ImmutableSet.copyOf(this.locals.keySet());
        }

        private void addLocal(String name, JSType declType, boolean isConstant) {
            Preconditions.checkArgument((!this.isDefinedLocally(name) ? 1 : 0) != 0);
            if (isConstant) {
                this.constVars.add(name);
            }
            this.locals.put(name, declType);
        }

        private void addNamespace(Node qnameNode) {
            Preconditions.checkArgument((!this.isNamespace(qnameNode) ? 1 : 0) != 0);
            if (qnameNode.isName()) {
                String name = qnameNode.getString();
                this.localNamespaces.put(name, new NamespaceLit());
            } else {
                QualifiedName qname = QualifiedName.fromGetprop(qnameNode);
                String leftmost = qname.getLeftmostName();
                Namespace ns = this.getNamespace(leftmost);
                ns.addSubnamespace(qname.getAllButLeftmost());
            }
        }

        private void updateType(String name, JSType newDeclType) {
            if (this.locals.containsKey(name)) {
                this.locals.put(name, newDeclType);
            } else if (this.parent != null) {
                this.parent.updateType(name, newDeclType);
            } else {
                throw new RuntimeException("Cannot update type of unknown variable: " + name);
            }
        }

        private void addOuterVar(String name) {
            this.outerVars.add(name);
        }

        private void addNominalType(Node qnameNode, NominalType.RawNominalType rawNominalType) {
            if (qnameNode.isName()) {
                Preconditions.checkState((!this.localClassDefs.containsKey(qnameNode.getString()) ? 1 : 0) != 0);
                this.localClassDefs.put(qnameNode.getString(), rawNominalType);
            } else {
                Preconditions.checkArgument((!this.isDefined(qnameNode) ? 1 : 0) != 0);
                QualifiedName qname = QualifiedName.fromGetprop(qnameNode);
                Namespace ns = this.getNamespace(qname.getLeftmostName());
                ns.addNominalType(qname.getAllButLeftmost(), rawNominalType);
            }
        }

        private void addTypedef(Node qnameNode, Typedef td) {
            if (qnameNode.isName()) {
                Preconditions.checkState((!this.localTypedefs.containsKey(qnameNode.getString()) ? 1 : 0) != 0);
                this.localTypedefs.put(qnameNode.getString(), td);
            } else {
                Preconditions.checkState((!this.isDefined(qnameNode) ? 1 : 0) != 0);
                QualifiedName qname = QualifiedName.fromGetprop(qnameNode);
                Namespace ns = this.getNamespace(qname.getLeftmostName());
                ns.addTypedef(qname.getAllButLeftmost(), td);
            }
        }

        @Override
        public Typedef getTypedef(String name) {
            if (!name.contains(".")) {
                if (this.isDefinedLocally(name)) {
                    return this.localTypedefs.get(name);
                }
            } else {
                QualifiedName qname = QualifiedName.fromQname(name);
                Namespace ns = this.getNamespace(qname.getLeftmostName());
                if (ns != null) {
                    return ns.getTypedef(qname.getAllButLeftmost());
                }
            }
            if (this.parent != null) {
                return this.parent.getTypedef(name);
            }
            return null;
        }

        private void addEnum(Node qnameNode, EnumType e) {
            if (qnameNode.isName()) {
                Preconditions.checkState((!this.localEnums.containsKey(qnameNode.getString()) ? 1 : 0) != 0);
                this.localEnums.put(qnameNode.getString(), e);
            } else {
                Preconditions.checkState((!this.isDefined(qnameNode) ? 1 : 0) != 0);
                QualifiedName qname = QualifiedName.fromGetprop(qnameNode);
                Namespace ns = this.getNamespace(qname.getLeftmostName());
                ns.addEnum(qname.getAllButLeftmost(), e);
                this.qualifiedEnums.add(e);
            }
        }

        @Override
        public EnumType getEnum(String name) {
            if (!name.contains(".")) {
                if (this.isDefinedLocally(name)) {
                    return this.localEnums.get(name);
                }
            } else {
                QualifiedName qname = QualifiedName.fromQname(name);
                Namespace ns = this.getNamespace(qname.getLeftmostName());
                if (ns != null) {
                    return ns.getEnumType(qname.getAllButLeftmost());
                }
            }
            if (this.parent != null) {
                return this.parent.getEnum(name);
            }
            return null;
        }

        private Namespace getNamespace(String name) {
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            Namespace ns = this.localNamespaces.get(name);
            if (ns != null) {
                return ns;
            }
            ns = this.localClassDefs.get(name);
            if (ns != null) {
                return ns;
            }
            ns = this.localEnums.get(name);
            if (ns != null) {
                return ns;
            }
            return this.parent == null ? null : this.parent.getNamespace(name);
        }

        private void resolveTypedefs(JSTypeCreatorFromJSDoc typeParser) {
            for (Typedef td : this.localTypedefs.values()) {
                if (td.isResolved()) continue;
                typeParser.resolveTypedef(td, this);
            }
        }

        private void resolveEnums(JSTypeCreatorFromJSDoc typeParser) {
            for (EnumType e : this.localEnums.values()) {
                if (e.isResolved()) continue;
                typeParser.resolveEnum(e, this);
            }
            for (EnumType e : this.qualifiedEnums) {
                if (e.isResolved()) continue;
                typeParser.resolveEnum(e, this);
            }
            this.qualifiedEnums = null;
        }

        private void sanityCheck() {
            Set<String> names = this.localFunDefs.keySet();
            for (String s : this.localClassDefs.keySet()) {
                Preconditions.checkState((boolean)names.contains(s));
            }
            names = this.locals.keySet();
            for (String s : this.constVars) {
                Preconditions.checkState((boolean)names.contains(s));
            }
            for (String s : this.localNamespaces.keySet()) {
                Preconditions.checkState((boolean)names.contains(s));
            }
            names = new HashSet<String>(this.formals);
            for (String s : this.locals.keySet()) {
                Preconditions.checkState((!names.contains(s) ? 1 : 0) != 0, (String)"Name %s is defined twice.", (Object[])new Object[]{s});
                names.add(s);
            }
            for (String s : this.localFunDefs.keySet()) {
                Preconditions.checkState((!names.contains(s) ? 1 : 0) != 0, (String)"Name %s is defined twice.", (Object[])new Object[]{s});
                names.add(s);
            }
            for (String s : this.localTypedefs.keySet()) {
                Preconditions.checkState((!names.contains(s) ? 1 : 0) != 0, (String)"Name %s is defined twice.", (Object[])new Object[]{s});
            }
        }

        private void removeTmpData() {
            Iterator<String> it = this.localFunDefs.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next();
                if (!name.contains(".")) continue;
                it.remove();
            }
            for (Map.Entry<String, NamespaceLit> entry : this.localNamespaces.entrySet()) {
                this.locals.put(entry.getKey(), entry.getValue().toJSType());
            }
            for (Map.Entry<String, Namespace> entry : this.localEnums.entrySet()) {
                this.locals.put(entry.getKey(), ((EnumType)entry.getValue()).toJSType());
            }
            this.localNamespaces = null;
            this.localClassDefs = null;
            this.localTypedefs = null;
            this.localEnums = null;
        }
    }

    private static class PropertyDef {
        final Node defSite;
        DeclaredFunctionType methodType;
        final Scope methodScope;

        PropertyDef(Node defSite, DeclaredFunctionType methodType, Scope methodScope) {
            Preconditions.checkArgument((boolean)defSite.isGetProp());
            this.defSite = defSite;
            this.methodType = methodType;
            this.methodScope = methodScope;
        }

        void updateMethodType(DeclaredFunctionType updatedType) {
            this.methodType = updatedType;
            if (this.methodScope != null) {
                this.methodScope.setDeclaredType(updatedType);
            }
        }
    }

    private class ProcessScope
    extends NodeTraversal.AbstractShallowCallback {
        private final Scope currentScope;
        private final Multimap<String, Node> undeclaredVars;
        private Set<Node> lendsObjlits = new HashSet<Node>();

        ProcessScope(Scope currentScope) {
            this.currentScope = currentScope;
            this.undeclaredVars = HashMultimap.create();
        }

        void finishProcessingScope() {
            for (Node objlit : this.lendsObjlits) {
                this.processLendsNode(objlit);
            }
            this.lendsObjlits = null;
        }

        void processLendsNode(Node objlit) {
            JSDocInfo jsdoc = objlit.getJSDocInfo();
            String lendsName = jsdoc.getLendsName();
            Preconditions.checkNotNull((Object)lendsName);
            Preconditions.checkState((!lendsName.contains(".") ? 1 : 0) != 0);
            JSType borrowerType = this.currentScope.getDeclaredTypeOf(lendsName);
            if (borrowerType == null || borrowerType.isUnknown()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(objlit, TypedScopeCreator.LENDS_ON_NON_OBJECT, lendsName, "unknown"));
                return;
            }
            if (!borrowerType.isSubtypeOf(JSType.TOP_OBJECT)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(objlit, TypedScopeCreator.LENDS_ON_NON_OBJECT, lendsName, borrowerType.toString()));
                return;
            }
            if (!this.currentScope.isNamespace(lendsName)) {
                return;
            }
            Namespace borrowerNamespace = this.currentScope.getNamespace(lendsName);
            for (Node prop : objlit.children()) {
                String pname = NodeUtil.getObjectLitKeyName(prop);
                JSType propDeclType = (JSType)GlobalTypeInfo.this.declaredObjLitProps.get(prop);
                if (propDeclType != null) {
                    borrowerNamespace.addProperty(pname, propDeclType, false);
                    continue;
                }
                JSType t = this.simpleInferExprType(prop.getFirstChild());
                if (t == null) {
                    t = JSType.UNKNOWN;
                }
                borrowerNamespace.addProperty(pname, t, false);
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 105: {
                    Node grandparent = parent.getParent();
                    if (grandparent != null && GlobalTypeInfo.isPrototypePropertyDeclaration(grandparent)) break;
                    this.visitFunctionLate(n, null);
                    break;
                }
                case 38: {
                    String name = n.getString();
                    if (name == null || "undefined".equals(name) || parent.isFunction()) {
                        return;
                    }
                    if (parent.isVar() || parent.isCatch()) {
                        if (NodeUtil.isNamespaceDecl(n) || NodeUtil.isTypedefDecl(n) || NodeUtil.isEnumDecl(n)) {
                            if (this.currentScope.isDefinedLocally(name)) break;
                            this.currentScope.addLocal(name, JSType.UNKNOWN, false);
                            break;
                        }
                        Node initializer = n.getFirstChild();
                        if (initializer != null && initializer.isFunction() || this.currentScope.isDefinedLocally(name)) break;
                        this.undeclaredVars.removeAll((Object)name);
                        if (parent.isCatch()) {
                            this.currentScope.addLocal(name, JSType.UNKNOWN, false);
                            break;
                        }
                        boolean isConst = NodeUtil.hasConstAnnotation(parent);
                        JSType declType = this.getVarTypeFromAnnotation(n);
                        if (isConst && !this.mayWarnAboutNoInit(n) && declType == null) {
                            declType = this.inferConstTypeFromRhs(n);
                        }
                        this.currentScope.addLocal(name, declType, isConst);
                        break;
                    }
                    if (this.currentScope.isOuterVarEarly(name)) {
                        this.currentScope.addOuterVar(name);
                        break;
                    }
                    if (this.currentScope.getTypedef(name) == null && (name.equals(this.currentScope.getName()) || this.currentScope.isDefinedLocally(name))) break;
                    this.undeclaredVars.put((Object)name, (Object)n);
                    break;
                }
                case 33: {
                    if (!parent.isExprResult()) break;
                    this.visitPropertyDeclaration(n);
                    break;
                }
                case 86: {
                    Node lvalue = n.getFirstChild();
                    if (!lvalue.isGetProp() || !parent.isExprResult()) break;
                    this.visitPropertyDeclaration(lvalue);
                    break;
                }
                case 155: {
                    GlobalTypeInfo.this.castTypes.put(n, GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(n.getJSDocInfo(), this.currentScope));
                    break;
                }
                case 64: {
                    JSDocInfo jsdoc = n.getJSDocInfo();
                    if (jsdoc != null && jsdoc.getLendsName() != null) {
                        this.lendsObjlits.add(n);
                    }
                    for (Node prop : n.children()) {
                        if (prop.getJSDocInfo() != null) {
                            GlobalTypeInfo.this.declaredObjLitProps.put(prop, GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(prop.getJSDocInfo(), this.currentScope));
                        }
                        if (!NodeUtil.hasConstAnnotation(prop)) continue;
                        GlobalTypeInfo.this.warnings.add(JSError.make(prop, MISPLACED_CONST_ANNOTATION, new String[0]));
                    }
                    break;
                }
            }
        }

        private void visitPropertyDeclaration(Node getProp) {
            if (GlobalTypeInfo.isClassPropAccess(getProp, this.currentScope)) {
                if (NodeUtil.hasConstAnnotation(getProp) && this.currentScope.isPrototypeMethod()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(getProp, MISPLACED_CONST_ANNOTATION, new String[0]));
                }
                this.visitClassPropertyDeclaration(getProp);
                return;
            }
            if (GlobalTypeInfo.isPropertyDeclaration(getProp) && GlobalTypeInfo.isPrototypeProperty(getProp)) {
                this.visitPrototypePropertyDeclaration(getProp);
                return;
            }
            if (GlobalTypeInfo.isPropertyDeclaration(getProp) && GlobalTypeInfo.isStaticCtorProp(getProp, this.currentScope)) {
                this.visitConstructorPropertyDeclaration(getProp);
                return;
            }
            if (GlobalTypeInfo.isPropertyDeclaration(getProp) && this.currentScope.isNamespace(getProp.getFirstChild())) {
                this.visitNamespacePropertyDeclaration(getProp);
                return;
            }
            if (NodeUtil.hasConstAnnotation(getProp)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(getProp, MISPLACED_CONST_ANNOTATION, new String[0]));
            }
        }

        private Scope visitFunctionLate(Node fn, NominalType.RawNominalType ownerType) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            String fnName = NodeUtil.getFunctionName(fn);
            if (fnName != null && !fnName.contains(".")) {
                this.undeclaredVars.removeAll((Object)fnName);
            }
            String internalName = GlobalTypeInfo.this.getFunInternalName(fn);
            Scope fnScope = this.currentScope.getScope(internalName);
            this.updateFnScope(fnScope, ownerType);
            return fnScope;
        }

        private void visitPrototypePropertyDeclaration(Node getProp) {
            JSType propDeclType;
            DeclaredFunctionType methodType;
            Scope methodScope;
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Node parent = getProp.getParent();
            Node initializer = parent.isAssign() ? parent.getLastChild() : null;
            Node ctorNameNode = NodeUtil.getPrototypeClassName(getProp);
            QualifiedName ctorQname = QualifiedName.fromGetprop(ctorNameNode);
            NominalType.RawNominalType rawType = this.currentScope.getNominalType(ctorQname);
            if (rawType == null) {
                if (initializer != null && initializer.isFunction()) {
                    this.visitFunctionLate(initializer, null);
                }
                return;
            }
            if (!this.currentScope.isDefined(ctorNameNode)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(getProp, CTOR_IN_DIFFERENT_SCOPE, new String[0]));
                if (initializer != null && initializer.isFunction()) {
                    this.visitFunctionLate(initializer, rawType);
                }
                return;
            }
            String pname = NodeUtil.getPrototypePropertyName(getProp);
            if (initializer != null && initializer.isFunction()) {
                methodScope = this.visitFunctionLate(initializer, rawType);
                methodType = methodScope.getDeclaredType();
                propDeclType = JSType.fromFunctionType(methodType.toFunctionType());
            } else {
                methodScope = null;
                JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getProp);
                if (jsdoc != null && jsdoc.containsFunctionDeclaration()) {
                    methodType = this.computeFnDeclaredType(jsdoc, pname, getProp, rawType, this.currentScope);
                    propDeclType = JSType.fromFunctionType(methodType.toFunctionType());
                } else if (jsdoc != null && jsdoc.hasType()) {
                    methodType = null;
                    propDeclType = GlobalTypeInfo.this.typeParser.getNodeTypeDeclaration(jsdoc, rawType, this.currentScope);
                } else {
                    methodType = null;
                    propDeclType = null;
                }
            }
            GlobalTypeInfo.this.propertyDefs.put((Object)rawType, (Object)pname, (Object)new PropertyDef(getProp, methodType, methodScope));
            boolean isConst = NodeUtil.hasConstAnnotation(getProp);
            if (propDeclType != null || isConst) {
                if (this.mayWarnAboutExistingProp(rawType, pname, getProp, propDeclType)) {
                    return;
                }
                if (isConst && !this.mayWarnAboutNoInit(getProp) && propDeclType == null) {
                    propDeclType = this.inferConstTypeFromRhs(getProp);
                }
                rawType.addProtoProperty(pname, propDeclType, isConst);
                getProp.putBooleanProp(75, true);
            } else {
                rawType.addUndeclaredProtoProperty(pname);
            }
        }

        private void visitConstructorPropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            String ctorName = getProp.getFirstChild().getQualifiedName();
            QualifiedName ctorQname = QualifiedName.fromGetprop(getProp.getFirstChild());
            Preconditions.checkState((boolean)this.currentScope.isLocalFunDef(ctorName));
            NominalType.RawNominalType classType = this.currentScope.getNominalType(ctorQname);
            String pname = getProp.getLastChild().getString();
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getProp);
            JSType propDeclType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(jsdoc, this.currentScope);
            boolean isConst = NodeUtil.hasConstAnnotation(getProp);
            if (propDeclType != null || isConst) {
                JSType previousPropType = classType.getCtorPropDeclaredType(pname);
                if (classType.hasCtorProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, propDeclType, previousPropType)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(getProp, REDECLARED_PROPERTY, pname, classType.toString()));
                    return;
                }
                if (isConst && !this.mayWarnAboutNoInit(getProp) && propDeclType == null) {
                    propDeclType = this.inferConstTypeFromRhs(getProp);
                }
                classType.addCtorProperty(pname, propDeclType, isConst);
                getProp.putBooleanProp(75, true);
            } else {
                classType.addUndeclaredCtorProperty(pname);
            }
        }

        private void visitNamespacePropertyDeclaration(Node getProp) {
            Namespace ns;
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            if (this.currentScope.isNamespace(getProp) || NodeUtil.isTypedefDecl(getProp)) {
                return;
            }
            Node nsNameNode = getProp.getFirstChild();
            Preconditions.checkState((boolean)this.currentScope.isNamespace(nsNameNode));
            if (nsNameNode.isName()) {
                ns = this.currentScope.getNamespace(nsNameNode.getString());
            } else {
                QualifiedName nsQname = QualifiedName.fromGetprop(nsNameNode);
                ns = this.currentScope.getNamespace(nsQname.getLeftmostName()).getSubnamespace(nsQname.getAllButLeftmost());
            }
            String pname = getProp.getLastChild().getString();
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getProp);
            JSType propDeclType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(jsdoc, this.currentScope);
            boolean isConst = NodeUtil.hasConstAnnotation(getProp);
            if (propDeclType != null || isConst) {
                JSType previousPropType = ns.getPropDeclaredType(pname);
                if (ns.hasProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, propDeclType, previousPropType)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(getProp, REDECLARED_PROPERTY, pname, ns.toString()));
                    return;
                }
                if (isConst && !this.mayWarnAboutNoInit(getProp) && propDeclType == null) {
                    propDeclType = this.inferConstTypeFromRhs(getProp);
                }
                ns.addProperty(pname, propDeclType, isConst);
                getProp.putBooleanProp(75, true);
            } else {
                JSType t = this.simpleInferExprType(getProp.getParent().getLastChild());
                if (t == null) {
                    t = JSType.UNKNOWN;
                }
                ns.addUndeclaredProperty(pname, t, isConst);
            }
        }

        private void visitClassPropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            NominalType thisType = this.currentScope.getDeclaredType().getThisType();
            if (thisType == null) {
                return;
            }
            NominalType.RawNominalType rawNominalType = thisType.getRawNominalType();
            String pname = getProp.getLastChild().getString();
            JSType declType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(NodeUtil.getBestJSDocInfo(getProp), this.currentScope);
            boolean isConst = NodeUtil.hasConstAnnotation(getProp);
            if (declType != null || isConst) {
                this.mayWarnAboutExistingProp(rawNominalType, pname, getProp, declType);
                if (isConst && !this.mayWarnAboutNoInit(getProp) && declType == null) {
                    declType = this.inferConstTypeFromRhs(getProp);
                }
                if (this.mayAddPropToType(getProp, rawNominalType)) {
                    rawNominalType.addClassProperty(pname, declType, isConst);
                }
            } else if (this.mayAddPropToType(getProp, rawNominalType)) {
                rawNominalType.addUndeclaredClassProperty(pname);
            }
            GlobalTypeInfo.this.propertyDefs.put((Object)rawNominalType, (Object)pname, (Object)new PropertyDef(getProp, null, null));
        }

        boolean mayWarnAboutNoInit(Node constExpr) {
            if (constExpr.isFromExterns()) {
                return false;
            }
            boolean noInit = true;
            if (constExpr.isName()) {
                Preconditions.checkState((boolean)constExpr.getParent().isVar());
                noInit = constExpr.getFirstChild() == null;
            } else {
                Preconditions.checkState((boolean)constExpr.isGetProp());
                boolean bl = noInit = !constExpr.getParent().isAssign();
            }
            if (noInit) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, CONST_WITHOUT_INITIALIZER, new String[0]));
                return true;
            }
            return false;
        }

        private JSType inferConstTypeFromRhs(Node constExpr) {
            Node rhs;
            if (constExpr.isFromExterns()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, COULD_NOT_INFER_CONST_TYPE, new String[0]));
                return null;
            }
            if (constExpr.isName()) {
                Preconditions.checkState((boolean)constExpr.getParent().isVar());
                rhs = constExpr.getFirstChild();
            } else {
                Preconditions.checkState((constExpr.isGetProp() && constExpr.getParent().isAssign() ? 1 : 0) != 0);
                rhs = constExpr.getParent().getLastChild();
            }
            JSType rhsType = this.simpleInferExprType(rhs);
            if (rhsType == null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, COULD_NOT_INFER_CONST_TYPE, new String[0]));
                return null;
            }
            return rhsType;
        }

        private JSType simpleInferExprType(Node n) {
            switch (n.getType()) {
                case 9: 
                case 10: 
                case 11: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 39: 
                case 102: 
                case 103: {
                    return JSType.NUMBER;
                }
                case 32: 
                case 40: {
                    return JSType.STRING;
                }
                case 44: {
                    return JSType.TRUE_TYPE;
                }
                case 43: {
                    return JSType.FALSE_TYPE;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 26: 
                case 45: 
                case 46: 
                case 51: 
                case 52: {
                    return JSType.BOOLEAN;
                }
                case 41: {
                    return JSType.NULL;
                }
                case 122: {
                    return JSType.UNDEFINED;
                }
                case 38: {
                    String varName = n.getString();
                    if (varName.equals("undefined")) {
                        return JSType.UNDEFINED;
                    }
                    if (this.currentScope.isNamespaceLiteral(varName)) {
                        return null;
                    }
                    return this.currentScope.getDeclaredTypeOf(varName);
                }
                case 64: {
                    JSType objLitType = JSType.TOP_OBJECT;
                    for (Node prop : n.children()) {
                        JSType propType = this.simpleInferExprType(prop.getFirstChild());
                        if (propType == null) {
                            return null;
                        }
                        objLitType = objLitType.withProperty(new QualifiedName(NodeUtil.getObjectLitKeyName(prop)), propType);
                    }
                    return objLitType;
                }
                case 33: {
                    JSType recvType = this.simpleInferExprType(n.getFirstChild());
                    if (recvType == null) {
                        return null;
                    }
                    QualifiedName qname = new QualifiedName(n.getLastChild().getString());
                    if (!recvType.mayHaveProp(qname)) {
                        return null;
                    }
                    return recvType.getProp(qname);
                }
                case 85: {
                    return this.simpleInferExprType(n.getLastChild());
                }
                case 30: 
                case 37: {
                    JSType ratorType = this.simpleInferExprType(n.getFirstChild());
                    if (ratorType == null) {
                        return null;
                    }
                    FunctionType funType = ratorType.getFunType();
                    return funType == null ? null : funType.getReturnType();
                }
            }
            return null;
        }

        private boolean mayAddPropToType(Node getProp, NominalType.RawNominalType rawType) {
            if (!rawType.isStruct()) {
                return true;
            }
            Node parent = getProp.getParent();
            return parent.isAssign() && getProp == parent.getFirstChild() && this.currentScope.isConstructor();
        }

        private boolean mayWarnAboutExistingProp(NominalType.RawNominalType classType, String pname, Node propCreationNode, JSType typeInJsdoc) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(propCreationNode);
            JSType previousPropType = classType.getPropDeclaredType(pname);
            if (classType.mayHaveOwnProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, typeInJsdoc, previousPropType)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(propCreationNode, REDECLARED_PROPERTY, pname, classType.toString()));
                return true;
            }
            return false;
        }

        private boolean suppressDupPropWarning(JSDocInfo propCreationJsdoc, JSType typeInJsdoc, JSType previousType) {
            if (propCreationJsdoc == null || !propCreationJsdoc.getSuppressions().contains("duplicate")) {
                return false;
            }
            return typeInJsdoc != null && previousType != null && typeInJsdoc.equals(previousType);
        }

        private DeclaredFunctionType computeFnDeclaredType(JSDocInfo fnDoc, String functionName, Node declNode, NominalType.RawNominalType ownerType, Scope parentScope) {
            Preconditions.checkArgument((declNode.isFunction() || declNode.isGetProp() ? 1 : 0) != 0);
            ImmutableList<String> typeParameters = fnDoc == null ? null : fnDoc.getTemplateTypeNames();
            FunctionTypeBuilder builder = GlobalTypeInfo.this.typeParser.getFunctionType(fnDoc, declNode, ownerType, parentScope);
            NominalType.RawNominalType ctorType = null;
            if (fnDoc != null) {
                NominalType parentClass = null;
                if (fnDoc.hasBaseType()) {
                    if (!fnDoc.isConstructor()) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(declNode, EXTENDS_NOT_ON_CTOR_OR_INTERF, functionName));
                    } else {
                        Node docNode = fnDoc.getBaseType().getRootNode();
                        if (GlobalTypeInfo.this.typeParser.hasKnownType(docNode, ownerType, parentScope, typeParameters)) {
                            parentClass = GlobalTypeInfo.this.typeParser.getNominalType(docNode, ownerType, parentScope, typeParameters);
                            if (parentClass == null) {
                                GlobalTypeInfo.this.warnings.add(JSError.make(declNode, EXTENDS_NON_OBJECT, functionName, docNode.toStringTree()));
                            } else if (!parentClass.isClass()) {
                                GlobalTypeInfo.this.warnings.add(JSError.make(declNode, TypeCheck.CONFLICTING_EXTENDED_TYPE, "constructor", functionName));
                                parentClass = null;
                            }
                        }
                    }
                }
                ctorType = declNode.isFunction() ? (NominalType.RawNominalType)GlobalTypeInfo.this.nominaltypesByNode.get(declNode) : null;
                ImmutableSet<NominalType> implementedIntfs = GlobalTypeInfo.this.typeParser.getImplementedInterfaces(fnDoc, ownerType, parentScope, typeParameters);
                if (ctorType == null && (fnDoc.isConstructor() || fnDoc.isInterface())) {
                    return builder.buildDeclaration();
                }
                if (fnDoc.isConstructor()) {
                    String className = ctorType.toString();
                    if (parentClass != null) {
                        if (!ctorType.addSuperClass(parentClass)) {
                            GlobalTypeInfo.this.warnings.add(JSError.make(declNode, INHERITANCE_CYCLE, className));
                        } else if (ctorType.isStruct() && !parentClass.isStruct()) {
                            GlobalTypeInfo.this.warnings.add(JSError.make(declNode, TypeCheck.CONFLICTING_SHAPE_TYPE, className, "struct", "struct"));
                        } else if (ctorType.isDict() && !parentClass.isDict()) {
                            GlobalTypeInfo.this.warnings.add(JSError.make(declNode, TypeCheck.CONFLICTING_SHAPE_TYPE, className, "dict", "dict"));
                        }
                    }
                    if (ctorType.isDict() && !implementedIntfs.isEmpty()) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(declNode, DICT_IMPLEMENTS_INTERF, className));
                    }
                    boolean noCycles = ctorType.addInterfaces(implementedIntfs);
                    Preconditions.checkState((boolean)noCycles);
                    builder.addNominalType(ctorType.getAsNominalType());
                } else if (fnDoc.isInterface()) {
                    boolean noCycles;
                    if (declNode.isFunction() && !NodeUtil.isEmptyBlock(NodeUtil.getFunctionBody(declNode))) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(declNode, INTERFACE_WITH_A_BODY, new String[0]));
                    }
                    if (!implementedIntfs.isEmpty()) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(declNode, TypeCheck.CONFLICTING_IMPLEMENTED_TYPE, functionName));
                    }
                    if (!(noCycles = ctorType.addInterfaces(GlobalTypeInfo.this.typeParser.getExtendedInterfaces(fnDoc, ownerType, parentScope, typeParameters)))) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(declNode, INHERITANCE_CYCLE, ctorType.toString()));
                    }
                    builder.addNominalType(ctorType.getAsNominalType());
                } else if (!implementedIntfs.isEmpty()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(declNode, IMPLEMENTS_WITHOUT_CONSTRUCTOR, functionName));
                }
            }
            if (ownerType != null) {
                builder.addReceiverType(ownerType.getAsNominalType());
            }
            DeclaredFunctionType result = builder.buildDeclaration();
            if (ctorType != null) {
                ctorType.setCtorFunction(result.toFunctionType());
            }
            return result;
        }

        private void updateFnScope(Scope fnScope, NominalType.RawNominalType ownerType) {
            Node fn = fnScope.getRoot();
            Preconditions.checkState((boolean)fn.isFunction());
            JSDocInfo fnDoc = NodeUtil.getFunctionJSDocInfo(fn);
            String functionName = GlobalTypeInfo.this.getFunInternalName(fn);
            DeclaredFunctionType declFunType = this.computeFnDeclaredType(fnDoc, functionName, fn, ownerType, this.currentScope);
            fnScope.setDeclType(declFunType);
        }

        private JSType getVarTypeFromAnnotation(Node nameNode) {
            Preconditions.checkArgument((boolean)nameNode.getParent().isVar());
            Node varNode = nameNode.getParent();
            JSType varType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(varNode.getJSDocInfo(), this.currentScope);
            if (varNode.getChildCount() > 1 && varType != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(varNode, TypeCheck.MULTIPLE_VAR_DEF, new String[0]));
            }
            String varName = nameNode.getString();
            JSType nameNodeType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(nameNode.getJSDocInfo(), this.currentScope);
            if (nameNodeType != null) {
                if (varType != null) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(nameNode, DUPLICATE_JSDOC, varName));
                }
                return nameNodeType;
            }
            return varType;
        }
    }

    private class CollectNamedTypes
    extends NodeTraversal.AbstractShallowCallback {
        private final Scope currentScope;

        CollectNamedTypes(Scope s) {
            this.currentScope = s;
        }

        private void processQualifiedDefinition(Node qnameNode) {
            Preconditions.checkArgument((boolean)qnameNode.isGetProp());
            Preconditions.checkArgument((boolean)qnameNode.isQualifiedName());
            if (!this.currentScope.isNamespace(qnameNode.getFirstChild())) {
                return;
            }
            if (NodeUtil.isNamespaceDecl(qnameNode)) {
                this.visitNamespace(qnameNode);
            } else if (NodeUtil.isTypedefDecl(qnameNode)) {
                this.visitTypedef(qnameNode);
            } else if (NodeUtil.isEnumDecl(qnameNode)) {
                this.visitEnum(qnameNode);
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 105: {
                    this.visitFunctionEarly(n);
                    break;
                }
                case 118: {
                    Node nameNode = n.getFirstChild();
                    if (NodeUtil.isNamespaceDecl(nameNode)) {
                        this.visitNamespace(nameNode);
                        break;
                    }
                    if (NodeUtil.isTypedefDecl(nameNode)) {
                        this.visitTypedef(nameNode);
                        break;
                    }
                    if (!NodeUtil.isEnumDecl(nameNode)) break;
                    this.visitEnum(nameNode);
                    break;
                }
                case 130: {
                    Node getProp;
                    Node expr = n.getFirstChild();
                    if (!expr.isGetProp() && (!expr.isAssign() || !expr.getFirstChild().isGetProp())) break;
                    Node node = getProp = expr.isGetProp() ? expr : expr.getFirstChild();
                    if (GlobalTypeInfo.isPrototypeProperty(getProp) || NodeUtil.referencesThis(getProp) || !getProp.isQualifiedName()) {
                        return;
                    }
                    if (!NodeUtil.isNamespaceDecl(getProp) && !NodeUtil.isTypedefDecl(getProp) && !NodeUtil.isEnumDecl(getProp)) break;
                    this.processQualifiedDefinition(getProp);
                    break;
                }
            }
        }

        private void visitNamespace(Node qnameNode) {
            if (qnameNode.isGetProp()) {
                Preconditions.checkState((boolean)qnameNode.getParent().isAssign());
                QualifiedName qname = QualifiedName.fromGetprop(qnameNode);
                String leftmost = qname.getLeftmostName();
                QualifiedName props = qname.getAllButLeftmost();
                if (this.currentScope.getNamespace(leftmost).isDefined(props)) {
                    return;
                }
                qnameNode.getParent().putBooleanProp(75, true);
            }
            if (!this.currentScope.isNamespace(qnameNode)) {
                this.currentScope.addNamespace(qnameNode);
            }
        }

        private void visitTypedef(Node qnameNode) {
            Preconditions.checkState((boolean)qnameNode.isQualifiedName());
            qnameNode.putBooleanProp(75, true);
            if (NodeUtil.getInitializer(qnameNode) != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(qnameNode, CANNOT_INIT_TYPEDEF, new String[0]));
            }
            if (this.currentScope.isDefined(qnameNode)) {
                return;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            Typedef td = Typedef.make(jsdoc.getTypedefType());
            this.currentScope.addTypedef(qnameNode, td);
        }

        private void visitEnum(Node qnameNode) {
            Preconditions.checkState((boolean)qnameNode.isQualifiedName());
            qnameNode.putBooleanProp(75, true);
            if (this.currentScope.isDefined(qnameNode)) {
                return;
            }
            Node init = NodeUtil.getInitializer(qnameNode);
            if (init == null || !init.isObjectLit() || init.getFirstChild() == null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(qnameNode, MALFORMED_ENUM, new String[0]));
                return;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            HashSet<String> propNames = new HashSet<String>();
            for (Node prop : init.children()) {
                String pname = NodeUtil.getObjectLitKeyName(prop);
                if (propNames.contains(pname)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(qnameNode, DUPLICATE_PROP_IN_ENUM, pname));
                }
                if (!GlobalTypeInfo.this.convention.isValidEnumKey(pname)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(prop, TypeCheck.ENUM_NOT_CONSTANT, pname));
                }
                propNames.add(pname);
            }
            this.currentScope.addEnum(qnameNode, EnumType.make(qnameNode.getQualifiedName(), jsdoc.getEnumParameterType(), (Collection<String>)ImmutableSet.copyOf(propNames)));
        }

        private void createFunctionScope(Node fn, ArrayList<String> formals, Node nameNode) {
            Scope fnScope = new Scope(fn, this.currentScope, formals);
            GlobalTypeInfo.this.scopes.add(fnScope);
            String internalName = null;
            if (nameNode == null || !nameNode.isName()) {
                internalName = GlobalTypeInfo.ANON_FUN_PREFIX + GlobalTypeInfo.this.freshId;
                GlobalTypeInfo.this.anonFunNames.put(fn, internalName);
                GlobalTypeInfo.this.freshId++;
            } else if (this.currentScope.isDefinedLocally(nameNode.getString())) {
                String fnName = nameNode.getString();
                Preconditions.checkState((!fnName.contains(".") ? 1 : 0) != 0);
                internalName = GlobalTypeInfo.ANON_FUN_PREFIX + GlobalTypeInfo.this.freshId;
                GlobalTypeInfo.this.anonFunNames.put(fn, internalName);
                GlobalTypeInfo.this.freshId++;
            } else {
                internalName = nameNode.getString();
            }
            this.currentScope.addLocalFunDef(internalName, fnScope);
        }

        private void visitFunctionEarly(Node fn) {
            JSDocInfo fnDoc = NodeUtil.getFunctionJSDocInfo(fn);
            Node nameNode = NodeUtil.getFunctionNameNode(fn);
            ArrayList<String> formals = new ArrayList<String>();
            ArrayList<String> tmpRestFormals = new ArrayList<String>();
            for (Node param = NodeUtil.getFunctionParameters(fn).getFirstChild(); param != null; param = param.getNext()) {
                if (JSTypeCreatorFromJSDoc.isRestArg(fnDoc, param.getString()) && param.getNext() == null) {
                    tmpRestFormals.add(param.getString());
                    continue;
                }
                formals.add(param.getString());
            }
            this.createFunctionScope(fn, formals, nameNode);
            if (fnDoc != null) {
                for (String formalInJsdoc : fnDoc.getParameterNames()) {
                    if (formals.contains(formalInJsdoc) || tmpRestFormals.contains(formalInJsdoc)) continue;
                    String functionName = GlobalTypeInfo.this.getFunInternalName(fn);
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, INEXISTENT_PARAM, formalInJsdoc, functionName));
                }
            }
            if (fnDoc != null && (fnDoc.isConstructor() || fnDoc.isInterface())) {
                QualifiedName qname = QualifiedName.fromGetprop(nameNode);
                if (qname == null) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, ANONYMOUS_NOMINAL_TYPE, new String[0]));
                    return;
                }
                ImmutableList<String> typeParameters = fnDoc.getTemplateTypeNames();
                NominalType.RawNominalType rawNominalType = fnDoc.isInterface() ? NominalType.RawNominalType.makeInterface(qname, typeParameters) : (fnDoc.makesStructs() ? NominalType.RawNominalType.makeStructClass(qname, typeParameters) : (fnDoc.makesDicts() ? NominalType.RawNominalType.makeDictClass(qname, typeParameters) : NominalType.RawNominalType.makeUnrestrictedClass(qname, typeParameters)));
                GlobalTypeInfo.this.nominaltypesByNode.put(fn, rawNominalType);
                if (nameNode.isName() || this.currentScope.isNamespace(nameNode.getFirstChild())) {
                    if (fn.getParent().isAssign()) {
                        fn.getParent().getFirstChild().putBooleanProp(75, true);
                    }
                    this.currentScope.addNominalType(nameNode, rawNominalType);
                }
            } else if (fnDoc != null) {
                if (fnDoc.makesStructs()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, CONSTRUCTOR_REQUIRED, "@struct"));
                } else if (fnDoc.makesDicts()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, CONSTRUCTOR_REQUIRED, "@dict"));
                }
            }
        }
    }
}

