/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.deps.DependencyInfo;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class SortedDependencies<INPUT extends DependencyInfo> {
    private final List<INPUT> inputs;
    private final List<INPUT> sortedList;
    private final List<INPUT> noProvides;
    private final Map<String, INPUT> provideMap = Maps.newHashMap();

    public SortedDependencies(List<INPUT> list) throws CircularDependencyException {
        this.inputs = Lists.newArrayList(list);
        this.noProvides = Lists.newArrayList();
        for (Object object : list) {
            Collection<String> collection = object.getProvides();
            if (collection.isEmpty()) {
                this.noProvides.add(object);
            }
            for (String string : collection) {
                this.provideMap.put(string, object);
            }
        }
        HashMultimap hashMultimap = HashMultimap.create();
        for (Collection<String> collection : list) {
            for (String string : collection.getRequires()) {
                DependencyInfo dependencyInfo = (DependencyInfo)this.provideMap.get(string);
                if (dependencyInfo == null) continue;
                hashMultimap.put((Object)collection, (Object)dependencyInfo);
            }
        }
        this.sortedList = SortedDependencies.topologicalStableSort(list, hashMultimap);
        if (this.sortedList.size() < list.size()) {
            Object object;
            object = Lists.newArrayList(list);
            object.removeAll(this.sortedList);
            throw new CircularDependencyException(this.cycleToString(this.findCycle((List<INPUT>)object, (Multimap<INPUT, INPUT>)hashMultimap)));
        }
    }

    public INPUT getInputProviding(String string) throws MissingProvideException {
        if (this.provideMap.containsKey(string)) {
            return (INPUT)((DependencyInfo)this.provideMap.get(string));
        }
        throw new MissingProvideException(string);
    }

    private List<INPUT> findCycle(List<INPUT> list, Multimap<INPUT, INPUT> multimap) {
        return this.findCycle((DependencyInfo)list.get(0), Sets.newHashSet(list), multimap, Sets.newHashSet());
    }

    private List<INPUT> findCycle(INPUT INPUT, Set<INPUT> set, Multimap<INPUT, INPUT> multimap, Set<INPUT> set2) {
        if (set2.add(INPUT)) {
            List<INPUT> list = this.findCycle(this.findRequireInSubGraphOrFail(INPUT, set), set, multimap, set2);
            if (list.get(0) != list.get(list.size() - 1)) {
                list.add(INPUT);
            }
            return list;
        }
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(INPUT);
        return arrayList;
    }

    private INPUT findRequireInSubGraphOrFail(INPUT INPUT, Set<INPUT> set) {
        for (String string : INPUT.getRequires()) {
            DependencyInfo dependencyInfo = (DependencyInfo)this.provideMap.get(string);
            if (!set.contains(dependencyInfo)) continue;
            return (INPUT)dependencyInfo;
        }
        throw new IllegalStateException("no require found in subgraph");
    }

    private String cycleToString(List<INPUT> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i = list.size() - 1; i >= 0; --i) {
            arrayList.add(((DependencyInfo)list.get(i)).getProvides().iterator().next());
        }
        arrayList.add(arrayList.get(0));
        return Joiner.on((String)" -> ").join((Iterable)arrayList);
    }

    public List<INPUT> getSortedList() {
        return Collections.unmodifiableList(this.sortedList);
    }

    public List<INPUT> getSortedDependenciesOf(List<INPUT> list) {
        Object object;
        Preconditions.checkArgument((boolean)this.inputs.containsAll(list));
        HashSet hashSet = Sets.newHashSet();
        ArrayDeque<INPUT> arrayDeque = new ArrayDeque<INPUT>(list);
        while (!arrayDeque.isEmpty()) {
            object = (DependencyInfo)arrayDeque.pop();
            if (!hashSet.add(object)) continue;
            for (String object2 : object.getRequires()) {
                DependencyInfo dependencyInfo = (DependencyInfo)this.provideMap.get(object2);
                if (dependencyInfo == null) continue;
                arrayDeque.add(dependencyInfo);
            }
        }
        object = ImmutableList.builder();
        for (DependencyInfo dependencyInfo : this.sortedList) {
            if (!hashSet.contains(dependencyInfo)) continue;
            object.add((Object)dependencyInfo);
        }
        return object.build();
    }

    public List<INPUT> getInputsWithoutProvides() {
        return Collections.unmodifiableList(this.noProvides);
    }

    private static <T> List<T> topologicalStableSort(List<T> list, Multimap<T, T> multimap) {
        final HashMap hashMap = Maps.newHashMap();
        for (int i = 0; i < list.size(); ++i) {
            hashMap.put(list.get(i), i);
        }
        PriorityQueue<Object> priorityQueue = new PriorityQueue<Object>(list.size(), new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                return (Integer)hashMap.get(t) - (Integer)hashMap.get(t2);
            }
        });
        ArrayList arrayList = Lists.newArrayList();
        HashMultiset hashMultiset = HashMultiset.create();
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        Multimaps.invertFrom(multimap, (Multimap)arrayListMultimap);
        for (Object object : list) {
            Collection collection = multimap.get(object);
            hashMultiset.add(object, collection.size());
            if (!collection.isEmpty()) continue;
            priorityQueue.add(object);
        }
        while (!priorityQueue.isEmpty()) {
            Iterator<Object> iterator = priorityQueue.remove();
            arrayList.add(iterator);
            for (Collection collection : arrayListMultimap.get(iterator)) {
                hashMultiset.remove((Object)collection, 1);
                if (hashMultiset.count((Object)collection) != 0) continue;
                priorityQueue.add(collection);
            }
        }
        return arrayList;
    }

    public static class MissingProvideException
    extends Exception {
        MissingProvideException(String string) {
            super(string);
        }
    }

    public static class CircularDependencyException
    extends Exception {
        CircularDependencyException(String string) {
            super(string);
        }
    }
}

