/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;

class TypeValidator {
    private final AbstractCompiler compiler;
    private final JSTypeRegistry typeRegistry;
    private final JSType allValueTypes;
    private boolean shouldReport = true;
    private final JSType nullOrUndefined;
    private final List<TypeMismatch> mismatches = Lists.newArrayList();
    private static final String FOUND_REQUIRED = "{0}\nfound   : {1}\nrequired: {2}";
    static final DiagnosticType INVALID_CAST = DiagnosticType.warning("JSC_INVALID_CAST", "invalid cast - must be a subtype or supertype\nfrom: {0}\nto  : {1}");
    static final DiagnosticType TYPE_MISMATCH_WARNING = DiagnosticType.warning("JSC_TYPE_MISMATCH", "{0}");
    static final DiagnosticType MISSING_EXTENDS_TAG_WARNING = DiagnosticType.warning("JSC_MISSING_EXTENDS_TAG", "Missing @extends tag on type {0}");
    static final DiagnosticType DUP_VAR_DECLARATION = DiagnosticType.warning("JSC_DUP_VAR_DECLARATION", "variable {0} redefined with type {1}, original definition at {2}:{3} with type {4}");
    static final DiagnosticType HIDDEN_PROPERTY_MISMATCH = DiagnosticType.warning("JSC_HIDDEN_PROPERTY_MISMATCH", "mismatch of the {0} property type and the type of the property it overrides from superclass {1}\noriginal: {2}\noverride: {3}");
    static final DiagnosticType INTERFACE_METHOD_NOT_IMPLEMENTED = DiagnosticType.warning("JSC_INTERFACE_METHOD_NOT_IMPLEMENTED", "property {0} on interface {1} is not implemented by type {2}");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(INVALID_CAST, TYPE_MISMATCH_WARNING, MISSING_EXTENDS_TAG_WARNING, DUP_VAR_DECLARATION, HIDDEN_PROPERTY_MISMATCH, INTERFACE_METHOD_NOT_IMPLEMENTED);

    TypeValidator(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.typeRegistry = abstractCompiler.getTypeRegistry();
        this.allValueTypes = this.typeRegistry.createUnionType(JSTypeNative.STRING_TYPE, JSTypeNative.NUMBER_TYPE, JSTypeNative.BOOLEAN_TYPE, JSTypeNative.NULL_TYPE, JSTypeNative.VOID_TYPE);
        this.nullOrUndefined = this.typeRegistry.createUnionType(JSTypeNative.NULL_TYPE, JSTypeNative.VOID_TYPE);
    }

    Iterable<TypeMismatch> getMismatches() {
        return this.mismatches;
    }

    void setShouldReport(boolean bl) {
        this.shouldReport = bl;
    }

    boolean expectObject(NodeTraversal nodeTraversal, Node node, JSType jSType, String string) {
        if (!jSType.matchesObjectContext()) {
            this.mismatch(nodeTraversal, node, string, jSType, JSTypeNative.OBJECT_TYPE);
            return false;
        }
        return true;
    }

    void expectActualObject(NodeTraversal nodeTraversal, Node node, JSType jSType, String string) {
        if (!jSType.isObject()) {
            this.mismatch(nodeTraversal, node, string, jSType, JSTypeNative.OBJECT_TYPE);
        }
    }

    void expectAnyObject(NodeTraversal nodeTraversal, Node node, JSType jSType, String string) {
        JSType jSType2 = this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        if (!jSType2.isSubtype(jSType)) {
            this.mismatch(nodeTraversal, node, string, jSType, jSType2);
        }
    }

    void expectString(NodeTraversal nodeTraversal, Node node, JSType jSType, String string) {
        if (!jSType.matchesStringContext()) {
            this.mismatch(nodeTraversal, node, string, jSType, JSTypeNative.STRING_TYPE);
        }
    }

    void expectNumber(NodeTraversal nodeTraversal, Node node, JSType jSType, String string) {
        if (!jSType.matchesNumberContext()) {
            this.mismatch(nodeTraversal, node, string, jSType, JSTypeNative.NUMBER_TYPE);
        }
    }

    void expectBitwiseable(NodeTraversal nodeTraversal, Node node, JSType jSType, String string) {
        if (!jSType.matchesNumberContext() && !jSType.isSubtype(this.allValueTypes)) {
            this.mismatch(nodeTraversal, node, string, jSType, this.allValueTypes);
        }
    }

    void expectStringOrNumber(NodeTraversal nodeTraversal, Node node, JSType jSType, String string) {
        if (!jSType.matchesNumberContext() && !jSType.matchesStringContext()) {
            this.mismatch(nodeTraversal, node, string, jSType, JSTypeNative.NUMBER_STRING);
        }
    }

    boolean expectNotNullOrUndefined(NodeTraversal nodeTraversal, Node node, JSType jSType, String string, JSType jSType2) {
        if (!jSType.isNoType() && !jSType.isUnknownType() && jSType.isSubtype(this.nullOrUndefined)) {
            if (node.getType() == 33 && !nodeTraversal.inGlobalScope() && jSType.isNullType()) {
                return true;
            }
            this.mismatch(nodeTraversal, node, string, jSType, jSType2);
            return false;
        }
        return true;
    }

    void expectSwitchMatchesCase(NodeTraversal nodeTraversal, Node node, JSType jSType, JSType jSType2) {
        if (!(jSType.canTestForShallowEqualityWith(jSType2) || jSType2.autoboxesTo() != null && jSType2.autoboxesTo().isSubtype(jSType))) {
            this.mismatch(nodeTraversal, node.getFirstChild(), "case expression doesn't match switch", jSType2, jSType);
        }
    }

    void expectIndexMatch(NodeTraversal nodeTraversal, Node node, JSType jSType, JSType jSType2) {
        if (jSType.isUnknownType()) {
            this.expectStringOrNumber(nodeTraversal, node, jSType2, "property access");
        } else if (jSType.toObjectType() != null && jSType.toObjectType().getIndexType() != null) {
            this.expectCanAssignTo(nodeTraversal, node, jSType2, jSType.toObjectType().getIndexType(), "restricted index type");
        } else if (jSType.isArrayType()) {
            this.expectNumber(nodeTraversal, node, jSType2, "array access");
        } else if (jSType.matchesObjectContext()) {
            this.expectString(nodeTraversal, node, jSType2, "property access");
        } else {
            this.mismatch(nodeTraversal, node, "only arrays or objects can be accessed", jSType, this.typeRegistry.createUnionType(JSTypeNative.ARRAY_TYPE, JSTypeNative.OBJECT_TYPE));
        }
    }

    boolean expectCanAssignToPropertyOf(NodeTraversal nodeTraversal, Node node, JSType jSType, JSType jSType2, Node node2, String string) {
        if (!jSType2.isNoType() && !jSType.canAssignTo(jSType2)) {
            if (this.bothIntrinsics(jSType, jSType2)) {
                this.registerMismatch(jSType, jSType2);
            } else {
                this.mismatch(nodeTraversal, node, "assignment to property " + string + " of " + this.getReadableJSTypeName(node2, true), jSType, jSType2);
            }
            return false;
        }
        return true;
    }

    boolean expectCanAssignTo(NodeTraversal nodeTraversal, Node node, JSType jSType, JSType jSType2, String string) {
        if (!jSType.canAssignTo(jSType2)) {
            if (this.bothIntrinsics(jSType, jSType2)) {
                this.registerMismatch(jSType, jSType2);
            } else {
                this.mismatch(nodeTraversal, node, string, jSType, jSType2);
            }
            return false;
        }
        return true;
    }

    private boolean bothIntrinsics(JSType jSType, JSType jSType2) {
        return !(!jSType2.isConstructor() && !jSType2.isEnumType() || !jSType.isConstructor() && !jSType.isEnumType());
    }

    void expectArgumentMatchesParameter(NodeTraversal nodeTraversal, Node node, JSType jSType, JSType jSType2, Node node2, int n) {
        if (!jSType.canAssignTo(jSType2)) {
            this.mismatch(nodeTraversal, node, String.format("actual parameter %d of %s does not match formal parameter", n, this.getReadableJSTypeName(node2.getFirstChild(), false)), jSType, jSType2);
        }
    }

    void expectCanOverride(NodeTraversal nodeTraversal, Node node, JSType jSType, JSType jSType2, String string, JSType jSType3) {
        if (!jSType.canAssignTo(jSType2)) {
            this.registerMismatch(jSType, jSType2);
            if (this.shouldReport) {
                this.compiler.report(nodeTraversal.makeError(node, HIDDEN_PROPERTY_MISMATCH, string, jSType3.toString(), jSType2.toString(), jSType.toString()));
            }
        }
    }

    void expectSuperType(NodeTraversal nodeTraversal, Node node, ObjectType objectType, ObjectType objectType2) {
        FunctionType functionType = objectType2.getConstructor();
        ObjectType objectType3 = objectType2.getImplicitPrototype().getImplicitPrototype();
        if (!objectType3.equals(objectType)) {
            if (objectType3.equals(this.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                if (this.shouldReport) {
                    this.compiler.report(nodeTraversal.makeError(node, MISSING_EXTENDS_TAG_WARNING, objectType2.toString()));
                }
                this.registerMismatch(objectType, objectType3);
            } else {
                this.mismatch(nodeTraversal.getSourceName(), node, "mismatch in declaration of superclass type", (JSType)objectType, (JSType)objectType3);
            }
            if (!functionType.hasCachedValues()) {
                functionType.setPrototypeBasedOn(objectType);
            }
        }
    }

    void expectCanCast(NodeTraversal nodeTraversal, Node node, JSType jSType, JSType jSType2) {
        jSType2 = jSType2.restrictByNotNullOrUndefined();
        if (!(jSType = jSType.restrictByNotNullOrUndefined()).canAssignTo(jSType2) && !jSType2.canAssignTo(jSType)) {
            if (this.shouldReport) {
                this.compiler.report(nodeTraversal.makeError(node, INVALID_CAST, jSType2.toString(), jSType.toString()));
            }
            this.registerMismatch(jSType, jSType2);
        }
    }

    void expectUndeclaredVariable(String string, Node node, Node node2, Scope.Var var, String string2, JSType jSType) {
        Serializable serializable;
        boolean bl = false;
        if (node.getType() == 33) {
            serializable = node.getJSDocInfo();
            if (serializable == null) {
                serializable = node2.getJSDocInfo();
            }
            boolean bl2 = bl = serializable != null && ((JSDocInfo)serializable).getSuppressions().contains("duplicate");
        }
        if ((serializable = var.getType()) != null && serializable != this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE) && jSType != null && jSType != this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE)) {
            if (var.input == null) {
                node.setJSType((JSType)serializable);
                if (node2.getType() == 118) {
                    if (node.getFirstChild() != null) {
                        node.getFirstChild().setJSType((JSType)serializable);
                    }
                } else {
                    Preconditions.checkState((node2.getType() == 105 ? 1 : 0) != 0);
                    node2.setJSType((JSType)serializable);
                }
            } else if ((!bl && var.getParentNode().getType() != 130 || !jSType.equals(serializable)) && this.shouldReport) {
                this.compiler.report(JSError.make(string, node, DUP_VAR_DECLARATION, string2, jSType.toString(), var.getInputName(), String.valueOf(var.nameNode.getLineno()), serializable.toString()));
            }
        }
    }

    void expectAllInterfacePropertiesImplemented(FunctionType functionType) {
        ObjectType objectType = functionType.getInstanceType();
        for (ObjectType objectType2 : functionType.getAllImplementedInterfaces()) {
            if (objectType2.getImplicitPrototype() == null) continue;
            for (String string : objectType2.getImplicitPrototype().getOwnPropertyNames()) {
                if (objectType.hasProperty(string)) continue;
                Node node = functionType.getSource();
                Preconditions.checkNotNull((Object)node);
                String string2 = (String)node.getProp(16);
                String string3 = string2 = string2 == null ? "" : string2;
                if (this.shouldReport) {
                    this.compiler.report(JSError.make(string2, node, INTERFACE_METHOD_NOT_IMPLEMENTED, string, objectType2.toString(), objectType.toString()));
                }
                this.registerMismatch(objectType, objectType2);
            }
        }
    }

    private void mismatch(NodeTraversal nodeTraversal, Node node, String string, JSType jSType, JSType jSType2) {
        this.mismatch(nodeTraversal.getSourceName(), node, string, jSType, jSType2);
    }

    private void mismatch(NodeTraversal nodeTraversal, Node node, String string, JSType jSType, JSTypeNative jSTypeNative) {
        this.mismatch(nodeTraversal, node, string, jSType, this.getNativeType(jSTypeNative));
    }

    private void mismatch(String string, Node node, String string2, JSType jSType, JSType jSType2) {
        this.registerMismatch(jSType, jSType2);
        if (this.shouldReport) {
            this.compiler.report(JSError.make(string, node, TYPE_MISMATCH_WARNING, this.formatFoundRequired(string2, jSType, jSType2)));
        }
    }

    private void registerMismatch(JSType jSType, JSType jSType2) {
        if ((jSType = jSType.restrictByNotNullOrUndefined()).canAssignTo(jSType2 = jSType2.restrictByNotNullOrUndefined()) || jSType2.canAssignTo(jSType)) {
            return;
        }
        this.mismatches.add(new TypeMismatch(jSType, jSType2));
        if (jSType instanceof FunctionType && jSType2 instanceof FunctionType) {
            FunctionType functionType = (FunctionType)jSType;
            FunctionType functionType2 = (FunctionType)jSType2;
            Iterator<Node> iterator = functionType.getParameters().iterator();
            Iterator<Node> iterator2 = functionType2.getParameters().iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                this.registerIfMismatch(iterator.next().getJSType(), iterator2.next().getJSType());
            }
            this.registerIfMismatch(functionType.getReturnType(), functionType2.getReturnType());
        }
    }

    private void registerIfMismatch(JSType jSType, JSType jSType2) {
        if (jSType != null && jSType2 != null && !jSType.canAssignTo(jSType2)) {
            this.registerMismatch(jSType, jSType2);
        }
    }

    private String formatFoundRequired(String string, JSType jSType, JSType jSType2) {
        return MessageFormat.format(FOUND_REQUIRED, string, jSType, jSType2);
    }

    String getReadableJSTypeName(Node node, boolean bl) {
        Object object;
        Object object2;
        if (node.getType() == 33 && (object2 = this.getJSType(node.getFirstChild()).dereference()) != null) {
            object = node.getLastChild().getString();
            while (object2 != null && !((ObjectType)object2).hasOwnProperty((String)object)) {
                object2 = ((ObjectType)object2).getImplicitPrototype();
            }
            if (object2 != null && (((ObjectType)object2).getConstructor() != null || ((JSType)object2).isFunctionPrototypeType())) {
                return object2.toString() + "." + (String)object;
            }
        }
        object2 = this.getJSType(node);
        if (bl && (object = ((JSType)object2).dereference()) != null) {
            object2 = object;
        }
        object = node.getQualifiedName();
        if (((JSType)object2).isFunctionPrototypeType() || ((JSType)object2).toObjectType() != null && ((JSType)object2).toObjectType().getConstructor() != null) {
            return object2.toString();
        }
        if (object != null) {
            return object;
        }
        if (object2 instanceof FunctionType) {
            return "function";
        }
        return object2.toString();
    }

    private JSType getJSType(Node node) {
        JSType jSType = node.getJSType();
        if (jSType == null) {
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jSType;
    }

    private JSType getNativeType(JSTypeNative jSTypeNative) {
        return this.typeRegistry.getNativeType(jSTypeNative);
    }

    static class TypeMismatch {
        final JSType typeA;
        final JSType typeB;

        TypeMismatch(JSType jSType, JSType jSType2) {
            this.typeA = jSType;
            this.typeB = jSType2;
        }

        public boolean equals(Object object) {
            if (object instanceof TypeMismatch) {
                TypeMismatch typeMismatch = (TypeMismatch)object;
                return typeMismatch.typeA.equals(this.typeA) && typeMismatch.typeB.equals(this.typeB) || typeMismatch.typeB.equals(this.typeA) && typeMismatch.typeA.equals(this.typeB);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.typeA, this.typeB});
        }

        public String toString() {
            return "(" + this.typeA + ", " + this.typeB + ")";
        }
    }
}

