/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.Map;
import javax.annotation.Nullable;

class ReplaceCssNames
implements CompilerPass {
    static final String GET_CSS_NAME_FUNCTION = "goog.getCssName";
    static final DiagnosticType INVALID_NUM_ARGUMENTS_ERROR = DiagnosticType.error("JSC_GETCSSNAME_NUM_ARGS", "goog.getCssName called with \"{0}\" arguments, expected 1 or 2.");
    static final DiagnosticType STRING_LITERAL_EXPECTED_ERROR = DiagnosticType.error("JSC_GETCSSNAME_STRING_LITERAL_EXPECTED", "goog.getCssName called with invalid argument, string literal expected.  Was \"{0}\".");
    static final DiagnosticType UNEXPECTED_STRING_LITERAL_ERROR = DiagnosticType.error("JSC_GETCSSNAME_UNEXPECTED_STRING_LITERAL", "goog.getCssName called with invalid arguments, string literal passed as first of two arguments.  Did you mean goog.getCssName(\"{0}-{1}\")?");
    static final DiagnosticType UNKNOWN_SYMBOL_WARNING = DiagnosticType.warning("JSC_GETCSSNAME_UNKNOWN_CSS_SYMBOL", "goog.getCssName called with unrecognized symbol \"{0}\" in class \"{1}\".");
    private final AbstractCompiler compiler;
    private final Map<String, Integer> cssNames;
    private CssRenamingMap symbolMap;
    private final JSType nativeStringType;

    ReplaceCssNames(AbstractCompiler abstractCompiler, @Nullable Map<String, Integer> map) {
        this.compiler = abstractCompiler;
        this.cssNames = map;
        this.nativeStringType = abstractCompiler.getTypeRegistry().getNativeType(JSTypeNative.STRING_TYPE);
    }

    @Override
    public void process(Node node, Node node2) {
        this.symbolMap = this.getCssRenamingMap();
        NodeTraversal.traverse(this.compiler, node2, new Traversal());
    }

    @VisibleForTesting
    protected CssRenamingMap getCssRenamingMap() {
        return this.compiler.getCssRenamingMap();
    }

    private class Traversal
    extends NodeTraversal.AbstractPostOrderCallback {
        private Traversal() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 37 && ReplaceCssNames.GET_CSS_NAME_FUNCTION.equals(node.getFirstChild().getQualifiedName())) {
                int n = node.getChildCount();
                Node node3 = node.getFirstChild().getNext();
                switch (n) {
                    case 2: {
                        if (node3.getType() == 40) {
                            this.processStringNode(nodeTraversal, node3);
                            node.removeChild(node3);
                            node2.replaceChild(node, node3);
                            ReplaceCssNames.this.compiler.reportCodeChange();
                            break;
                        }
                        ReplaceCssNames.this.compiler.report(nodeTraversal.makeError(node, STRING_LITERAL_EXPECTED_ERROR, Token.name(node3.getType())));
                        break;
                    }
                    case 3: {
                        Node node4 = node3.getNext();
                        if (node3.getType() == 40) {
                            ReplaceCssNames.this.compiler.report(nodeTraversal.makeError(node, UNEXPECTED_STRING_LITERAL_ERROR, node3.getString(), node4.getString()));
                            break;
                        }
                        if (node4.getType() == 40) {
                            this.processStringNode(nodeTraversal, node4);
                            node.removeChild(node3);
                            Node node5 = new Node(21, node3, Node.newString("-" + node4.getString()).copyInformationFrom(node4)).copyInformationFrom(node);
                            node5.setJSType(ReplaceCssNames.this.nativeStringType);
                            node2.replaceChild(node, node5);
                            ReplaceCssNames.this.compiler.reportCodeChange();
                            break;
                        }
                        ReplaceCssNames.this.compiler.report(nodeTraversal.makeError(node, STRING_LITERAL_EXPECTED_ERROR, Token.name(node4.getType())));
                        break;
                    }
                    default: {
                        ReplaceCssNames.this.compiler.report(nodeTraversal.makeError(node, INVALID_NUM_ARGUMENTS_ERROR, String.valueOf(n)));
                    }
                }
            }
        }

        private void processStringNode(NodeTraversal nodeTraversal, Node node) {
            if (ReplaceCssNames.this.symbolMap != null || ReplaceCssNames.this.cssNames != null) {
                Object[] objectArray = node.getString().split("-");
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object;
                    if (ReplaceCssNames.this.cssNames != null) {
                        object = (Integer)ReplaceCssNames.this.cssNames.get(objectArray[i]);
                        if (object == null) {
                            object = 0;
                        }
                        ReplaceCssNames.this.cssNames.put(objectArray[i], (Integer)object + 1);
                    }
                    if (ReplaceCssNames.this.symbolMap == null) continue;
                    object = ReplaceCssNames.this.symbolMap.get((String)objectArray[i]);
                    if (object == null) {
                        ReplaceCssNames.this.compiler.report(nodeTraversal.makeError(node, UNKNOWN_SYMBOL_WARNING, new String[]{objectArray[i], node.getString()}));
                        return;
                    }
                    objectArray[i] = object;
                }
                if (ReplaceCssNames.this.symbolMap != null) {
                    node.setString(Joiner.on((String)"-").join(objectArray));
                }
            }
        }
    }
}

