/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.testing;

import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.testing.EmptyScope;
import com.google.javascript.rhino.testing.TestErrorReporter;
import junit.framework.Assert;

public class Asserts {
    private Asserts() {
    }

    public static JSType assertResolvesToSame(JSType jSType) {
        Assert.assertSame((Object)jSType, (Object)Asserts.assertValidResolve(jSType));
        return jSType;
    }

    public static JSType assertValidResolve(JSType jSType) {
        return Asserts.assertValidResolve(jSType, new EmptyScope());
    }

    public static JSType assertValidResolve(JSType jSType, StaticScope<JSType> staticScope) {
        TestErrorReporter testErrorReporter = TestErrorReporter.forNoExpectedReports();
        JSType jSType2 = jSType.resolve(testErrorReporter, staticScope);
        Asserts.assertTypeEquals("JSType#resolve should not affect object equality", jSType, jSType2);
        Assert.assertEquals((String)"JSType#resolve should not affect hash codes", (int)jSType.hashCode(), (int)jSType2.hashCode());
        return jSType2;
    }

    public static void assertTypeEquals(JSType jSType, JSType jSType2) {
        Asserts.assertTypeEquals("", jSType, jSType2);
    }

    public static void assertTypeEquals(String string, JSType jSType, JSType jSType2) {
        Assert.assertTrue((String)(string + (string.isEmpty() ? "" : "\n") + "Expected: " + jSType + "\n" + "Actual  : " + jSType2), (boolean)jSType.isEquivalentTo(jSType2));
    }
}

