/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.ValueType;
import com.google.javascript.rhino.jstype.Visitor;

public class BooleanType
extends ValueType {
    private static final long serialVersionUID = 1L;

    BooleanType(JSTypeRegistry jSTypeRegistry) {
        super(jSTypeRegistry);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public TernaryValue testForEquality(JSType jSType) {
        TernaryValue ternaryValue = super.testForEquality(jSType);
        if (ternaryValue != null) {
            return ternaryValue;
        }
        if (jSType.isUnknownType() || jSType.isSubtype(this.getNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN)) || jSType.isObject()) {
            return TernaryValue.UNKNOWN;
        }
        return TernaryValue.FALSE;
    }

    @Override
    public boolean isBooleanValueType() {
        return true;
    }

    @Override
    public boolean matchesNumberContext() {
        return true;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    public JSType autoboxesTo() {
        return this.getNativeType(JSTypeNative.BOOLEAN_OBJECT_TYPE);
    }

    public String toString() {
        return "boolean";
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.BOTH;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseBooleanType();
    }
}

