/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.sjavac.server.CompilationResult;
import com.sun.tools.sjavac.server.Sjavac;
import com.sun.tools.sjavac.server.SysInfo;
import com.sun.tools.sjavac.server.Terminable;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class IdleResetSjavac
implements Sjavac {
    private final Sjavac delegate;
    private final Terminable toShutdown;
    private final Timer idlenessTimer = new Timer();
    private final long idleTimeout;
    private int outstandingCalls = 0;
    private TimerTask idlenessTimerTask;

    public IdleResetSjavac(Sjavac delegate, Terminable toShutdown, long idleTimeout) {
        this.delegate = delegate;
        this.toShutdown = toShutdown;
        this.idleTimeout = idleTimeout;
        this.scheduleTimeout();
    }

    @Override
    public SysInfo getSysInfo() {
        this.startCall();
        try {
            SysInfo sysInfo = this.delegate.getSysInfo();
            return sysInfo;
        }
        finally {
            this.endCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompilationResult compile(String protocolId, String invocationId, String[] args, List<File> explicitSources, Set<URI> sourcesToCompile, Set<URI> visibleSources) {
        this.startCall();
        try {
            CompilationResult compilationResult = this.delegate.compile(protocolId, invocationId, args, explicitSources, sourcesToCompile, visibleSources);
            return compilationResult;
        }
        finally {
            this.endCall();
        }
    }

    private synchronized void startCall() {
        if (++this.outstandingCalls == 1) {
            if (this.idlenessTimerTask == null) {
                throw new IllegalStateException("Idle timeout already cancelled");
            }
            this.idlenessTimerTask.cancel();
            this.idlenessTimerTask = null;
        }
    }

    private synchronized void endCall() {
        if (--this.outstandingCalls == 0) {
            this.scheduleTimeout();
        }
    }

    private void scheduleTimeout() {
        if (this.idlenessTimerTask != null) {
            throw new IllegalStateException("Idle timeout already scheduled");
        }
        this.idlenessTimerTask = new TimerTask(){

            @Override
            public void run() {
                IdleResetSjavac.this.toShutdown.shutdown("Server has been idle for " + IdleResetSjavac.this.idleTimeout / 1000L + " seconds.");
            }
        };
        this.idlenessTimer.schedule(this.idlenessTimerTask, this.idleTimeout);
    }

    @Override
    public void shutdown() {
        this.idlenessTimer.cancel();
        this.delegate.shutdown();
    }

    @Override
    public String serverSettings() {
        return this.delegate.serverSettings();
    }
}

