/*
 * Decompiled with CFR 0.152.
 */
package javax.annotation.processing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public abstract class AbstractProcessor
implements Processor {
    protected ProcessingEnvironment processingEnv;
    private boolean initialized = false;

    protected AbstractProcessor() {
    }

    @Override
    public Set<String> getSupportedOptions() {
        SupportedOptions so = this.getClass().getAnnotation(SupportedOptions.class);
        if (so == null) {
            return Collections.emptySet();
        }
        return AbstractProcessor.arrayToSet(so.value());
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        SupportedAnnotationTypes sat = this.getClass().getAnnotation(SupportedAnnotationTypes.class);
        if (sat == null) {
            if (this.isInitialized()) {
                String string = String.valueOf(String.valueOf("No SupportedAnnotationTypes annotation found on "));
                String string2 = String.valueOf(String.valueOf(this.getClass().getName()));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, new StringBuilder(25 + string.length() + string2.length()).append(string).append(string2).append(", returning an empty set.").toString());
            }
            return Collections.emptySet();
        }
        return AbstractProcessor.arrayToSet(sat.value());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        SupportedSourceVersion ssv = this.getClass().getAnnotation(SupportedSourceVersion.class);
        SourceVersion sv = null;
        if (ssv == null) {
            sv = SourceVersion.RELEASE_6;
            if (this.isInitialized()) {
                String string = String.valueOf(String.valueOf("No SupportedSourceVersion annotation found on "));
                String string2 = String.valueOf(String.valueOf(this.getClass().getName()));
                String string3 = String.valueOf(String.valueOf((Object)sv));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, new StringBuilder(13 + string.length() + string2.length() + string3.length()).append(string).append(string2).append(", returning ").append(string3).append(".").toString());
            }
        } else {
            sv = ssv.value();
        }
        return sv;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot call init more than once.");
        }
        Objects.requireNonNull(processingEnv, "Tool provided null ProcessingEnvironment");
        this.processingEnv = processingEnv;
        this.initialized = true;
    }

    @Override
    public abstract boolean process(Set<? extends TypeElement> var1, RoundEnvironment var2);

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return Collections.emptyList();
    }

    protected synchronized boolean isInitialized() {
        return this.initialized;
    }

    private static Set<String> arrayToSet(String[] array) {
        assert (array != null);
        HashSet<String> set = new HashSet<String>(array.length);
        for (String s : array) {
            set.add(s);
        }
        return Collections.unmodifiableSet(set);
    }
}

