/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;
import javax.tools.JavaFileObject;

public class TypeAnnotations {
    protected static final Context.Key<TypeAnnotations> typeAnnosKey = new Context.Key();
    final Log log;
    final Names names;
    final Symtab syms;
    final Annotate annotate;
    final Attr attr;

    public static TypeAnnotations instance(Context context) {
        TypeAnnotations instance = context.get(typeAnnosKey);
        if (instance == null) {
            instance = new TypeAnnotations(context);
        }
        return instance;
    }

    protected TypeAnnotations(Context context) {
        context.put(typeAnnosKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.annotate = Annotate.instance(context);
        this.attr = Attr.instance(context);
        Options options = Options.instance(context);
    }

    public void organizeTypeAnnotationsSignatures(final Env<AttrContext> env, final JCTree.JCClassDecl tree) {
        this.annotate.afterRepeated(new Annotate.Worker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JavaFileObject oldSource = TypeAnnotations.this.log.useSource(env.toplevel.sourcefile);
                try {
                    new TypeAnnotationPositions(true).scan(tree);
                }
                finally {
                    TypeAnnotations.this.log.useSource(oldSource);
                }
            }
        });
    }

    public void validateTypeAnnotationsSignatures(final Env<AttrContext> env, final JCTree.JCClassDecl tree) {
        this.annotate.validate(new Annotate.Worker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JavaFileObject oldSource = TypeAnnotations.this.log.useSource(env.toplevel.sourcefile);
                try {
                    TypeAnnotations.this.attr.validateTypeAnnotations(tree, true);
                }
                finally {
                    TypeAnnotations.this.log.useSource(oldSource);
                }
            }
        });
    }

    public void organizeTypeAnnotationsBodies(JCTree.JCClassDecl tree) {
        new TypeAnnotationPositions(false).scan(tree);
    }

    public AnnotationType annotationType(Attribute.Compound a, Symbol s) {
        Attribute.Compound atTarget = a.type.tsym.attribute(this.syms.annotationTargetType.tsym);
        if (atTarget == null) {
            return TypeAnnotations.inferTargetMetaInfo(a, s);
        }
        Attribute atValue = atTarget.member(this.names.value);
        if (!(atValue instanceof Attribute.Array)) {
            String string = String.valueOf(String.valueOf(atValue));
            String string2 = String.valueOf(String.valueOf(atValue.getClass()));
            Assert.error(new StringBuilder(42 + string.length() + string2.length()).append("annotationType(): bad @Target argument ").append(string).append(" (").append(string2).append(")").toString());
            return AnnotationType.DECLARATION;
        }
        Attribute.Array arr = (Attribute.Array)atValue;
        boolean isDecl = false;
        boolean isType = false;
        for (Attribute app : arr.values) {
            String string;
            if (!(app instanceof Attribute.Enum)) {
                String string3 = String.valueOf(String.valueOf(app));
                string = String.valueOf(String.valueOf(app.getClass()));
                Assert.error(new StringBuilder(49 + string3.length() + string.length()).append("annotationType(): unrecognized Attribute kind ").append(string3).append(" (").append(string).append(")").toString());
                isDecl = true;
                continue;
            }
            Attribute.Enum e = (Attribute.Enum)app;
            if (e.value.name == this.names.TYPE) {
                if (s.kind != 2) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.FIELD) {
                if (s.kind != 4 || s.owner.kind == 16) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.METHOD) {
                if (s.kind != 16 || s.isConstructor()) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.PARAMETER) {
                if (s.kind != 4 || s.owner.kind != 16 || (s.flags() & 0x200000000L) == 0L) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.CONSTRUCTOR) {
                if (s.kind != 16 || !s.isConstructor()) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.LOCAL_VARIABLE) {
                if (s.kind != 4 || s.owner.kind != 16 || (s.flags() & 0x200000000L) != 0L) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.ANNOTATION_TYPE) {
                if (s.kind != 2 || (s.flags() & 0x2000L) == 0L) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.PACKAGE) {
                if (s.kind != 1) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.TYPE_USE) {
                if (s.kind != 2 && s.kind != 4 && (s.kind != 16 || s.isConstructor() || s.type.getReturnType().hasTag(TypeTag.VOID)) && (s.kind != 16 || !s.isConstructor())) continue;
                isType = true;
                continue;
            }
            if (e.value.name == this.names.TYPE_PARAMETER) continue;
            string = String.valueOf(String.valueOf(e.value.name));
            String string4 = String.valueOf(String.valueOf(e.value.name.getClass()));
            Assert.error(new StringBuilder(49 + string.length() + string4.length()).append("annotationType(): unrecognized Attribute name ").append(string).append(" (").append(string4).append(")").toString());
            isDecl = true;
        }
        if (isDecl && isType) {
            return AnnotationType.BOTH;
        }
        if (isType) {
            return AnnotationType.TYPE;
        }
        return AnnotationType.DECLARATION;
    }

    private static AnnotationType inferTargetMetaInfo(Attribute.Compound a, Symbol s) {
        return AnnotationType.DECLARATION;
    }

    private class TypeAnnotationPositions
    extends TreeScanner {
        private final boolean sigOnly;
        private ListBuffer<JCTree> frames = new ListBuffer();
        private boolean isInClass = false;
        private JCTree.JCLambda currentLambda = null;

        TypeAnnotationPositions(boolean sigOnly) {
            this.sigOnly = sigOnly;
        }

        protected void push(JCTree t) {
            this.frames = this.frames.prepend(t);
        }

        protected JCTree pop() {
            return this.frames.next();
        }

        private JCTree peek2() {
            return (JCTree)this.frames.toList().tail.head;
        }

        @Override
        public void scan(JCTree tree) {
            this.push(tree);
            super.scan(tree);
            this.pop();
        }

        private void separateAnnotationsKinds(JCTree typetree, Type type, Symbol sym, TypeAnnotationPosition pos) {
            List<Attribute.Compound> annotations = sym.getRawAttributes();
            ListBuffer<Attribute.Compound> declAnnos = new ListBuffer<Attribute.Compound>();
            ListBuffer<Attribute.TypeCompound> typeAnnos = new ListBuffer<Attribute.TypeCompound>();
            ListBuffer<Attribute.TypeCompound> onlyTypeAnnos = new ListBuffer<Attribute.TypeCompound>();
            for (Attribute.Compound a : annotations) {
                switch (TypeAnnotations.this.annotationType(a, sym)) {
                    case DECLARATION: {
                        declAnnos.append(a);
                        break;
                    }
                    case BOTH: {
                        declAnnos.append(a);
                        Attribute.TypeCompound ta = this.toTypeCompound(a, pos);
                        typeAnnos.append(ta);
                        break;
                    }
                    case TYPE: {
                        Attribute.TypeCompound ta = this.toTypeCompound(a, pos);
                        typeAnnos.append(ta);
                        onlyTypeAnnos.append(ta);
                        break;
                    }
                }
            }
            sym.resetAnnotations();
            sym.setDeclarationAttributes(declAnnos.toList());
            if (typeAnnos.isEmpty()) {
                return;
            }
            List<Attribute.TypeCompound> typeAnnotations = typeAnnos.toList();
            if (type == null) {
                type = sym.getEnclosingElement().asType();
                type = this.typeWithAnnotations(typetree, type, typeAnnotations, typeAnnotations);
                sym.appendUniqueTypeAttributes(typeAnnotations);
                return;
            }
            type = this.typeWithAnnotations(typetree, type, typeAnnotations, onlyTypeAnnos.toList());
            if (sym.getKind() == ElementKind.METHOD) {
                sym.type.asMethodType().restype = type;
            } else if (sym.getKind() == ElementKind.PARAMETER) {
                sym.type = type;
                if (sym.getQualifiedName().equals(TypeAnnotations.this.names._this)) {
                    sym.owner.type.asMethodType().recvtype = type;
                } else {
                    Type.MethodType methType = sym.owner.type.asMethodType();
                    List<Symbol.VarSymbol> params = ((Symbol.MethodSymbol)sym.owner).params;
                    List<Type> oldArgs = methType.argtypes;
                    ListBuffer<Type> newArgs = new ListBuffer<Type>();
                    while (params.nonEmpty()) {
                        if (params.head == sym) {
                            newArgs.add(type);
                        } else {
                            newArgs.add((Type)oldArgs.head);
                        }
                        oldArgs = oldArgs.tail;
                        params = params.tail;
                    }
                    methType.argtypes = newArgs.toList();
                }
            } else {
                sym.type = type;
            }
            sym.appendUniqueTypeAttributes(typeAnnotations);
            if (sym.getKind() == ElementKind.PARAMETER || sym.getKind() == ElementKind.LOCAL_VARIABLE || sym.getKind() == ElementKind.RESOURCE_VARIABLE || sym.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                sym.owner.appendUniqueTypeAttributes(sym.getRawTypeAttributes());
            }
        }

        private Type typeWithAnnotations(JCTree typetree, Type type, List<Attribute.TypeCompound> annotations, List<Attribute.TypeCompound> onlyTypeAnnotations) {
            Type ret;
            if (annotations.isEmpty()) {
                return type;
            }
            if (type.hasTag(TypeTag.ARRAY)) {
                Type arelemType;
                Type.ArrayType arType = (Type.ArrayType)type;
                Type.ArrayType tomodify = new Type.ArrayType(null, arType.tsym, Type.noAnnotations);
                Type toreturn = type.isAnnotated() ? tomodify.annotatedType((List)type.getAnnotationMirrors()) : tomodify;
                JCTree.JCArrayTypeTree arTree = this.arrayTypeTree(typetree);
                ListBuffer<Object> depth = new ListBuffer<TypeAnnotationPosition.TypePathEntry>();
                depth = depth.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                while (arType.elemtype.hasTag(TypeTag.ARRAY)) {
                    if (arType.elemtype.isAnnotated()) {
                        Type aelemtype = arType.elemtype;
                        arType = (Type.ArrayType)aelemtype;
                        Type.ArrayType prevToMod = tomodify;
                        tomodify = new Type.ArrayType(null, arType.tsym, Type.noAnnotations);
                        prevToMod.elemtype = tomodify.annotatedType((List)arType.elemtype.getAnnotationMirrors());
                    } else {
                        arType = (Type.ArrayType)arType.elemtype;
                        tomodify.elemtype = new Type.ArrayType(null, arType.tsym, Type.noAnnotations);
                        tomodify = (Type.ArrayType)tomodify.elemtype;
                    }
                    arTree = this.arrayTypeTree(arTree.elemtype);
                    depth = depth.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                }
                tomodify.elemtype = arelemType = this.typeWithAnnotations(arTree.elemtype, arType.elemtype, annotations, onlyTypeAnnotations);
                Attribute.TypeCompound a = annotations.get(0);
                TypeAnnotationPosition p = a.position;
                p.location = p.location.prependList(depth.toList());
                typetree.type = toreturn;
                return toreturn;
            }
            if (type.hasTag(TypeTag.TYPEVAR)) {
                return type;
            }
            if (type.getKind() == TypeKind.UNION) {
                Type res;
                JCTree.JCTypeUnion tutree = (JCTree.JCTypeUnion)typetree;
                JCTree.JCExpression fst = tutree.alternatives.get(0);
                fst.type = res = this.typeWithAnnotations(fst, fst.type, annotations, onlyTypeAnnotations);
                return type;
            }
            Type enclTy = type;
            Element enclEl = type.asElement();
            JCTree enclTr = typetree;
            while (enclEl != null && enclEl.getKind() != ElementKind.PACKAGE && enclTy != null && enclTy.getKind() != TypeKind.NONE && enclTy.getKind() != TypeKind.ERROR && (enclTr.getKind() == Tree.Kind.MEMBER_SELECT || enclTr.getKind() == Tree.Kind.PARAMETERIZED_TYPE || enclTr.getKind() == Tree.Kind.ANNOTATED_TYPE)) {
                if (enclTr.getKind() == Tree.Kind.MEMBER_SELECT) {
                    enclTy = enclTy.getEnclosingType();
                    enclEl = enclEl.getEnclosingElement();
                    enclTr = ((JCTree.JCFieldAccess)enclTr).getExpression();
                    continue;
                }
                if (enclTr.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                    enclTr = ((JCTree.JCTypeApply)enclTr).getType();
                    continue;
                }
                enclTr = ((JCTree.JCAnnotatedType)enclTr).getUnderlyingType();
            }
            if (enclTy != null && enclTy.hasTag(TypeTag.NONE)) {
                switch (onlyTypeAnnotations.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        TypeAnnotations.this.log.error(typetree.pos(), "cant.type.annotate.scoping.1", onlyTypeAnnotations);
                        break;
                    }
                    default: {
                        TypeAnnotations.this.log.error(typetree.pos(), "cant.type.annotate.scoping", onlyTypeAnnotations);
                    }
                }
                return type;
            }
            ListBuffer<TypeAnnotationPosition.TypePathEntry> depth = new ListBuffer<TypeAnnotationPosition.TypePathEntry>();
            for (Type topTy = enclTy; enclEl != null && enclEl.getKind() != ElementKind.PACKAGE && topTy != null && topTy.getKind() != TypeKind.NONE && topTy.getKind() != TypeKind.ERROR; topTy = topTy.getEnclosingType(), enclEl = enclEl.getEnclosingElement()) {
                if (topTy == null || topTy.getKind() == TypeKind.NONE) continue;
                depth = depth.append(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
            }
            if (depth.nonEmpty()) {
                Attribute.TypeCompound a = annotations.get(0);
                TypeAnnotationPosition p = a.position;
                p.location = p.location.appendList(depth.toList());
            }
            typetree.type = ret = this.typeWithAnnotations(type, enclTy, annotations);
            return ret;
        }

        private JCTree.JCArrayTypeTree arrayTypeTree(JCTree typetree) {
            if (typetree.getKind() == Tree.Kind.ARRAY_TYPE) {
                return (JCTree.JCArrayTypeTree)typetree;
            }
            if (typetree.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                return (JCTree.JCArrayTypeTree)((JCTree.JCAnnotatedType)typetree).underlyingType;
            }
            String string = String.valueOf(String.valueOf(typetree));
            Assert.error(new StringBuilder(47 + string.length()).append("Could not determine array type from type tree: ").append(string).toString());
            return null;
        }

        private Type typeWithAnnotations(Type type, final Type stopAt, List<Attribute.TypeCompound> annotations) {
            Type.Visitor<Type, List<Attribute.TypeCompound>> visitor = new Type.Visitor<Type, List<Attribute.TypeCompound>>(){

                @Override
                public Type visitClassType(Type.ClassType t, List<Attribute.TypeCompound> s) {
                    if (t == stopAt || t.getEnclosingType() == Type.noType) {
                        return t.annotatedType((List)s);
                    }
                    Type.ClassType ret = new Type.ClassType(t.getEnclosingType().accept(this, s), t.typarams_field, t.tsym, (List<Attribute.TypeCompound>)t.getAnnotationMirrors());
                    ret.all_interfaces_field = t.all_interfaces_field;
                    ret.allparams_field = t.allparams_field;
                    ret.interfaces_field = t.interfaces_field;
                    ret.rank_field = t.rank_field;
                    ret.supertype_field = t.supertype_field;
                    return ret;
                }

                @Override
                public Type visitWildcardType(Type.WildcardType t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType((List)s);
                }

                @Override
                public Type visitArrayType(Type.ArrayType t, List<Attribute.TypeCompound> s) {
                    Type.ArrayType ret = new Type.ArrayType(t.elemtype.accept(this, s), t.tsym, (List<Attribute.TypeCompound>)t.getAnnotationMirrors());
                    return ret;
                }

                @Override
                public Type visitMethodType(Type.MethodType t, List<Attribute.TypeCompound> s) {
                    return t;
                }

                @Override
                public Type visitPackageType(Type.PackageType t, List<Attribute.TypeCompound> s) {
                    return t;
                }

                @Override
                public Type visitTypeVar(Type.TypeVar t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType((List)s);
                }

                @Override
                public Type visitCapturedType(Type.CapturedType t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType((List)s);
                }

                @Override
                public Type visitForAll(Type.ForAll t, List<Attribute.TypeCompound> s) {
                    return t;
                }

                @Override
                public Type visitUndetVar(Type.UndetVar t, List<Attribute.TypeCompound> s) {
                    return t;
                }

                @Override
                public Type visitErrorType(Type.ErrorType t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType((List)s);
                }

                @Override
                public Type visitType(Type t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType(s);
                }
            };
            return type.accept(visitor, annotations);
        }

        private Attribute.TypeCompound toTypeCompound(Attribute.Compound a, TypeAnnotationPosition p) {
            return new Attribute.TypeCompound(a, p);
        }

        private TypeAnnotationPosition resolveFrame(JCTree tree, JCTree frame, List<JCTree> path, JCTree.JCLambda currentLambda, int outer_type_index, ListBuffer<TypeAnnotationPosition.TypePathEntry> location) {
            switch (frame.getKind()) {
                case TYPE_CAST: {
                    return TypeAnnotationPosition.typeCast(location.toList(), currentLambda, outer_type_index, frame.pos);
                }
                case INSTANCE_OF: {
                    return TypeAnnotationPosition.instanceOf(location.toList(), currentLambda, frame.pos);
                }
                case NEW_CLASS: {
                    JCTree.JCNewClass frameNewClass = (JCTree.JCNewClass)frame;
                    if (frameNewClass.def != null) {
                        JCTree.JCClassDecl frameClassDecl = frameNewClass.def;
                        if (frameClassDecl.extending == tree) {
                            return TypeAnnotationPosition.classExtends(location.toList(), currentLambda, frame.pos);
                        }
                        if (frameClassDecl.implementing.contains(tree)) {
                            int type_index = frameClassDecl.implementing.indexOf(tree);
                            return TypeAnnotationPosition.classExtends(location.toList(), currentLambda, type_index, frame.pos);
                        }
                        String type_index = String.valueOf(String.valueOf(tree));
                        String string = String.valueOf(String.valueOf(frame));
                        throw new AssertionError((Object)new StringBuilder(51 + type_index.length() + string.length()).append("Could not determine position of tree ").append(type_index).append(" within frame ").append(string).toString());
                    }
                    if (frameNewClass.typeargs.contains(tree)) {
                        int type_index = frameNewClass.typeargs.indexOf(tree);
                        return TypeAnnotationPosition.constructorInvocationTypeArg(location.toList(), currentLambda, type_index, frame.pos);
                    }
                    return TypeAnnotationPosition.newObj(location.toList(), currentLambda, frame.pos);
                }
                case NEW_ARRAY: {
                    return TypeAnnotationPosition.newObj(location.toList(), currentLambda, frame.pos);
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    if (((JCTree.JCClassDecl)frame).extending == tree) {
                        return TypeAnnotationPosition.classExtends(location.toList(), currentLambda, frame.pos);
                    }
                    if (((JCTree.JCClassDecl)frame).implementing.contains(tree)) {
                        int type_index = ((JCTree.JCClassDecl)frame).implementing.indexOf(tree);
                        return TypeAnnotationPosition.classExtends(location.toList(), currentLambda, type_index, frame.pos);
                    }
                    if (((JCTree.JCClassDecl)frame).typarams.contains(tree)) {
                        int parameter_index = ((JCTree.JCClassDecl)frame).typarams.indexOf(tree);
                        return TypeAnnotationPosition.typeParameter(location.toList(), currentLambda, parameter_index, frame.pos);
                    }
                    String parameter_index = String.valueOf(String.valueOf(tree));
                    String type_index = String.valueOf(String.valueOf(frame));
                    throw new AssertionError((Object)new StringBuilder(51 + parameter_index.length() + type_index.length()).append("Could not determine position of tree ").append(parameter_index).append(" within frame ").append(type_index).toString());
                }
                case METHOD: {
                    JCTree.JCMethodDecl frameMethod = (JCTree.JCMethodDecl)frame;
                    if (frameMethod.thrown.contains(tree)) {
                        int type_index = frameMethod.thrown.indexOf(tree);
                        return TypeAnnotationPosition.methodThrows(location.toList(), currentLambda, type_index, frame.pos);
                    }
                    if (frameMethod.restype == tree) {
                        return TypeAnnotationPosition.methodReturn(location.toList(), currentLambda, frame.pos);
                    }
                    if (frameMethod.typarams.contains(tree)) {
                        int parameter_index = frameMethod.typarams.indexOf(tree);
                        return TypeAnnotationPosition.methodTypeParameter(location.toList(), currentLambda, parameter_index, frame.pos);
                    }
                    String parameter_index = String.valueOf(String.valueOf(tree));
                    String string = String.valueOf(String.valueOf(frame));
                    throw new AssertionError((Object)new StringBuilder(51 + parameter_index.length() + string.length()).append("Could not determine position of tree ").append(parameter_index).append(" within frame ").append(string).toString());
                }
                case PARAMETERIZED_TYPE: {
                    List<JCTree> newPath = path.tail;
                    if (((JCTree.JCTypeApply)frame).clazz != tree) {
                        if (((JCTree.JCTypeApply)frame).arguments.contains(tree)) {
                            JCTree.JCTypeApply taframe = (JCTree.JCTypeApply)frame;
                            int arg = taframe.arguments.indexOf(tree);
                            location = location.prepend(new TypeAnnotationPosition.TypePathEntry(TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT, arg));
                            Type typeToUse = newPath.tail != null && ((JCTree)newPath.tail.head).hasTag(JCTree.Tag.NEWCLASS) ? ((JCTree)newPath.tail.head).type : taframe.type;
                            location = this.locateNestedTypes(typeToUse, location);
                        } else {
                            String taframe = String.valueOf(String.valueOf(tree));
                            String arg = String.valueOf(String.valueOf(frame));
                            throw new AssertionError((Object)new StringBuilder(65 + taframe.length() + arg.length()).append("Could not determine type argument position of tree ").append(taframe).append(" within frame ").append(arg).toString());
                        }
                    }
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, currentLambda, outer_type_index, location);
                }
                case MEMBER_REFERENCE: {
                    JCTree.JCMemberReference mrframe = (JCTree.JCMemberReference)frame;
                    if (mrframe.expr == tree) {
                        switch (mrframe.mode) {
                            case INVOKE: {
                                return TypeAnnotationPosition.methodRef(location.toList(), currentLambda, frame.pos);
                            }
                            case NEW: {
                                return TypeAnnotationPosition.constructorRef(location.toList(), currentLambda, frame.pos);
                            }
                        }
                        String taframe = String.valueOf(String.valueOf((Object)mrframe.mode));
                        String arg = String.valueOf(String.valueOf(tree));
                        String typeToUse = String.valueOf(String.valueOf(frame));
                        throw new AssertionError((Object)new StringBuilder(54 + taframe.length() + arg.length() + typeToUse.length()).append("Unknown method reference mode ").append(taframe).append(" for tree ").append(arg).append(" within frame ").append(typeToUse).toString());
                    }
                    if (mrframe.typeargs != null && mrframe.typeargs.contains(tree)) {
                        int type_index = mrframe.typeargs.indexOf(tree);
                        switch (mrframe.mode) {
                            case INVOKE: {
                                return TypeAnnotationPosition.methodRefTypeArg(location.toList(), currentLambda, type_index, frame.pos);
                            }
                            case NEW: {
                                return TypeAnnotationPosition.constructorRefTypeArg(location.toList(), currentLambda, type_index, frame.pos);
                            }
                        }
                        String arg = String.valueOf(String.valueOf((Object)mrframe.mode));
                        String typeToUse = String.valueOf(String.valueOf(tree));
                        String string = String.valueOf(String.valueOf(frame));
                        throw new AssertionError((Object)new StringBuilder(54 + arg.length() + typeToUse.length() + string.length()).append("Unknown method reference mode ").append(arg).append(" for tree ").append(typeToUse).append(" within frame ").append(string).toString());
                    }
                    String type_index = String.valueOf(String.valueOf(tree));
                    String arg = String.valueOf(String.valueOf(frame));
                    throw new AssertionError((Object)new StringBuilder(65 + type_index.length() + arg.length()).append("Could not determine type argument position of tree ").append(type_index).append(" within frame ").append(arg).toString());
                }
                case ARRAY_TYPE: {
                    location = location.prepend(TypeAnnotationPosition.TypePathEntry.ARRAY);
                    List<JCTree> newPath = path.tail;
                    while (true) {
                        JCTree npHead;
                        if ((npHead = (JCTree)newPath.tail.head).hasTag(JCTree.Tag.TYPEARRAY)) {
                            newPath = newPath.tail;
                            location = location.prepend(TypeAnnotationPosition.TypePathEntry.ARRAY);
                            continue;
                        }
                        if (!npHead.hasTag(JCTree.Tag.ANNOTATED_TYPE)) break;
                        newPath = newPath.tail;
                    }
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, currentLambda, outer_type_index, location);
                }
                case TYPE_PARAMETER: {
                    if (((JCTree)path.tail.tail.head).hasTag(JCTree.Tag.CLASSDEF)) {
                        JCTree.JCClassDecl clazz = (JCTree.JCClassDecl)path.tail.tail.head;
                        int parameter_index = clazz.typarams.indexOf(path.tail.head);
                        int bound_index = ((JCTree.JCTypeParameter)frame).bounds.get((int)0).type.isInterface() ? ((JCTree.JCTypeParameter)frame).bounds.indexOf(tree) + 1 : ((JCTree.JCTypeParameter)frame).bounds.indexOf(tree);
                        return TypeAnnotationPosition.typeParameterBound(location.toList(), currentLambda, parameter_index, bound_index, frame.pos);
                    }
                    if (((JCTree)path.tail.tail.head).hasTag(JCTree.Tag.METHODDEF)) {
                        JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)path.tail.tail.head;
                        int parameter_index = method.typarams.indexOf(path.tail.head);
                        int bound_index = ((JCTree.JCTypeParameter)frame).bounds.get((int)0).type.isInterface() ? ((JCTree.JCTypeParameter)frame).bounds.indexOf(tree) + 1 : ((JCTree.JCTypeParameter)frame).bounds.indexOf(tree);
                        return TypeAnnotationPosition.methodTypeParameterBound(location.toList(), currentLambda, parameter_index, bound_index, frame.pos);
                    }
                    String method = String.valueOf(String.valueOf(tree));
                    String parameter_index = String.valueOf(String.valueOf(frame));
                    throw new AssertionError((Object)new StringBuilder(51 + method.length() + parameter_index.length()).append("Could not determine position of tree ").append(method).append(" within frame ").append(parameter_index).toString());
                }
                case VARIABLE: {
                    Symbol.VarSymbol v = ((JCTree.JCVariableDecl)frame).sym;
                    if (v.getKind() != ElementKind.FIELD) {
                        v.owner.appendUniqueTypeAttributes(v.getRawTypeAttributes());
                    }
                    switch (v.getKind()) {
                        case LOCAL_VARIABLE: {
                            return TypeAnnotationPosition.localVariable(location.toList(), currentLambda, frame.pos);
                        }
                        case FIELD: {
                            return TypeAnnotationPosition.field(location.toList(), currentLambda, frame.pos);
                        }
                        case PARAMETER: {
                            if (v.getQualifiedName().equals(TypeAnnotations.this.names._this)) {
                                return TypeAnnotationPosition.methodReceiver(location.toList(), currentLambda, frame.pos);
                            }
                            int parameter_index = this.methodParamIndex(path, frame);
                            return TypeAnnotationPosition.methodParameter(location.toList(), currentLambda, parameter_index, frame.pos);
                        }
                        case EXCEPTION_PARAMETER: {
                            return TypeAnnotationPosition.exceptionParameter(location.toList(), currentLambda, frame.pos);
                        }
                        case RESOURCE_VARIABLE: {
                            return TypeAnnotationPosition.resourceVariable(location.toList(), currentLambda, frame.pos);
                        }
                    }
                    String parameter_index = String.valueOf(String.valueOf(v));
                    String bound_index = String.valueOf(String.valueOf((Object)v.getKind()));
                    throw new AssertionError((Object)new StringBuilder(59 + parameter_index.length() + bound_index.length()).append("Found unexpected type annotation for variable: ").append(parameter_index).append(" with kind: ").append(bound_index).toString());
                }
                case ANNOTATED_TYPE: {
                    if (frame == tree) {
                        JCTree.JCAnnotatedType atypetree = (JCTree.JCAnnotatedType)frame;
                        Type utype = atypetree.underlyingType.type;
                        Assert.checkNonNull(utype);
                        Symbol.TypeSymbol tsym = utype.tsym;
                        if (!(tsym.getKind().equals((Object)ElementKind.TYPE_PARAMETER) || utype.getKind().equals((Object)TypeKind.WILDCARD) || utype.getKind().equals((Object)TypeKind.ARRAY))) {
                            location = this.locateNestedTypes(utype, location);
                        }
                    }
                    List<JCTree> newPath = path.tail;
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, currentLambda, outer_type_index, location);
                }
                case UNION_TYPE: {
                    List<JCTree> newPath = path.tail;
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, currentLambda, outer_type_index, location);
                }
                case INTERSECTION_TYPE: {
                    JCTree.JCTypeIntersection isect = (JCTree.JCTypeIntersection)frame;
                    List<JCTree> newPath = path.tail;
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, currentLambda, isect.bounds.indexOf(tree), location);
                }
                case METHOD_INVOCATION: {
                    JCTree.JCMethodInvocation invocation = (JCTree.JCMethodInvocation)frame;
                    if (!invocation.typeargs.contains(tree)) {
                        String newPath = String.valueOf(String.valueOf(tree));
                        String tsym = String.valueOf(String.valueOf(invocation));
                        throw new AssertionError((Object)new StringBuilder(41 + newPath.length() + tsym.length()).append("{").append(newPath).append("} is not an argument in the invocation: ").append(tsym).toString());
                    }
                    Symbol.MethodSymbol exsym = (Symbol.MethodSymbol)TreeInfo.symbol(invocation.getMethodSelect());
                    int type_index = invocation.typeargs.indexOf(tree);
                    if (exsym == null) {
                        String string = String.valueOf(String.valueOf(invocation));
                        throw new AssertionError((Object)new StringBuilder(33 + string.length()).append("could not determine symbol for {").append(string).append("}").toString());
                    }
                    if (exsym.isConstructor()) {
                        return TypeAnnotationPosition.constructorInvocationTypeArg(location.toList(), currentLambda, type_index, invocation.pos);
                    }
                    return TypeAnnotationPosition.methodInvocationTypeArg(location.toList(), currentLambda, type_index, invocation.pos);
                }
                case EXTENDS_WILDCARD: 
                case SUPER_WILDCARD: {
                    List<JCTree> newPath = path.tail;
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, currentLambda, outer_type_index, location.prepend(TypeAnnotationPosition.TypePathEntry.WILDCARD));
                }
                case MEMBER_SELECT: {
                    List<JCTree> newPath = path.tail;
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, currentLambda, outer_type_index, location);
                }
            }
            String string = String.valueOf(String.valueOf(frame));
            String string2 = String.valueOf(String.valueOf((Object)frame.getKind()));
            String string3 = String.valueOf(String.valueOf(tree));
            throw new AssertionError((Object)new StringBuilder(51 + string.length() + string2.length() + string3.length()).append("Unresolved frame: ").append(string).append(" of kind: ").append(string2).append("\n    Looking for tree: ").append(string3).toString());
        }

        private ListBuffer<TypeAnnotationPosition.TypePathEntry> locateNestedTypes(Type type, ListBuffer<TypeAnnotationPosition.TypePathEntry> depth) {
            for (Type encl = type.getEnclosingType(); encl != null && encl.getKind() != TypeKind.NONE && encl.getKind() != TypeKind.ERROR; encl = encl.getEnclosingType()) {
                depth = depth.prepend(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
            }
            return depth;
        }

        private int methodParamIndex(List<JCTree> path, JCTree param) {
            List<JCTree> curr = path;
            while (((JCTree)curr.head).getTag() != JCTree.Tag.METHODDEF && ((JCTree)curr.head).getTag() != JCTree.Tag.LAMBDA) {
                curr = curr.tail;
            }
            if (((JCTree)curr.head).getTag() == JCTree.Tag.METHODDEF) {
                JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)curr.head;
                return method.params.indexOf(param);
            }
            if (((JCTree)curr.head).getTag() == JCTree.Tag.LAMBDA) {
                JCTree.JCLambda lambda = (JCTree.JCLambda)curr.head;
                return lambda.params.indexOf(param);
            }
            String string = String.valueOf(String.valueOf(param));
            Assert.error(new StringBuilder(62 + string.length()).append("methodParamIndex expected to find method or lambda for param: ").append(string).toString());
            return -1;
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (this.isInClass) {
                return;
            }
            this.isInClass = true;
            if (this.sigOnly) {
                this.scan(tree.mods);
                this.scan(tree.typarams);
                this.scan(tree.extending);
                this.scan(tree.implementing);
            }
            this.scan(tree.defs);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if (tree.sym == null) {
                Assert.error("Visiting tree node before memberEnter");
            }
            if (this.sigOnly) {
                TypeAnnotationPosition pos;
                if (!tree.mods.annotations.isEmpty()) {
                    if (tree.sym.isConstructor()) {
                        pos = TypeAnnotationPosition.methodReturn(tree.pos);
                        this.separateAnnotationsKinds(tree, null, tree.sym, pos);
                    } else {
                        pos = TypeAnnotationPosition.methodReturn(tree.restype.pos);
                        this.separateAnnotationsKinds(tree.restype, tree.sym.type.getReturnType(), tree.sym, pos);
                    }
                }
                if (tree.recvparam != null && tree.recvparam.sym != null && !tree.recvparam.mods.annotations.isEmpty()) {
                    pos = TypeAnnotationPosition.methodReceiver(tree.recvparam.vartype.pos);
                    this.separateAnnotationsKinds(tree.recvparam.vartype, tree.recvparam.sym.type, tree.recvparam.sym, pos);
                }
                int i = 0;
                for (JCTree.JCVariableDecl param : tree.params) {
                    if (!param.mods.annotations.isEmpty()) {
                        TypeAnnotationPosition pos2 = TypeAnnotationPosition.methodParameter(i, param.vartype.pos);
                        this.separateAnnotationsKinds(param.vartype, param.sym.type, param.sym, pos2);
                    }
                    ++i;
                }
            }
            this.push(tree);
            if (this.sigOnly) {
                this.scan(tree.mods);
                this.scan(tree.restype);
                this.scan(tree.typarams);
                this.scan(tree.recvparam);
                this.scan(tree.params);
                this.scan(tree.thrown);
            } else {
                this.scan(tree.defaultValue);
                this.scan(tree.body);
            }
            this.pop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            JCTree.JCLambda prevLambda = this.currentLambda;
            try {
                this.currentLambda = tree;
                int i = 0;
                for (JCTree.JCVariableDecl param : tree.params) {
                    if (!param.mods.annotations.isEmpty()) {
                        TypeAnnotationPosition pos = TypeAnnotationPosition.methodParameter(tree, i, param.vartype.pos);
                        this.separateAnnotationsKinds(param.vartype, param.sym.type, param.sym, pos);
                    }
                    ++i;
                }
                this.push(tree);
                this.scan(tree.body);
                this.scan(tree.params);
                this.pop();
            }
            finally {
                this.currentLambda = prevLambda;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            if (!tree.mods.annotations.isEmpty()) {
                if (tree.sym == null) {
                    Assert.error("Visiting tree node before memberEnter");
                } else if (tree.sym.getKind() != ElementKind.PARAMETER) {
                    if (tree.sym.getKind() == ElementKind.FIELD) {
                        if (this.sigOnly) {
                            TypeAnnotationPosition pos = TypeAnnotationPosition.field(tree.pos);
                            this.separateAnnotationsKinds(tree.vartype, tree.sym.type, tree.sym, pos);
                        }
                    } else if (tree.sym.getKind() == ElementKind.LOCAL_VARIABLE) {
                        TypeAnnotationPosition pos = TypeAnnotationPosition.localVariable(this.currentLambda, tree.pos);
                        this.separateAnnotationsKinds(tree.vartype, tree.sym.type, tree.sym, pos);
                    } else if (tree.sym.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                        TypeAnnotationPosition pos = TypeAnnotationPosition.exceptionParameter(this.currentLambda, tree.pos);
                        this.separateAnnotationsKinds(tree.vartype, tree.sym.type, tree.sym, pos);
                    } else if (tree.sym.getKind() == ElementKind.RESOURCE_VARIABLE) {
                        TypeAnnotationPosition pos = TypeAnnotationPosition.resourceVariable(this.currentLambda, tree.pos);
                        this.separateAnnotationsKinds(tree.vartype, tree.sym.type, tree.sym, pos);
                    } else if (tree.sym.getKind() != ElementKind.ENUM_CONSTANT) {
                        String string = String.valueOf(String.valueOf(tree));
                        String string2 = String.valueOf(String.valueOf((Object)tree.sym.getKind()));
                        Assert.error(new StringBuilder(35 + string.length() + string2.length()).append("Unhandled variable kind: ").append(string).append(" of kind: ").append(string2).toString());
                    }
                }
            }
            this.push(tree);
            this.scan(tree.mods);
            this.scan(tree.vartype);
            if (!this.sigOnly) {
                this.scan(tree.init);
            }
            this.pop();
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            if (!this.sigOnly) {
                this.scan(tree.stats);
            }
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
            this.push(tree);
            this.findPosition(tree, tree, tree.annotations);
            this.pop();
            super.visitAnnotatedType(tree);
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter tree) {
            this.findPosition(tree, this.peek2(), tree.annotations);
            super.visitTypeParameter(tree);
        }

        private void copyNewClassAnnotationsToOwner(JCTree.JCNewClass tree) {
            Symbol.ClassSymbol sym = tree.def.sym;
            TypeAnnotationPosition pos = TypeAnnotationPosition.newObj(tree.pos);
            ListBuffer<Attribute.TypeCompound> newattrs = new ListBuffer<Attribute.TypeCompound>();
            for (Attribute.TypeCompound old : ((Symbol)sym).getRawTypeAttributes()) {
                newattrs.append(new Attribute.TypeCompound(old.type, old.values, pos));
            }
            sym.owner.appendUniqueTypeAttributes(newattrs.toList());
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            if (tree.def != null && !tree.def.mods.annotations.isEmpty()) {
                TypeAnnotationPosition pos;
                JCTree.JCClassDecl classdecl = tree.def;
                if (classdecl.extending == tree.clazz) {
                    pos = TypeAnnotationPosition.classExtends(tree.pos);
                } else if (classdecl.implementing.contains(tree.clazz)) {
                    int index = classdecl.implementing.indexOf(tree.clazz);
                    pos = TypeAnnotationPosition.classExtends(index, tree.pos);
                } else {
                    String index = String.valueOf(String.valueOf(tree));
                    throw new AssertionError((Object)new StringBuilder(37 + index.length()).append("Could not determine position of tree ").append(index).toString());
                }
                Type before = classdecl.sym.type;
                this.separateAnnotationsKinds(classdecl, tree.clazz.type, classdecl.sym, pos);
                this.copyNewClassAnnotationsToOwner(tree);
                classdecl.sym.type = before;
            }
            this.scan(tree.encl);
            this.scan(tree.typeargs);
            this.scan(tree.clazz);
            this.scan(tree.args);
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray tree) {
            this.findPosition(tree, tree, tree.annotations);
            int dimAnnosCount = tree.dimAnnotations.size();
            ListBuffer<Object> depth = new ListBuffer<TypeAnnotationPosition.TypePathEntry>();
            for (int i = 0; i < dimAnnosCount; ++i) {
                ListBuffer<Object> location = new ListBuffer<Object>();
                if (i != 0) {
                    depth = depth.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                    location = location.appendList(depth.toList());
                }
                TypeAnnotationPosition p = TypeAnnotationPosition.newObj(location.toList(), this.currentLambda, tree.pos);
                this.setTypeAnnotationPos(tree.dimAnnotations.get(i), p);
            }
            JCTree.JCExpression elemType = tree.elemtype;
            depth = depth.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
            while (elemType != null) {
                if (elemType.hasTag(JCTree.Tag.ANNOTATED_TYPE)) {
                    JCTree.JCAnnotatedType at = (JCTree.JCAnnotatedType)elemType;
                    ListBuffer<TypeAnnotationPosition.TypePathEntry> locationbuf = this.locateNestedTypes(elemType.type, new ListBuffer<TypeAnnotationPosition.TypePathEntry>());
                    List<Object> location = locationbuf.toList().prependList(depth.toList());
                    TypeAnnotationPosition p = TypeAnnotationPosition.newObj(location, this.currentLambda, tree.pos);
                    this.setTypeAnnotationPos(at.annotations, p);
                    elemType = at.underlyingType;
                    continue;
                }
                if (elemType.hasTag(JCTree.Tag.TYPEARRAY)) {
                    depth = depth.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                    elemType = ((JCTree.JCArrayTypeTree)elemType).elemtype;
                    continue;
                }
                if (!elemType.hasTag(JCTree.Tag.SELECT)) break;
                elemType = ((JCTree.JCFieldAccess)elemType).selected;
            }
            this.scan(tree.elems);
        }

        private void findPosition(JCTree tree, JCTree frame, List<JCTree.JCAnnotation> annotations) {
            if (!annotations.isEmpty()) {
                TypeAnnotationPosition p = this.resolveFrame(tree, frame, this.frames.toList(), this.currentLambda, 0, new ListBuffer<TypeAnnotationPosition.TypePathEntry>());
                this.setTypeAnnotationPos(annotations, p);
            }
        }

        private void setTypeAnnotationPos(List<JCTree.JCAnnotation> annotations, TypeAnnotationPosition position) {
            for (JCTree.JCAnnotation anno : annotations) {
                if (anno.attribute == null) continue;
                ((Attribute.TypeCompound)anno.attribute).position = position;
            }
        }

        public String toString() {
            String string = String.valueOf(String.valueOf(super.toString()));
            boolean bl = this.sigOnly;
            return new StringBuilder(16 + string.length()).append(string).append(": sigOnly: ").append(bl).toString();
        }
    }

    public static enum AnnotationType {
        DECLARATION,
        TYPE,
        BOTH;

    }
}

