/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.api.RegistryUnauthorizedException;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.FailoverHttpClient;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.AuthenticationMethodRetriever;
import com.google.cloud.tools.jib.registry.BlobChecker;
import com.google.cloud.tools.jib.registry.BlobPuller;
import com.google.cloud.tools.jib.registry.BlobPusher;
import com.google.cloud.tools.jib.registry.ManifestAndDigest;
import com.google.cloud.tools.jib.registry.ManifestChecker;
import com.google.cloud.tools.jib.registry.ManifestPuller;
import com.google.cloud.tools.jib.registry.ManifestPusher;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryCredentialsNotSentException;
import com.google.cloud.tools.jib.registry.RegistryEndpointCaller;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RegistryClient {
    private static final int MAX_BEARER_TOKEN_REFRESH_TRIES = 5;
    private final EventHandlers eventHandlers;
    @Nullable
    private final Credential credential;
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    @Nullable
    private final String userAgent;
    private final FailoverHttpClient httpClient;
    private final AtomicReference<Authorization> authorization = new AtomicReference();
    private boolean readOnlyBearerAuth;
    private final AtomicReference<RegistryAuthenticator> initialBearerAuthenticator = new AtomicReference();

    public static Factory factory(EventHandlers eventHandlers, String serverUrl, String imageName, FailoverHttpClient httpClient) {
        return new Factory(eventHandlers, new RegistryEndpointRequestProperties(serverUrl, imageName), httpClient);
    }

    public static Factory factory(EventHandlers eventHandlers, String serverUrl, String imageName, String sourceImageName, FailoverHttpClient httpClient) {
        return new Factory(eventHandlers, new RegistryEndpointRequestProperties(serverUrl, imageName, sourceImageName), httpClient);
    }

    @Nullable
    @VisibleForTesting
    static Multimap<String, String> decodeTokenRepositoryGrants(String token) {
        String[] jwtParts = token.split("\\.", -1);
        if (jwtParts.length != 3) {
            return null;
        }
        byte[] payloadData = Base64.getDecoder().decode(jwtParts[1]);
        try {
            TokenPayloadTemplate payload = JsonTemplateMapper.readJson(payloadData, TokenPayloadTemplate.class);
            if (payload.access == null) {
                return null;
            }
            return (Multimap)payload.access.stream().filter(claim -> "repository".equals(((AccessClaim)claim).type)).collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(claim -> ((AccessClaim)claim).name, claim -> ((AccessClaim)claim).actions == null ? Stream.empty() : ((AccessClaim)claim).actions.stream()));
        }
        catch (IOException ex) {
            return null;
        }
    }

    private RegistryClient(EventHandlers eventHandlers, @Nullable Credential credential, RegistryEndpointRequestProperties registryEndpointRequestProperties, @Nullable String userAgent, FailoverHttpClient httpClient) {
        this.eventHandlers = eventHandlers;
        this.credential = credential;
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.userAgent = userAgent;
        this.httpClient = httpClient;
    }

    public void configureBasicAuth() {
        Preconditions.checkNotNull((Object)this.credential);
        Preconditions.checkState((!this.credential.isOAuth2RefreshToken() ? 1 : 0) != 0);
        this.authorization.set(Authorization.fromBasicCredentials(this.credential.getUsername(), this.credential.getPassword()));
        String registry = this.registryEndpointRequestProperties.getServerUrl();
        String repository = this.registryEndpointRequestProperties.getImageName();
        this.eventHandlers.dispatch(LogEvent.debug("configured basic auth for " + registry + "/" + repository));
    }

    public boolean doPullBearerAuth() throws IOException, RegistryException {
        return this.doBearerAuth(true);
    }

    public boolean doPushBearerAuth() throws IOException, RegistryException {
        return this.doBearerAuth(false);
    }

    private boolean doBearerAuth(boolean readOnlyBearerAuth) throws IOException, RegistryException {
        String registry = this.registryEndpointRequestProperties.getServerUrl();
        String repository = this.registryEndpointRequestProperties.getImageName();
        String image = registry + "/" + repository;
        this.eventHandlers.dispatch(LogEvent.debug("attempting bearer auth for " + image + "..."));
        Optional<RegistryAuthenticator> authenticator = this.callRegistryEndpoint(new AuthenticationMethodRetriever(this.registryEndpointRequestProperties, this.getUserAgent(), this.httpClient));
        if (!authenticator.isPresent()) {
            this.eventHandlers.dispatch(LogEvent.debug("server requires basic auth for " + image));
            return false;
        }
        this.doBearerAuth(readOnlyBearerAuth, authenticator.get());
        return true;
    }

    private void doBearerAuth(boolean readOnlyBearerAuth, RegistryAuthenticator authenticator) throws RegistryException {
        this.initialBearerAuthenticator.set(authenticator);
        if (readOnlyBearerAuth) {
            this.authorization.set(authenticator.authenticatePull(this.credential));
        } else {
            this.authorization.set(authenticator.authenticatePush(this.credential));
        }
        this.readOnlyBearerAuth = readOnlyBearerAuth;
        this.eventHandlers.dispatch(LogEvent.debug("bearer auth succeeded for " + this.registryEndpointRequestProperties.getServerUrl() + "/" + this.registryEndpointRequestProperties.getImageName()));
    }

    private Authorization refreshBearerAuth(@Nullable String wwwAuthenticate) throws RegistryAuthenticationFailedException, RegistryCredentialsNotSentException {
        Optional<RegistryAuthenticator> authenticator;
        Preconditions.checkState((boolean)RegistryClient.isBearerAuth(this.authorization.get()));
        String registry = this.registryEndpointRequestProperties.getServerUrl();
        String repository = this.registryEndpointRequestProperties.getImageName();
        this.eventHandlers.dispatch(LogEvent.debug("refreshing bearer auth token for " + registry + "/" + repository + "..."));
        if (wwwAuthenticate != null && (authenticator = RegistryAuthenticator.fromAuthenticationMethod(wwwAuthenticate, this.registryEndpointRequestProperties, this.getUserAgent(), this.httpClient)).isPresent()) {
            if (this.readOnlyBearerAuth) {
                return authenticator.get().authenticatePull(this.credential);
            }
            return authenticator.get().authenticatePush(this.credential);
        }
        this.eventHandlers.dispatch(LogEvent.debug("server did not return 'WWW-Authenticate: Bearer' header. Actual: " + wwwAuthenticate));
        if (this.readOnlyBearerAuth) {
            return ((RegistryAuthenticator)Verify.verifyNotNull((Object)this.initialBearerAuthenticator.get())).authenticatePull(this.credential);
        }
        return ((RegistryAuthenticator)Verify.verifyNotNull((Object)this.initialBearerAuthenticator.get())).authenticatePush(this.credential);
    }

    public void authPullByWwwAuthenticate(String wwwAuthenticate) throws RegistryException {
        Optional<RegistryAuthenticator> authenticator = RegistryAuthenticator.fromAuthenticationMethod(wwwAuthenticate, this.registryEndpointRequestProperties, this.getUserAgent(), this.httpClient);
        if (authenticator.isPresent()) {
            this.doBearerAuth(true, authenticator.get());
        } else if (this.credential != null && !this.credential.isOAuth2RefreshToken()) {
            this.configureBasicAuth();
        }
    }

    public Optional<ManifestAndDigest<ManifestTemplate>> checkManifest(String imageQualifier) throws IOException, RegistryException {
        ManifestChecker<ManifestTemplate> manifestChecker = new ManifestChecker<ManifestTemplate>(this.registryEndpointRequestProperties, imageQualifier, ManifestTemplate.class);
        return (Optional)((Object)this.callRegistryEndpoint(manifestChecker));
    }

    public <T extends ManifestTemplate> ManifestAndDigest<T> pullManifest(String imageQualifier, Class<T> manifestTemplateClass) throws IOException, RegistryException {
        ManifestPuller<T> manifestPuller = new ManifestPuller<T>(this.registryEndpointRequestProperties, imageQualifier, manifestTemplateClass);
        return (ManifestAndDigest)this.callRegistryEndpoint(manifestPuller);
    }

    public ManifestAndDigest<ManifestTemplate> pullManifest(String imageQualifier) throws IOException, RegistryException {
        return this.pullManifest(imageQualifier, ManifestTemplate.class);
    }

    public DescriptorDigest pushManifest(ManifestTemplate manifestTemplate, String imageTag) throws IOException, RegistryException {
        if (RegistryClient.isBearerAuth(this.authorization.get()) && this.readOnlyBearerAuth) {
            throw new IllegalStateException("push may fail with pull-only bearer auth token");
        }
        return this.callRegistryEndpoint(new ManifestPusher(this.registryEndpointRequestProperties, manifestTemplate, imageTag, this.eventHandlers));
    }

    public Optional<BlobDescriptor> checkBlob(DescriptorDigest blobDigest) throws IOException, RegistryException {
        BlobChecker blobChecker = new BlobChecker(this.registryEndpointRequestProperties, blobDigest);
        return this.callRegistryEndpoint(blobChecker);
    }

    public Blob pullBlob(DescriptorDigest blobDigest, Consumer<Long> blobSizeListener, Consumer<Long> writtenByteCountListener) {
        return Blobs.from(outputStream -> {
            try {
                this.callRegistryEndpoint(new BlobPuller(this.registryEndpointRequestProperties, blobDigest, outputStream, blobSizeListener, writtenByteCountListener));
            }
            catch (RegistryException ex) {
                throw new IOException(ex);
            }
        }, false);
    }

    public boolean pushBlob(DescriptorDigest blobDigest, Blob blob, @Nullable String sourceRepository, Consumer<Long> writtenByteCountListener) throws IOException, RegistryException {
        if (RegistryClient.isBearerAuth(this.authorization.get()) && this.readOnlyBearerAuth) {
            throw new IllegalStateException("push may fail with pull-only bearer auth token");
        }
        if (!(sourceRepository == null || JibSystemProperties.useCrossRepositoryBlobMounts() && RegistryClient.canAttemptBlobMount(this.authorization.get(), sourceRepository))) {
            sourceRepository = null;
        }
        BlobPusher blobPusher = new BlobPusher(this.registryEndpointRequestProperties, blobDigest, blob, sourceRepository);
        try (TimerEventDispatcher timerEventDispatcher = new TimerEventDispatcher(this.eventHandlers, "pushBlob");){
            Optional<URL> patchLocation;
            TimerEventDispatcher timerEventDispatcher2;
            block17: {
                timerEventDispatcher2 = timerEventDispatcher.subTimer("pushBlob POST " + blobDigest);
                try {
                    patchLocation = this.callRegistryEndpoint(blobPusher.initializer());
                    if (patchLocation.isPresent()) break block17;
                    boolean bl = true;
                    if (timerEventDispatcher2 != null) {
                        timerEventDispatcher2.close();
                    }
                    return bl;
                }
                catch (Throwable throwable) {
                    if (timerEventDispatcher2 != null) {
                        try {
                            timerEventDispatcher2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            timerEventDispatcher2.lap("pushBlob PATCH " + blobDigest);
            URL putLocation = this.callRegistryEndpoint(blobPusher.writer(patchLocation.get(), writtenByteCountListener));
            timerEventDispatcher2.lap("pushBlob PUT " + blobDigest);
            this.callRegistryEndpoint(blobPusher.committer(putLocation));
            boolean bl = false;
            if (timerEventDispatcher2 != null) {
                timerEventDispatcher2.close();
            }
            return bl;
        }
    }

    @VisibleForTesting
    static boolean canAttemptBlobMount(@Nullable Authorization authorization, String repository) {
        if (!RegistryClient.isBearerAuth(authorization)) {
            return true;
        }
        Multimap<String, String> repositoryGrants = RegistryClient.decodeTokenRepositoryGrants(((Authorization)Verify.verifyNotNull((Object)authorization)).getToken());
        return repositoryGrants == null || repositoryGrants.containsEntry((Object)repository, (Object)"pull");
    }

    private static boolean isBearerAuth(@Nullable Authorization authorization) {
        return authorization != null && "bearer".equalsIgnoreCase(authorization.getScheme());
    }

    @Nullable
    @VisibleForTesting
    String getUserAgent() {
        return this.userAgent;
    }

    private <T> T callRegistryEndpoint(RegistryEndpointProvider<T> registryEndpointProvider) throws IOException, RegistryException {
        int bearerTokenRefreshes = 0;
        while (true) {
            try {
                return new RegistryEndpointCaller<T>(this.eventHandlers, this.getUserAgent(), registryEndpointProvider, this.authorization.get(), this.registryEndpointRequestProperties, this.httpClient).call();
            }
            catch (RegistryUnauthorizedException ex) {
                if (ex.getHttpResponseException().getStatusCode() != 401 || !RegistryClient.isBearerAuth(this.authorization.get()) || ++bearerTokenRefreshes >= 5) {
                    throw ex;
                }
                String wwwAuthenticate = ex.getHttpResponseException().getHeaders().getAuthenticate();
                this.authorization.set(this.refreshBearerAuth(wwwAuthenticate));
                continue;
            }
            break;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class AccessClaim
    implements JsonTemplate {
        @Nullable
        private String type;
        @Nullable
        private String name;
        @Nullable
        private List<String> actions;

        private AccessClaim() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class TokenPayloadTemplate
    implements JsonTemplate {
        @Nullable
        private List<AccessClaim> access;

        private TokenPayloadTemplate() {
        }
    }

    public static class Factory {
        private final EventHandlers eventHandlers;
        private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
        private final FailoverHttpClient httpClient;
        @Nullable
        private String userAgent;
        @Nullable
        private Credential credential;

        private Factory(EventHandlers eventHandlers, RegistryEndpointRequestProperties registryEndpointRequestProperties, FailoverHttpClient httpClient) {
            this.eventHandlers = eventHandlers;
            this.registryEndpointRequestProperties = registryEndpointRequestProperties;
            this.httpClient = httpClient;
        }

        public Factory setCredential(@Nullable Credential credential) {
            this.credential = credential;
            return this;
        }

        public Factory setUserAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public RegistryClient newRegistryClient() {
            return new RegistryClient(this.eventHandlers, this.credential, this.registryEndpointRequestProperties, this.userAgent, this.httpClient);
        }
    }
}

