/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.xmpp.dev;

import com.google.appengine.api.xmpp.XMPPServicePb;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LatencyPercentiles;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import java.util.Map;

@ServiceProvider(value=LocalRpcService.class)
public final class LocalXMPPService
extends AbstractLocalRpcService {
    public static final String PACKAGE = "xmpp";

    public void start() {
    }

    public void stop() {
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
    }

    public String getPackage() {
        return PACKAGE;
    }

    private boolean isAvailable(String jid) {
        return jid.charAt(0) < 'm';
    }

    @LatencyPercentiles(latency50th=50)
    public XMPPServicePb.PresenceResponse getPresence(LocalRpcService.Status status, XMPPServicePb.PresenceRequest request) {
        XMPPServicePb.PresenceResponse response = new XMPPServicePb.PresenceResponse();
        response.setIsAvailable(this.isAvailable(request.getJid()));
        return response;
    }

    @LatencyPercentiles(latency50th=50)
    public XMPPServicePb.BulkPresenceResponse bulkGetPresence(LocalRpcService.Status status, XMPPServicePb.BulkPresenceRequest request) {
        XMPPServicePb.BulkPresenceResponse response = new XMPPServicePb.BulkPresenceResponse();
        for (String jid : request.jids()) {
            XMPPServicePb.PresenceResponse subresponse = response.addPresenceResponse();
            subresponse.setIsAvailable(this.isAvailable(jid));
        }
        return response;
    }

    @LatencyPercentiles(latency50th=40)
    public XMPPServicePb.XmppMessageResponse sendMessage(LocalRpcService.Status status, XMPPServicePb.XmppMessageRequest request) {
        System.out.println("Sending an XMPP Message:");
        System.out.println("    Body:");
        System.out.println("        " + request.getBody());
        System.out.println("    Type:");
        System.out.println("        " + request.getType());
        System.out.println("    RawXml:");
        System.out.println("        " + request.isRawXml());
        if (request.hasFromJid()) {
            System.out.println("    FromJid:");
            System.out.println("        " + request.getFromJid());
        }
        System.out.println("    To JIDs:");
        for (String jid : request.jids()) {
            System.out.println("        " + jid);
        }
        XMPPServicePb.XmppMessageResponse response = new XMPPServicePb.XmppMessageResponse();
        for (String jid : request.jids()) {
            response.addStatus(XMPPServicePb.XmppMessageResponse.XmppMessageStatus.NO_ERROR.getValue());
        }
        return response;
    }

    public XMPPServicePb.XmppInviteResponse sendInvite(LocalRpcService.Status status, XMPPServicePb.XmppInviteRequest request) {
        System.out.println("Sending an XMPP Invitation:");
        System.out.println("    To JID:");
        System.out.println("        " + request.getJid());
        XMPPServicePb.XmppInviteResponse response = new XMPPServicePb.XmppInviteResponse();
        return response;
    }

    @LatencyPercentiles(latency50th=4)
    public XMPPServicePb.XmppSendPresenceResponse sendPresence(LocalRpcService.Status status, XMPPServicePb.XmppSendPresenceRequest request) {
        System.out.println("Sending an XMPP Presence:");
        System.out.println("    To JID:");
        System.out.println("        " + request.getJid());
        if (request.hasType()) {
            System.out.println("    Type:");
            System.out.println("        " + request.getType());
        }
        if (request.hasShow()) {
            System.out.println("    Show:");
            System.out.println("        " + request.getShow());
        }
        if (request.hasStatus()) {
            System.out.println("    Status:");
            System.out.println("        " + request.getStatus());
        }
        if (request.hasFromJid()) {
            System.out.println("    From JID:");
            System.out.println("        " + request.getFromJid());
        }
        XMPPServicePb.XmppSendPresenceResponse response = new XMPPServicePb.XmppSendPresenceResponse();
        return response;
    }
}

