/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.LuceneQueryTreeContext;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import com.google.appengine.repackaged.com.google.common.geometry.S2RegionCoverer;
import com.google.apphosting.api.search.DocumentPb;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

class GeometricQuery
extends BooleanQuery {
    private final String fieldName;
    private final String luceneFieldName;
    private final S2LatLng point;
    private final LuceneQueryTreeContext.ComparisonOp op;
    private final double distance;

    static Query create(String fieldName, double latitude, double longitude, LuceneQueryTreeContext.ComparisonOp op, double distance) {
        switch (op) {
            case GE: 
            case GT: 
            case LE: 
            case LT: {
                return new GeometricQuery(fieldName, latitude, longitude, op, distance);
            }
        }
        return LuceneUtils.getMatchNoneQuery();
    }

    private GeometricQuery(String fieldName, double latitude, double longitude, LuceneQueryTreeContext.ComparisonOp op, double distance) {
        this.fieldName = fieldName;
        this.luceneFieldName = LuceneUtils.makeLuceneFieldName(fieldName, DocumentPb.FieldValue.ContentType.GEO);
        this.point = S2LatLng.fromDegrees((double)latitude, (double)longitude).normalized();
        this.op = op;
        this.distance = distance;
        this.init();
    }

    private void init() {
        S1Angle angle = S1Angle.radians((double)(this.distance / 6371010.0));
        S2Cap cap = S2Cap.fromAxisAngle((S2Point)this.point.toPoint(), (S1Angle)angle);
        S2RegionCoverer coverer = new S2RegionCoverer();
        coverer.setMinLevel(0);
        coverer.setMaxLevel(30);
        switch (this.op) {
            case LE: 
            case LT: {
                for (S2CellId cell : coverer.getCovering((S2Region)cap)) {
                    Term term = new Term(this.luceneFieldName, "S2:" + cell.level() + ":" + cell.toToken());
                    this.add(new TermQuery(term), BooleanClause.Occur.SHOULD);
                }
                break;
            }
            case GE: 
            case GT: {
                for (S2CellId cell : coverer.getInteriorCovering((S2Region)cap)) {
                    Term term = new Term(this.luceneFieldName, "S2:" + cell.level() + ":" + cell.toToken());
                    this.add(new TermQuery(term), BooleanClause.Occur.MUST_NOT);
                }
                Term term = new Term("_ALLDOC", "X");
                this.add(new TermQuery(term), BooleanClause.Occur.MUST);
                break;
            }
            default: {
                throw new IllegalStateException("op " + (Object)((Object)this.op));
            }
        }
    }

    @Override
    public String toString() {
        return String.format("GeometricQuery(field='%s' geopoint=(%f,%f) op=%s distance=%f)", new Object[]{this.fieldName, this.point.latDegrees(), this.point.lngDegrees(), this.op, this.distance});
    }
}

