/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.shingle;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Analyzer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.shingle.ShingleFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.standard.StandardAnalyzer;
import java.io.IOException;
import java.io.Reader;

public class ShingleAnalyzerWrapper
extends Analyzer {
    protected Analyzer defaultAnalyzer;
    protected int maxShingleSize = 2;
    protected boolean outputUnigrams = true;

    public ShingleAnalyzerWrapper(Analyzer defaultAnalyzer) {
        this.defaultAnalyzer = defaultAnalyzer;
        this.setOverridesTokenStreamMethod(ShingleAnalyzerWrapper.class);
    }

    public ShingleAnalyzerWrapper(Analyzer defaultAnalyzer, int maxShingleSize) {
        this(defaultAnalyzer);
        this.maxShingleSize = maxShingleSize;
    }

    public ShingleAnalyzerWrapper() {
        this.defaultAnalyzer = new StandardAnalyzer();
        this.setOverridesTokenStreamMethod(ShingleAnalyzerWrapper.class);
    }

    public ShingleAnalyzerWrapper(int nGramSize) {
        this();
        this.maxShingleSize = nGramSize;
    }

    public int getMaxShingleSize() {
        return this.maxShingleSize;
    }

    public void setMaxShingleSize(int maxShingleSize) {
        this.maxShingleSize = maxShingleSize;
    }

    public boolean isOutputUnigrams() {
        return this.outputUnigrams;
    }

    public void setOutputUnigrams(boolean outputUnigrams) {
        this.outputUnigrams = outputUnigrams;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream wrapped;
        try {
            wrapped = this.defaultAnalyzer.reusableTokenStream(fieldName, reader);
        }
        catch (IOException e) {
            wrapped = this.defaultAnalyzer.tokenStream(fieldName, reader);
        }
        ShingleFilter filter = new ShingleFilter(wrapped);
        filter.setMaxShingleSize(this.maxShingleSize);
        filter.setOutputUnigrams(this.outputUnigrams);
        return filter;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.wrapped = this.defaultAnalyzer.reusableTokenStream(fieldName, reader);
            streams.shingle = new ShingleFilter(streams.wrapped);
            this.setPreviousTokenStream(streams);
        } else {
            TokenStream result = this.defaultAnalyzer.reusableTokenStream(fieldName, reader);
            if (result == streams.wrapped) {
                streams.shingle.reset();
            } else {
                streams.wrapped = result;
                streams.shingle = new ShingleFilter(streams.wrapped);
            }
        }
        streams.shingle.setMaxShingleSize(this.maxShingleSize);
        streams.shingle.setOutputUnigrams(this.outputUnigrams);
        return streams.shingle;
    }

    private class SavedStreams {
        TokenStream wrapped;
        ShingleFilter shingle;

        private SavedStreams() {
        }
    }
}

