/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.dev.HighRepJobPolicy;

abstract class LocalDatastoreJob {
    final HighRepJobPolicy jobPolicy;
    final Key entityGroup;
    boolean newJob = true;
    boolean applied = false;

    LocalDatastoreJob(HighRepJobPolicy jobPolicy, Key entityGroup) {
        if (jobPolicy == null) {
            throw new NullPointerException("jobPolicy cannot be null");
        }
        this.jobPolicy = jobPolicy;
        if (entityGroup == null) {
            throw new NullPointerException("entityGroup cannot be null");
        }
        this.entityGroup = entityGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean tryApplyJob() {
        try {
            if (this.newJob) {
                if (this.jobPolicy.shouldApplyNewJob(this.entityGroup)) {
                    this.apply();
                    boolean bl = true;
                    return bl;
                }
            } else if (this.jobPolicy.shouldRollForwardExistingJob(this.entityGroup)) {
                this.apply();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.newJob = false;
        }
    }

    final void apply() {
        if (this.applied) {
            throw new IllegalStateException(String.format("Job on entity group %s was already applied.", this.entityGroup));
        }
        this.applied = true;
        this.applyInternal();
    }

    abstract void applyInternal();
}

