/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultipartRequestEntity
implements RequestEntity {
    private static final Log log = LogFactory.getLog(MultipartRequestEntity.class);
    private static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    private static byte[] MULTIPART_CHARS = EncodingUtil.getAsciiBytes("-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    protected Part[] parts;
    private byte[] multipartBoundary;
    private HttpMethodParams params;

    private static byte[] generateMultipartBoundary() {
        Random random = new Random();
        byte[] byArray = new byte[random.nextInt(11) + 30];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = MULTIPART_CHARS[random.nextInt(MULTIPART_CHARS.length)];
        }
        return byArray;
    }

    public MultipartRequestEntity(Part[] partArray, HttpMethodParams httpMethodParams) {
        if (partArray == null) {
            throw new IllegalArgumentException("parts cannot be null");
        }
        if (httpMethodParams == null) {
            throw new IllegalArgumentException("params cannot be null");
        }
        this.parts = partArray;
        this.params = httpMethodParams;
    }

    protected byte[] getMultipartBoundary() {
        if (this.multipartBoundary == null) {
            String string = (String)this.params.getParameter("http.method.multipart.boundary");
            this.multipartBoundary = string != null ? EncodingUtil.getAsciiBytes(string) : MultipartRequestEntity.generateMultipartBoundary();
        }
        return this.multipartBoundary;
    }

    public boolean isRepeatable() {
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i].isRepeatable()) continue;
            return false;
        }
        return true;
    }

    public void writeRequest(OutputStream outputStream) throws IOException {
        Part.sendParts(outputStream, this.parts, this.getMultipartBoundary());
    }

    public long getContentLength() {
        try {
            return Part.getLengthOfParts(this.parts, this.getMultipartBoundary());
        }
        catch (Exception exception) {
            log.error("An exception occurred while getting the length of the parts", exception);
            return 0L;
        }
    }

    public String getContentType() {
        StringBuffer stringBuffer = new StringBuffer(MULTIPART_FORM_CONTENT_TYPE);
        stringBuffer.append("; boundary=");
        stringBuffer.append(EncodingUtil.getAsciiString(this.getMultipartBoundary()));
        return stringBuffer.toString();
    }
}

