/*
 * Decompiled with CFR 0.152.
 */
package tray.linux;

import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jni.utils.StreamUtils;
import tray.TrayIconAdapter;
import tray.linux.NativeTray;
import tray.linux.TrayMethodsThatAreInvokedByTheNativeCounterpart;

public class LinuxTrayIconAdapter
implements TrayIconAdapter,
TrayMethodsThatAreInvokedByTheNativeCounterpart {
    private final NativeTray nativeTray;
    private final PopupMenu popup;
    private final String tooltip;
    private int nativeId;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();

    public LinuxTrayIconAdapter(NativeTray nativeTray, URL imageURL, String tooltip, PopupMenu popup) {
        this.nativeTray = nativeTray;
        this.tooltip = tooltip;
        this.popup = popup;
        this.setupNativeTrayIcon(imageURL);
    }

    public int getNativeId() {
        return this.nativeId;
    }

    @Override
    public void displayMessage(String title, String text, TrayIcon.MessageType info) {
        this.nativeTray.nativeDisplayMessage(this.nativeId, title, text, info);
    }

    @Override
    public void setImageAutoSize(boolean autosize) {
        this.nativeTray.nativeSetAutosize(this.nativeId, autosize);
    }

    @Override
    public void setImage(URL imageUrl) {
        URL existingFileUrl = this.makeSureUrlPointsToExistingFile(imageUrl);
        this.nativeTray.nativeSetImage(this.nativeId, existingFileUrl.getFile());
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    @Override
    public void fireActionActivated() {
        ActionEvent e = new ActionEvent(this, 0, "activate");
        for (ActionListener anActionListener : this.actionListeners) {
            anActionListener.actionPerformed(e);
        }
    }

    @Override
    public void fireMenuAction(int menuItemIndex) {
        MenuItem item = this.popup.getItem(menuItemIndex);
        ActionListener[] actionListeners = item.getActionListeners();
        ActionEvent e = new ActionEvent(item, 0, item.getActionCommand());
        for (ActionListener actionListener : actionListeners) {
            actionListener.actionPerformed(e);
        }
    }

    private URL makeSureUrlPointsToExistingFile(URL imageURL) {
        File imageFile = new File(imageURL.getFile());
        if (imageFile.exists()) {
            return imageURL;
        }
        try {
            imageFile = StreamUtils.getStreamAsTempFileOrCry((InputStream)imageURL.openStream(), (String)"trayIconRehydratedImage");
            URL extractedImageFileUrl = imageFile.toURI().toURL();
            return extractedImageFileUrl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setupNativeTrayIcon(URL imageURL) {
        URL existingFileUrl = this.makeSureUrlPointsToExistingFile(imageURL);
        this.nativeId = this.nativeTray.nativeCreateTrayIcon(existingFileUrl.getFile(), this.tooltip);
        this.populateNativeMenuListeners(this.popup);
    }

    private void populateNativeMenuListeners(PopupMenu popup) {
        for (int i = 0; i < popup.getItemCount(); ++i) {
            MenuItem item = popup.getItem(i);
            this.nativeTray.nativeAddMenuItem(this.nativeId, i, item.getLabel());
        }
    }

    public void removeMe() {
        this.nativeTray.nativeRemoveMe(this.nativeId);
    }
}

