/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbtractMultiParameterMathFunction;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

class Round
extends AbtractMultiParameterMathFunction {
    Round() {
    }

    @Override
    protected Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, FunctionExpression functionCall, HiddenTokenAwareTree parentToken) {
        NumberExpression parameter = (NumberExpression)splitParameters.get(0);
        Double oValue = parameter.getValueAsDouble();
        String suffix = parameter.getSuffix();
        NumberExpression.Dimension dimension = parameter.getDimension();
        if (oValue.isInfinite() || oValue.isNaN()) {
            return new NumberExpression(parentToken, oValue, suffix, null, dimension);
        }
        NumberExpression fraction = (NumberExpression)(splitParameters.size() > 1 ? splitParameters.get(1) : null);
        if (fraction != null) {
            double pow = Math.pow(10.0, fraction.getValueAsDouble());
            oValue = (double)Math.round(oValue * pow) / pow;
        } else {
            oValue = Math.round(oValue);
        }
        return new NumberExpression(parentToken, oValue, suffix, null, dimension);
    }

    @Override
    protected int getMinParameters() {
        return 1;
    }

    @Override
    protected int getMaxParameters() {
        return 2;
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.NUMBER);
    }

    @Override
    protected String getName() {
        return "round";
    }
}

