/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Comment;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.PubliclyCloneable;
import java.util.ArrayList;
import java.util.List;

public abstract class ASTCssNode
implements PubliclyCloneable {
    private ASTCssNode parent;
    private boolean isSilent = false;
    private HiddenTokenAwareTree underlyingStructure;
    private List<Comment> openingComments = new ArrayList<Comment>();
    private List<Comment> orphanComments = new ArrayList<Comment>();
    private List<Comment> trailingComments = new ArrayList<Comment>();

    public ASTCssNode(HiddenTokenAwareTree underlyingStructure) {
        this.underlyingStructure = underlyingStructure;
        if (underlyingStructure == null) {
            throw new IllegalArgumentException("Underlying can not be null. It is used for error reporting, so place there the closest token possible.");
        }
    }

    public boolean isSilent() {
        return this.isSilent;
    }

    public void setSilent(boolean isSilent) {
        this.isSilent = isSilent;
    }

    @NotAstProperty
    public abstract List<? extends ASTCssNode> getChilds();

    public ASTCssNode getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public void setParent(ASTCssNode parent) {
        this.parent = parent;
    }

    public HiddenTokenAwareTree getUnderlyingStructure() {
        return this.underlyingStructure;
    }

    public void setUnderlyingStructure(HiddenTokenAwareTree underlyingStructure) {
        this.underlyingStructure = underlyingStructure;
    }

    @NotAstProperty
    public List<Comment> getTrailingComments() {
        return this.trailingComments;
    }

    public void setTrailingComments(List<Comment> trailingComments) {
        this.trailingComments = trailingComments;
    }

    public void addTrailingComments(List<Comment> comments) {
        this.trailingComments.addAll(comments);
    }

    public void addTrailingComment(Comment comment) {
        this.trailingComments.add(comment);
    }

    @NotAstProperty
    public List<Comment> getOpeningComments() {
        return this.openingComments;
    }

    public void setOpeningComments(List<Comment> openingComments) {
        this.openingComments = openingComments;
    }

    public void addOpeningComments(List<Comment> openingComments) {
        this.openingComments.addAll(openingComments);
    }

    @NotAstProperty
    public List<Comment> getOrphanComments() {
        return this.orphanComments;
    }

    public void setOrphanComments(List<Comment> orphanComments) {
        this.orphanComments = orphanComments;
    }

    public abstract ASTCssNodeType getType();

    public boolean isFaulty() {
        return false;
    }

    public LessSource getSource() {
        return this.getUnderlyingStructure() == null ? null : this.getUnderlyingStructure().getSource();
    }

    public int getSourceLine() {
        return this.getUnderlyingStructure() == null ? -1 : this.getUnderlyingStructure().getLine();
    }

    public int getSourceColumn() {
        return this.getUnderlyingStructure() == null ? -1 : this.getUnderlyingStructure().getCharPositionInLine() + 1;
    }

    @Override
    public ASTCssNode clone() {
        try {
            ASTCssNode clone = (ASTCssNode)super.clone();
            clone.setOpeningComments(new ArrayList<Comment>(this.getOpeningComments()));
            clone.setOrphanComments(new ArrayList<Comment>(this.getOrphanComments()));
            clone.setTrailingComments(new ArrayList<Comment>(this.getTrailingComments()));
            clone.setParent(null);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("This is a bug - please submit issue with this stack trace and an input.");
        }
    }

    public void configureParentToAllChilds() {
        List<? extends ASTCssNode> childs = this.getChilds();
        for (ASTCssNode aSTCssNode : childs) {
            aSTCssNode.setParent(this);
        }
    }
}

