/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.InScopeSnapshotRunner;
import com.github.sommeri.less4j.core.compiler.scopes.ScopeFactory;
import com.github.sommeri.less4j.core.compiler.scopes.view.ScopeView;
import com.github.sommeri.less4j.core.compiler.stages.ArgumentsBuilder;
import com.github.sommeri.less4j.core.compiler.stages.AstNodesStack;
import com.github.sommeri.less4j.core.compiler.stages.MixinCompilationResult;
import com.github.sommeri.less4j.core.compiler.stages.ReferencesSolver;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.List;

class MixinsSolver {
    private final ProblemsHandler problemsHandler;
    private final ReferencesSolver parentSolver;
    private final AstNodesStack semiCompiledNodes;

    public MixinsSolver(ReferencesSolver parentSolver, AstNodesStack semiCompiledNodes, ProblemsHandler problemsHandler) {
        this.parentSolver = parentSolver;
        this.semiCompiledNodes = semiCompiledNodes;
        this.problemsHandler = problemsHandler;
    }

    private MixinCompilationResult resolveMixinReference(final IScope callerScope, FullMixinDefinition referencedMixin, IScope mixinWorkingScope, final ExpressionEvaluator expressionEvaluator) {
        final ReusableStructure mixin = referencedMixin.getMixin();
        final IScope referencedMixinScope = mixinWorkingScope;
        return InScopeSnapshotRunner.runInLocalDataSnapshot(referencedMixinScope, new InScopeSnapshotRunner.IFunction<MixinCompilationResult>(){

            @Override
            public MixinCompilationResult run() {
                List replacement = MixinsSolver.this.compileReferencedMixin(mixin, referencedMixinScope);
                IScope returnValues = expressionEvaluator.evaluateValues(referencedMixinScope);
                List<FullMixinDefinition> unmodifiedMixinsToImport = referencedMixinScope.getAllMixins();
                List allMixinsToImport = MixinsSolver.this.mixinsToImport(callerScope, referencedMixinScope, unmodifiedMixinsToImport);
                returnValues.addAllMixins(allMixinsToImport);
                return new MixinCompilationResult(replacement, returnValues, unmodifiedMixinsToImport);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ASTCssNode> compileReferencedMixin(ReusableStructure referencedMixin, IScope referencedMixinScopeSnapshot) {
        this.semiCompiledNodes.push(referencedMixin);
        try {
            GeneralBody bodyClone = referencedMixin.getBody().clone();
            this.parentSolver.unsafeDoSolveReferences((ASTCssNode)bodyClone, referencedMixinScopeSnapshot);
            List<ASTCssNode> list = bodyClone.getMembers();
            return list;
        }
        finally {
            this.semiCompiledNodes.pop();
        }
    }

    private List<FullMixinDefinition> mixinsToImport(IScope referenceScope, IScope referencedMixinScope, List<FullMixinDefinition> unmodifiedMixinsToImport) {
        ArrayList<FullMixinDefinition> result = new ArrayList<FullMixinDefinition>();
        for (FullMixinDefinition mixinToImport : unmodifiedMixinsToImport) {
            ScopeView newWay;
            boolean isLocalImport = mixinToImport.getScope().seesLocalDataOf(referenceScope);
            if (isLocalImport) {
                newWay = ScopeFactory.createJoinedScopesView(null, mixinToImport.getScope());
                newWay.saveLocalDataForTheWholeWayUp();
                result.add(new FullMixinDefinition(mixinToImport.getMixin(), newWay));
                continue;
            }
            newWay = ScopeFactory.createJoinedScopesView(referencedMixinScope, mixinToImport.getScope());
            newWay.saveLocalDataForTheWholeWayUp();
            result.add(new FullMixinDefinition(mixinToImport.getMixin(), newWay));
        }
        return result;
    }

    private void shiftComments(MixinReference reference, GeneralBody result) {
        List<ASTCssNode> childs = result.getMembers();
        if (!childs.isEmpty()) {
            childs.get(0).addOpeningComments(reference.getOpeningComments());
            childs.get(childs.size() - 1).addTrailingComments(reference.getTrailingComments());
        }
    }

    private IScope buildMixinsArguments(MixinReference reference, IScope referenceScope, FullMixinDefinition mixin) {
        ArgumentsBuilder builder = new ArgumentsBuilder(reference, mixin.getMixin(), new ExpressionEvaluator(referenceScope, this.problemsHandler), this.problemsHandler);
        return builder.build();
    }

    public GeneralBody buildMixinReferenceReplacement(final MixinReference reference, final IScope callerScope, List<FullMixinDefinition> mixins) {
        final GeneralBody result = new GeneralBody(reference.getUnderlyingStructure());
        for (final FullMixinDefinition fullMixin : mixins) {
            final ReusableStructure mixin = fullMixin.getMixin();
            final IScope mixinScope = fullMixin.getScope();
            InScopeSnapshotRunner.runInLocalDataSnapshot(mixinScope.getParent(), new InScopeSnapshotRunner.ITask(){

                @Override
                public void run() {
                    IScope mixinArguments = MixinsSolver.this.buildMixinsArguments(reference, callerScope, fullMixin);
                    IScope mixinWorkingScope = MixinsSolver.calculateMixinsWorkingScope(callerScope, mixinArguments, mixinScope);
                    ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator(mixinWorkingScope, MixinsSolver.this.problemsHandler);
                    if (expressionEvaluator.guardsSatisfied(mixin)) {
                        MixinCompilationResult compiled = MixinsSolver.this.resolveMixinReference(callerScope, fullMixin, mixinWorkingScope, expressionEvaluator);
                        result.addMembers(compiled.getReplacement());
                        callerScope.addToPlaceholder(compiled.getReturnValues());
                    }
                }
            });
        }
        callerScope.closePlaceholder();
        this.resolveImportance(reference, result);
        this.shiftComments(reference, result);
        return result;
    }

    private void resolveImportance(MixinReference reference, GeneralBody result) {
        if (reference.isImportant()) {
            this.declarationsAreImportant(result);
        }
    }

    private void declarationsAreImportant(Body result) {
        for (ASTCssNode kid : result.getMembers()) {
            if (kid instanceof Declaration) {
                Declaration declaration = (Declaration)kid;
                declaration.setImportant(true);
                continue;
            }
            if (!(kid instanceof BodyOwner)) continue;
            BodyOwner owner = (BodyOwner)((Object)kid);
            this.declarationsAreImportant((Body)owner.getBody());
        }
    }

    private static IScope calculateMixinsWorkingScope(IScope callerScope, IScope arguments, IScope mixinScope) {
        IScope mixinDeclarationScope = mixinScope.getParent();
        mixinDeclarationScope.add(arguments);
        boolean isLocallyDefined = mixinDeclarationScope.seesLocalDataOf(callerScope);
        if (isLocallyDefined) {
            return mixinScope;
        }
        ScopeView result = ScopeFactory.createJoinedScopesView(callerScope, mixinScope);
        return result;
    }
}

