/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractColorFunction;
import com.github.sommeri.less4j.core.compiler.expressions.CssNameClashMultiParameterFunction;
import com.github.sommeri.less4j.core.compiler.expressions.HSLAValue;
import com.github.sommeri.less4j.core.compiler.expressions.UnknownFunction;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

class Saturate
extends CssNameClashMultiParameterFunction {
    Saturate() {
    }

    @Override
    public Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, FunctionExpression call, Expression evaluatedParameter) {
        Expression firstParam = splitParameters.get(0);
        if (firstParam.getType() != ASTCssNodeType.COLOR_EXPRESSION) {
            UnknownFunction unknownFunction = new UnknownFunction();
            return unknownFunction.evaluate(splitParameters, problemsHandler, call, evaluatedParameter);
        }
        ColorExpression color = (ColorExpression)firstParam;
        NumberExpression amount = (NumberExpression)splitParameters.get(1);
        HSLAValue hsla = AbstractColorFunction.toHSLA(color);
        this.apply(amount, hsla);
        return AbstractColorFunction.hsla(hsla, call.getUnderlyingStructure());
    }

    protected void apply(NumberExpression amount, HSLAValue hsla) {
        hsla.s += amount.getValueAsDouble() / 100.0;
        hsla.s = AbstractColorFunction.clamp(hsla.s);
    }

    @Override
    protected int getMinParameters() {
        return 2;
    }

    @Override
    protected int getMaxParameters() {
        return 2;
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        switch (position) {
            case 0: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.COLOR_EXPRESSION);
            }
            case 1: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.NUMBER);
            }
        }
        return false;
    }

    @Override
    protected String getName() {
        return "saturate";
    }
}

