/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes;

import com.github.sommeri.less4j.core.compiler.scopes.Scope;
import java.util.ArrayList;
import java.util.Iterator;

public class IteratedScope {
    private final Scope scope;
    private Iterator<Scope> childsIterator;

    public IteratedScope(Scope scope) {
        this.scope = scope;
        this.childsIterator = new ArrayList<Scope>(scope.getChilds()).iterator();
    }

    public Scope getScope() {
        return this.scope;
    }

    public IteratedScope getNextChild() {
        Scope child = null;
        do {
            if (!this.childsIterator.hasNext()) continue;
            child = this.childsIterator.next();
        } while (!child.isPresentInTree());
        return new IteratedScope(child);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IteratedScope [scope=");
        builder.append(this.scope);
        builder.append("]");
        return builder.toString();
    }
}

