/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.commandline;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.platform.Constants;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;

public class CommandLinePrint {
    private static final String URI_FILE_SEPARATOR = "/";
    private PrintStream standardOut;
    private PrintStream standardErr;

    public CommandLinePrint() {
        this(System.out, System.err);
    }

    public CommandLinePrint(PrintStream standardOut, PrintStream standardErr) {
        this.standardOut = standardOut;
        this.standardErr = standardErr;
    }

    public void printToSysout(LessCompiler.CompilationResult content, String inputfileName, File rootInputFile) {
        if (content == null || content.getCss() == null) {
            this.reportCouldNotCompileTheFile(inputfileName);
            return;
        }
        this.standardOut.print(content.getCss());
        this.printWarnings(inputfileName, rootInputFile, content);
    }

    void reportCouldNotCompileTheFile(String inputfile) {
        this.reportError("Could not compile the file " + inputfile);
    }

    public void printToFile(LessCompiler.CompilationResult content, String outputFile, String inputfileName, File rootInputFile) {
        if (content == null || content.getCss() == null) {
            this.reportCouldNotCompileTheFile(inputfileName);
            return;
        }
        this.outputFile(outputFile, content.getCss());
        this.printWarnings(inputfileName, rootInputFile, content);
    }

    public void printWarnings(String inputfileName, File rootInputFile, LessCompiler.CompilationResult content) {
        if (!content.getWarnings().isEmpty()) {
            this.standardErr.println("Warnings produced by compilation of " + inputfileName);
        }
        for (LessCompiler.Problem warning : content.getWarnings()) {
            this.standardErr.println(this.toWarning(warning, rootInputFile));
        }
    }

    private String toWarning(LessCompiler.Problem warning, File rootInputFile) {
        return "WARNING " + this.toString(warning, rootInputFile);
    }

    private String toError(LessCompiler.Problem warning, File rootInputFile) {
        return "ERROR " + this.toString(warning, rootInputFile);
    }

    private String toString(LessCompiler.Problem problem, File rootInputFile) {
        String lineChar;
        String filename = this.toFilenameReport(rootInputFile, problem.getFile());
        if (!filename.isEmpty()) {
            filename = filename + " ";
        }
        if (!(lineChar = this.toLineCharReport(problem)).isEmpty()) {
            lineChar = lineChar + " ";
        }
        return filename + lineChar + problem.getMessage();
    }

    private String toLineCharReport(LessCompiler.Problem problem) {
        if (problem.getLine() == -1 || problem.getCharacter() == -1) {
            return "";
        }
        return problem.getLine() + ":" + problem.getCharacter();
    }

    private String toFilenameReport(File rootInputFile, File file) {
        String rootInputFileAbsoluteName;
        if (file == null) {
            return "";
        }
        if (rootInputFile == null) {
            return file.getPath();
        }
        String fileAbsoluteName = file.getAbsoluteFile().getAbsolutePath();
        if (fileAbsoluteName.equals(rootInputFileAbsoluteName = rootInputFile.getAbsoluteFile().getAbsolutePath())) {
            return "";
        }
        return this.relativize(rootInputFile.getAbsoluteFile().getParent(), fileAbsoluteName);
    }

    private String relativize(String base, String path) {
        String relative = new File(base).toURI().relativize(new File(path).toURI()).getPath();
        relative = relative.replace(URI_FILE_SEPARATOR, Constants.FILE_SEPARATOR);
        return relative;
    }

    private void outputFile(String filename, String content) {
        File file = new File(filename);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            this.reportError("Could not create the file " + filename);
            this.reportError(e);
            return;
        }
        if (!file.canWrite()) {
            this.reportError("Can not write into file " + filename);
            return;
        }
        try {
            FileWriter output = new FileWriter(file);
            IOUtils.write((String)content, (Writer)output);
            output.close();
        }
        catch (IOException e) {
            this.reportError("Can not write into file " + filename);
            this.reportError(e);
            return;
        }
    }

    protected void reportError(String message) {
        this.standardErr.println(message);
    }

    public void reportErrorsAndWarnings(Less4jException ex, String inputfileName, File rootInputFile) {
        this.printWarnings(inputfileName, rootInputFile, ex.getPartialResult());
        this.reportErrors(ex, inputfileName, rootInputFile);
    }

    public void reportErrors(Less4jException ex, String inputfileName, File rootInputFile) {
        if (!ex.getErrors().isEmpty()) {
            this.standardErr.println("Errors produced by compilation of " + inputfileName);
        }
        HashSet<String> previousMessages = new HashSet<String>();
        for (LessCompiler.Problem error : ex.getErrors()) {
            String message = this.toError(error, rootInputFile);
            if (previousMessages.contains(message)) continue;
            this.standardErr.println(message);
            previousMessages.add(message);
        }
    }

    protected void reportError(Throwable e) {
        e.printStackTrace(this.standardErr);
    }
}

