/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.problems;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ArgumentDeclaration;
import com.github.sommeri.less4j.core.ast.ComparisonExpressionOperator;
import com.github.sommeri.less4j.core.ast.EscapedSelector;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.NestedSelectorAppender;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.PseudoClass;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.SignedExpression;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.problems.CompilationError;
import com.github.sommeri.less4j.core.problems.CompilationWarning;
import com.github.sommeri.less4j.core.problems.ProblemsCollector;
import com.github.sommeri.less4j.utils.LessPrinter;
import com.github.sommeri.less4j.utils.PrintUtils;
import java.util.List;

public class ProblemsHandler {
    private ProblemsCollector collector = new ProblemsCollector();
    private LessPrinter printer = new LessPrinter();

    public void nestedAppenderOnTopLevel(NestedSelectorAppender appender) {
        this.collector.addError(new CompilationError(appender, "Appender symbol is not allowed inside top level rulesets."));
    }

    public void interpolatedMixinReferenceSelector(MixinReference reference) {
        this.collector.addError(new CompilationError(reference.getFinalName(), "Interpolation is not allowed inside mixin references."));
    }

    public void extendedNamespaceReferenceSelector(MixinReference reference) {
        this.collector.addError(new CompilationError(reference, "Structures with extended names can not be used as namespaces."));
    }

    public void interpolatedNamespaceReferenceSelector(MixinReference reference) {
        this.collector.addError(new CompilationError(reference, "Interpolation is not allowed inside namespace references."));
    }

    public void wrongMemberBroughtIntoBody(ASTCssNode reference, ASTCssNode member, ASTCssNode parent) {
        this.collector.addError(new CompilationError(reference, "The reference brought " + PrintUtils.toTypeName(member) + " from " + PrintUtils.toLocation(member) + " into " + PrintUtils.toTypeName(parent) + " which started at " + PrintUtils.toLocation(parent) + ". Compilation produced an incorrect CSS."));
    }

    public void unsupportedKeyframesMember(ASTCssNode errorNode) {
        this.collector.addError(new CompilationError(errorNode, "This element is not allowed to be @keyframes member."));
    }

    public void errFormatWrongFirstParameter(Expression param) {
        this.collector.addError(new CompilationError(param, "First argument of format function must be either string or escaped value."));
    }

    public void variablesCycle(List<Variable> cycle) {
        this.collector.addError(new CompilationError(cycle.get(0), "Cyclic references among variables: " + this.printer.toVariablesString(cycle)));
    }

    public void mixinsCycle(List<MixinReference> cycle) {
        this.collector.addError(new CompilationError(cycle.get(0), "Cyclic references among mixins: " + this.printer.toMixinReferencesString(cycle)));
    }

    public void deprecatedSyntaxEscapedSelector(EscapedSelector errorNode) {
        this.collector.addWarning(new CompilationWarning(errorNode, "Selector fragment (~" + errorNode.getQuoteType() + errorNode.getValue() + errorNode.getQuoteType() + ") uses deprecated (~\"escaped-selector\") syntax. Use selector interpolation @{variableName} instead."));
    }

    public void warnEscapeFunctionArgument(Expression errorNode) {
        this.collector.addWarning(new CompilationWarning(errorNode, "Escape function argument should be a string."));
    }

    public void warnEFunctionArgument(Expression errorNode) {
        this.collector.addError(new CompilationError(errorNode, "e function argument should be a string."));
    }

    public void variableAsPseudoclassParameter(PseudoClass errorNode) {
        this.collector.addWarning(new CompilationWarning(errorNode.getParameter(), "Variables as pseudo classes parameters have been deprecated. Use selector interpolation @{variableName} instead."));
    }

    public void undefinedMixinParameterValue(ReusableStructure mixin, ArgumentDeclaration declaration, MixinReference reference) {
        this.collector.addError(this.createUndefinedMixinParameterValue(mixin, declaration, reference));
    }

    private CompilationError createUndefinedMixinParameterValue(ReusableStructure mixin, ArgumentDeclaration declaration, MixinReference reference) {
        return new CompilationError(reference, "Undefined parameter " + declaration.getVariable().getName() + " of mixin " + reference.getFinalNameAsString() + " defined on line " + mixin.getSourceLine());
    }

    public void undefinedVariable(Variable variable) {
        this.collector.addError(this.createUndefinedVariable(variable.getName(), variable));
    }

    public void undefinedVariable(String name, ASTCssNode ifErrorNode) {
        this.collector.addError(this.createUndefinedVariable(name, ifErrorNode));
    }

    private CompilationError createUndefinedVariable(Variable variable) {
        return this.createUndefinedVariable(variable.getName(), variable);
    }

    private CompilationError createUndefinedVariable(String name, ASTCssNode variable) {
        return new CompilationError(variable, "The variable \"" + name + "\" was not declared.");
    }

    public void undefinedMixin(MixinReference reference) {
        this.collector.addError(this.createUndefinedMixin(reference));
    }

    private CompilationError createUndefinedMixin(MixinReference reference) {
        return this.createUndefinedMixin(reference.getFinalName(), reference);
    }

    private CompilationError createUndefinedMixin(ReusableStructureName name, MixinReference reference) {
        return new CompilationError(reference.getFinalName(), "The mixin \"" + name.asString() + "\" was not declared.");
    }

    public void unmatchedMixin(MixinReference reference) {
        this.collector.addError(this.createUnmatchedMixin(reference));
    }

    private CompilationError createUnmatchedMixin(MixinReference reference) {
        return this.createUnmatchedMixin(reference.getFinalName(), reference);
    }

    private CompilationError createUnmatchedMixin(ReusableStructureName name, MixinReference reference) {
        return new CompilationError(reference.getFinalName(), "The mixin \"" + name.asString() + "\" was not matched.");
    }

    public void undefinedNamespace(MixinReference reference) {
        this.collector.addError(this.createUndefinedNamespace(reference));
    }

    private CompilationError createUndefinedNamespace(MixinReference reference) {
        return this.createUndefinedNamespace(this.printer.toString(reference), reference);
    }

    private CompilationError createUndefinedNamespace(String name, MixinReference reference) {
        return new CompilationError(reference, "The namespace \"" + name + "\" was not declared.");
    }

    public void nonStringIndirection(Expression errorNode) {
        this.collector.addError(this.createNonStringIndirection(errorNode));
    }

    private CompilationError createNonStringIndirection(Expression errorNode) {
        return new CompilationError(errorNode, "Variable indirection works only with string values.");
    }

    public void nonNumberNegation(SignedExpression errorNode) {
        this.collector.addError(new CompilationError(errorNode, "Cannot negate non number."));
    }

    public void subtractOrDiveColorFromNumber(Expression errorNode) {
        this.collector.addError(new CompilationError(errorNode, "Can't subtract or divide a color from a number"));
    }

    public void mathFunctionParameterNotANumber(String functionName, Expression errorNode) {
        this.collector.addError(new CompilationError(errorNode, "function '" + functionName + "' requires number as a parameter."));
    }

    public void mathFunctionParameterNotANumberWarn(String functionName, Expression errorNode) {
        this.collector.addWarning(new CompilationWarning(errorNode, "function '" + functionName + "' requires number as a parameter."));
    }

    public void cannotEvaluate(Expression errorNode) {
        this.collector.addError(new CompilationError(errorNode, "Unable to evaluate expression"));
    }

    public void incompatibleComparisonOperand(Expression errorNode, ComparisonExpressionOperator operator) {
        this.collector.addError(new CompilationError(errorNode, "The operator '" + operator + "' can be used only with numbers."));
    }

    public void rulesetWithoutSelector(RuleSet errorNode) {
        this.collector.addWarning(new CompilationWarning(errorNode, "Ruleset without selector encountered."));
    }

    public void divisionByZero(NumberExpression errorNode) {
        this.collector.addWarning(new CompilationWarning(errorNode, "Division by zero."));
    }

    public boolean hasErrors() {
        return this.collector.hasErrors();
    }

    public boolean hasWarnings() {
        return this.collector.hasWarnings();
    }

    public List<LessCompiler.Problem> getWarnings() {
        return this.collector.getWarnings();
    }

    public List<LessCompiler.Problem> getErrors() {
        return this.collector.getErrors();
    }
}

