/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.compiler.expressions.Ceil;
import com.github.sommeri.less4j.core.compiler.expressions.Floor;
import com.github.sommeri.less4j.core.compiler.expressions.Function;
import com.github.sommeri.less4j.core.compiler.expressions.FunctionsPackage;
import com.github.sommeri.less4j.core.compiler.expressions.Percentage;
import com.github.sommeri.less4j.core.compiler.expressions.Round;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.HashMap;
import java.util.Map;

public class MathFunctions
implements FunctionsPackage {
    protected static final String PERCENTAGE = "percentage";
    protected static final String ROUND = "round";
    protected static final String FLOOR = "floor";
    protected static final String CEIL = "ceil";
    private static Map<String, Function> FUNCTIONS = new HashMap<String, Function>();
    private final ProblemsHandler problemsHandler;

    public MathFunctions(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    @Override
    public boolean canEvaluate(FunctionExpression input, Expression parameters) {
        return FUNCTIONS.containsKey(input.getName());
    }

    @Override
    public Expression evaluate(FunctionExpression input, Expression parameters) {
        if (!this.canEvaluate(input, parameters)) {
            return input;
        }
        Function function = FUNCTIONS.get(input.getName());
        return function.evaluate(parameters, this.problemsHandler);
    }

    static {
        FUNCTIONS.put(PERCENTAGE, new Percentage());
        FUNCTIONS.put(FLOOR, new Floor());
        FUNCTIONS.put(CEIL, new Ceil());
        FUNCTIONS.put(ROUND, new Round());
    }
}

