/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.InterpolableName;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class SimpleSelector
extends SelectorPart
implements Cloneable {
    private InterpolableName elementName;
    private boolean isStar;
    private boolean isEmptyForm = false;
    private List<ElementSubsequent> subsequent = new ArrayList<ElementSubsequent>();

    public SimpleSelector(HiddenTokenAwareTree token, InterpolableName elementName, boolean isStar) {
        super(token);
        this.elementName = elementName;
        this.isStar = isStar;
    }

    @Override
    public boolean isClassesAndIdsOnlySelector() {
        return this.isLimitedPurposeSelector(ASTCssNodeType.CSS_CLASS, ASTCssNodeType.ID_SELECTOR);
    }

    private boolean isLimitedPurposeSelector(ASTCssNodeType ... purposes) {
        if (this.elementName != null || !this.isEmptyForm() || this.subsequent == null) {
            return false;
        }
        HashSet<ASTCssNodeType> purposesSet = new HashSet<ASTCssNodeType>(Arrays.asList(purposes));
        for (ElementSubsequent es : this.subsequent) {
            if (!purposesSet.contains((Object)es.getType())) {
                return false;
            }
            if (!es.isInterpolated()) continue;
            return false;
        }
        return true;
    }

    public InterpolableName getElementName() {
        return this.elementName;
    }

    public boolean isStar() {
        return this.isStar;
    }

    public boolean isEmptyForm() {
        return this.isEmptyForm;
    }

    public void setEmptyForm(boolean isEmptyForm) {
        this.isEmptyForm = isEmptyForm;
    }

    public void setElementName(InterpolableName elementName) {
        this.elementName = elementName;
    }

    public void setStar(boolean isStar) {
        this.isStar = isStar;
    }

    public boolean hasElement() {
        return null != this.getElementName();
    }

    public List<ElementSubsequent> getSubsequent() {
        return this.subsequent;
    }

    public boolean hasSubsequent() {
        return !this.subsequent.isEmpty();
    }

    public void addSubsequent(ElementSubsequent subsequent) {
        this.subsequent.add(subsequent);
    }

    public void addSubsequent(List<ElementSubsequent> subsequent) {
        this.subsequent.addAll(subsequent);
    }

    public List<ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.elementName);
        result.addAll(this.subsequent);
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.SIMPLE_SELECTOR;
    }

    @Override
    public SimpleSelector clone() {
        SimpleSelector clone = (SimpleSelector)super.clone();
        clone.subsequent = ArraysUtils.deeplyClonedList(this.getSubsequent());
        clone.elementName = this.elementName == null ? null : this.elementName.clone();
        clone.configureParentToAllChilds();
        return clone;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.isStar ? "*" : this.getElementName());
        builder.append(this.subsequent);
        return builder.toString();
    }

    public ElementSubsequent getLastSubsequent() {
        if (this.subsequent.isEmpty()) {
            return null;
        }
        return this.subsequent.get(this.subsequent.size() - 1);
    }

    public void extendName(String extension) {
        if (this.isStar) {
            this.isStar = false;
        }
        this.getElementName().extendName(extension);
    }
}

