/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.NestedSelectorAppender;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.problems.BugHappened;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class NestedRulesCollector {
    private final ASTManipulator manipulator = new ASTManipulator();
    private Stack<List<Selector>> selectors;
    private LinkedList<RuleSet> rulesets;

    public List<RuleSet> collectNestedRuleSets(RuleSet kid) {
        this.selectors = new Stack();
        this.rulesets = new LinkedList();
        this.pushSelectors(kid);
        this.collectChildRuleSets(kid);
        this.popSelectors();
        return this.rulesets;
    }

    private void collectChildRuleSets(ASTCssNode node) {
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode aSTCssNode : childs) {
            if (aSTCssNode.getType() == ASTCssNodeType.RULE_SET) {
                RuleSet nestedSet = (RuleSet)aSTCssNode;
                this.manipulator.removeFromBody(nestedSet);
                this.collect(nestedSet);
                this.pushSelectors(nestedSet);
            }
            this.collectChildRuleSets(aSTCssNode);
            if (aSTCssNode.getType() != ASTCssNodeType.RULE_SET) continue;
            this.popSelectors();
        }
    }

    private void collect(RuleSet nestedSet) {
        this.combine(nestedSet, this.selectors.peek());
        this.rulesets.add(nestedSet);
    }

    public void combine(RuleSet ruleSet, List<Selector> previousSelectors) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector selector : ruleSet.getSelectors()) {
            result.addAll(this.combine(selector, previousSelectors));
        }
        ruleSet.replaceSelectors(result);
        ruleSet.configureParentToAllChilds();
    }

    private Collection<Selector> combine(Selector selector, List<Selector> previousSelectors) {
        if (!selector.containsAppender()) {
            return this.indirectJoinAll(null, previousSelectors, selector);
        }
        List<Selector> result = Arrays.asList(selector);
        while (result.get(0).containsAppender()) {
            ArrayList<Selector> nextRound = new ArrayList<Selector>();
            for (Selector tbch : result) {
                nextRound.addAll(this.replaceFirstAppender(tbch, previousSelectors));
            }
            result = nextRound;
        }
        return result;
    }

    private List<Selector> indirectJoinAll(SelectorCombinator appenderCombinator, List<Selector> first, Selector second) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector previous : first) {
            result.add(this.indirectJoin(appenderCombinator, previous, second));
        }
        return result;
    }

    private List<Selector> directJoinAll(List<Selector> firsts, Selector second) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector first : firsts) {
            result.add(this.directJoin(first, second));
        }
        return result;
    }

    private List<Selector> indirectJoinAll(SelectorCombinator leadingCombinator, Selector first, List<Selector> seconds) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector second : seconds) {
            result.add(this.indirectJoin(leadingCombinator, first, second));
        }
        return result;
    }

    private List<Selector> directJoinAll(Selector first, List<Selector> seconds) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector second : seconds) {
            result.add(this.directJoin(first, second));
        }
        return result;
    }

    private Collection<Selector> replaceFirstAppender(Selector selector, List<Selector> previousSelectors) {
        if (selector.getHead().isAppender()) {
            NestedSelectorAppender appender = (NestedSelectorAppender)selector.getHead();
            return this.joinAll(previousSelectors, this.chopOffHead(selector), selector.getLeadingCombinator(), appender.isDirectlyBefore());
        }
        NestedSelectorAppender appender = selector.findFirstAppender();
        if (appender == null) {
            throw new BugHappened("This is very weird error and should not happen.", (ASTCssNode)selector);
        }
        Selector rightSelectorBeginning = appender.getParentAsSelector();
        Selector leftSelectorBeginning = this.splitOn(rightSelectorBeginning);
        List<Selector> partialResults = this.joinAll(leftSelectorBeginning, previousSelectors, rightSelectorBeginning.getLeadingCombinator(), appender.isDirectlyAfter());
        return this.joinAll(partialResults, this.chopOffHead(rightSelectorBeginning), null, appender.isDirectlyBefore());
    }

    private List<Selector> joinAll(Selector first, List<Selector> seconds, SelectorCombinator leadingCombinator, boolean appenderDirectlyPlaced) {
        boolean directJoin = this.isDirect(leadingCombinator, appenderDirectlyPlaced);
        if (directJoin) {
            return this.directJoinAll(first, seconds);
        }
        return this.indirectJoinAll(leadingCombinator, first, seconds);
    }

    private List<Selector> joinAll(List<Selector> firsts, Selector second, SelectorCombinator leadingCombinator, boolean appenderDirectlyPlaced) {
        boolean directJoin = this.isDirect(leadingCombinator, appenderDirectlyPlaced);
        if (directJoin) {
            return this.directJoinAll(firsts, second);
        }
        return this.indirectJoinAll(leadingCombinator, firsts, second);
    }

    private boolean isDirect(SelectorCombinator leadingCombinator, boolean appenderDirectlyPlaced) {
        return leadingCombinator == null && appenderDirectlyPlaced;
    }

    private Selector splitOn(Selector rightSelectorStart) {
        Selector leftSelectorEnding = (Selector)rightSelectorStart.getParent();
        leftSelectorEnding.setRight(null);
        rightSelectorStart.setParent(null);
        Selector leftSelectorBeginning = leftSelectorEnding;
        while (leftSelectorBeginning.getParent() instanceof Selector) {
            leftSelectorBeginning = (Selector)leftSelectorBeginning.getParent();
        }
        return leftSelectorBeginning;
    }

    private Selector chopOffHead(Selector selector) {
        if (!selector.hasRight()) {
            return null;
        }
        Selector right = selector.getRight();
        right.setParent(null);
        selector.setRight(null);
        return right;
    }

    private Selector directJoin(Selector firstI, Selector secondI) {
        if (secondI == null) {
            return firstI.clone();
        }
        if (firstI == null) {
            return secondI.clone();
        }
        Selector first = firstI.clone();
        Selector second = secondI.clone();
        if (second.getHead().isAppender()) {
            return this.indirectJoinNoClone(second.getLeadingCombinator(), first, second);
        }
        Selector attachTo = first.getRightestPart();
        SimpleSelector attachToHead = (SimpleSelector)attachTo.getHead();
        SimpleSelector secondHead = (SimpleSelector)second.getHead();
        if (!secondHead.hasElement()) {
            attachToHead.addSubsequent(secondHead.getSubsequent());
        } else {
            String secondName;
            String string = secondName = secondHead.hasElement() ? secondHead.getElementName().getName() : "";
            if (attachToHead.hasSubsequent()) {
                ElementSubsequent subsequent = attachToHead.getLastSubsequent();
                subsequent.extendName(secondName);
            } else {
                attachToHead.extendName(secondName);
            }
            attachToHead.addSubsequent(secondHead.getSubsequent());
        }
        attachToHead.configureParentToAllChilds();
        if (second.hasRight()) {
            this.indirectJoinNoClone(second.getLeadingCombinator(), attachTo, second.getRight());
        }
        return first;
    }

    private Selector indirectJoin(SelectorCombinator appenderCombinator, Selector firstI, Selector secondI) {
        if (secondI == null) {
            return firstI.clone();
        }
        if (firstI == null) {
            return secondI.clone();
        }
        Selector first = firstI.clone();
        Selector second = secondI.clone();
        this.indirectJoinNoClone(appenderCombinator, first, second);
        return first;
    }

    private Selector indirectJoinNoClone(SelectorCombinator appenderCombinator, Selector first, Selector second) {
        Selector attachTo = first.getRightestPart();
        attachTo.setRight(second);
        second.setParent(attachTo);
        if (appenderCombinator != null) {
            second.setLeadingCombinator(appenderCombinator);
        }
        return first;
    }

    private void pushSelectors(RuleSet kid) {
        this.selectors.push(new ArrayList<Selector>(kid.getSelectors()));
    }

    private void popSelectors() {
        this.selectors.pop();
    }
}

