/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.problems.BugHappened;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;

public class ASTManipulator {
    public void replace(ASTCssNode oldChild, ASTCssNode newChild) {
        PropertyDescriptor[] propertyDescriptors;
        if (oldChild == newChild) {
            return;
        }
        ASTCssNode parent = oldChild.getParent();
        for (PropertyDescriptor descriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(parent.getClass())) {
            Object value;
            Class<?> propertyType = descriptor.getPropertyType();
            if (propertyType == null || !propertyType.isInstance(newChild) || (value = this.getPropertyValue(parent, descriptor)) != oldChild) continue;
            this.setPropertyValue(newChild, parent, "parent");
            this.setPropertyValue(oldChild, null, "parent");
            this.setPropertyValue(parent, newChild, descriptor);
            return;
        }
    }

    public void removeFromBody(ASTCssNode node) {
        ASTCssNode parent = node.getParent();
        if (!(parent instanceof Body)) {
            throw new BugHappened("Parent is not a body instance. " + parent, parent);
        }
        Body pBody = (Body)parent;
        pBody.removeMember(node);
        node.setParent(null);
    }

    public void replaceInBody(ASTCssNode oldNode, List<ASTCssNode> newNodes) {
        ASTCssNode parent = oldNode.getParent();
        if (!(parent instanceof Body)) {
            throw new BugHappened("Parent is not a body instance. " + parent, parent);
        }
        Body pBody = (Body)parent;
        pBody.replaceMember(oldNode, newNodes);
        oldNode.setParent(null);
        for (ASTCssNode kid : newNodes) {
            kid.setParent(pBody);
        }
    }

    private void setPropertyValue(ASTCssNode parent, ASTCssNode value, String name) {
        try {
            PropertyUtils.setProperty((Object)parent, (String)name, (Object)value);
        }
        catch (IllegalAccessException e) {
            throw new BugHappened(e, value);
        }
        catch (InvocationTargetException e) {
            throw new BugHappened(e, value);
        }
        catch (NoSuchMethodException e) {
            throw new BugHappened(e, value);
        }
    }

    private void setPropertyValue(ASTCssNode parent, ASTCssNode value, PropertyDescriptor descriptor) {
        try {
            PropertyUtils.setProperty((Object)parent, (String)descriptor.getName(), (Object)value);
        }
        catch (IllegalAccessException e) {
            throw new BugHappened(e, value);
        }
        catch (InvocationTargetException e) {
            throw new BugHappened(e, value);
        }
        catch (NoSuchMethodException e) {
            throw new BugHappened(e, value);
        }
    }

    public Object getPropertyValue(ASTCssNode object, PropertyDescriptor descriptor) {
        try {
            Object result = PropertyUtils.getProperty((Object)object, (String)descriptor.getName());
            return result;
        }
        catch (IllegalAccessException e) {
            throw new BugHappened(e, object);
        }
        catch (InvocationTargetException e) {
            throw new BugHappened(e, object);
        }
        catch (NoSuchMethodException e) {
            throw new BugHappened(e, object);
        }
    }
}

