/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class SignedExpression
extends Expression {
    private Expression expression;
    private Sign sign;

    public SignedExpression(HiddenTokenAwareTree token, Sign sign, Expression expression) {
        super(token);
        this.expression = expression;
        this.sign = sign;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.expression);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Sign getSign() {
        return this.sign;
    }

    public void setSign(Sign sign) {
        this.sign = sign;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.SIGNED_EXPRESSION;
    }

    public String toString() {
        return "-" + this.expression;
    }

    @Override
    public SignedExpression clone() {
        SignedExpression result = (SignedExpression)super.clone();
        result.expression = this.expression == null ? null : this.expression.clone();
        result.configureParentToAllChilds();
        return result;
    }

    public static enum Sign {
        PLUS("+"),
        MINUS("-");

        private final String symbol;

        private Sign(String symbol) {
            this.symbol = symbol;
        }

        public String toSymbol() {
            return this.symbol;
        }
    }
}

