/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.utils;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import java.util.HashSet;
import java.util.Set;

public class DebugUtils {
    private Set<ASTCssNode> duplicates = new HashSet<ASTCssNode>();

    public void solveParentChildRelationShips(ASTCssNode node) {
        for (ASTCssNode aSTCssNode : node.getChilds()) {
            aSTCssNode.setParent(node);
            this.solveParentChildRelationShips(aSTCssNode);
        }
    }

    public void checkParentChildRelationshipsSanity(ASTCssNode node, String prefix) {
        this.duplicates = new HashSet<ASTCssNode>();
        this.doCheckParentChildRelationshipsSanity(node, prefix);
    }

    private void doCheckParentChildRelationshipsSanity(ASTCssNode node, String prefix) {
        for (ASTCssNode aSTCssNode : node.getChilds()) {
            if (this.duplicates.contains(aSTCssNode)) {
                System.out.println("duplicate " + prefix + aSTCssNode);
            }
            this.duplicates.add(aSTCssNode);
            if (aSTCssNode.getParent() != node) {
                System.out.println("parent " + prefix + aSTCssNode);
            }
            this.doCheckParentChildRelationshipsSanity(aSTCssNode, prefix);
        }
    }
}

