/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.stages.SelectorsManipulator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class NestedRulesCollector {
    private final ASTManipulator manipulator = new ASTManipulator();
    private final SelectorsManipulator selectorsManipulator = new SelectorsManipulator();
    private Stack<List<Selector>> selectors;
    private LinkedList<RuleSet> rulesets;

    public List<RuleSet> collectNestedRuleSets(RuleSet kid) {
        this.selectors = new Stack();
        this.rulesets = new LinkedList();
        this.pushSelectors(kid);
        this.collectChildRuleSets(kid);
        this.popSelectors();
        return this.rulesets;
    }

    private void collectChildRuleSets(ASTCssNode node) {
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode aSTCssNode : childs) {
            if (aSTCssNode.getType() == ASTCssNodeType.RULE_SET) {
                RuleSet nestedSet = (RuleSet)aSTCssNode;
                this.manipulator.removeFromBody(nestedSet);
                this.collect(nestedSet);
                this.pushSelectors(nestedSet);
            }
            this.collectChildRuleSets(aSTCssNode);
            if (aSTCssNode.getType() != ASTCssNodeType.RULE_SET) continue;
            this.popSelectors();
        }
    }

    private void collect(RuleSet nestedSet) {
        this.combine(nestedSet, this.selectors.peek());
        this.rulesets.add(nestedSet);
    }

    private void combine(RuleSet ruleSet, List<Selector> previousSelectors) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector selector : ruleSet.getSelectors()) {
            result.addAll(this.selectorsManipulator.replaceAppenders(selector, previousSelectors));
        }
        ruleSet.replaceSelectors(result);
        ruleSet.configureParentToAllChilds();
    }

    private void popSelectors() {
        this.selectors.pop();
    }

    private void pushSelectors(RuleSet kid) {
        this.selectors.push(new ArrayList<Selector>(kid.getSelectors()));
    }
}

