/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.compiler.expressions.E;
import com.github.sommeri.less4j.core.compiler.expressions.Escape;
import com.github.sommeri.less4j.core.compiler.expressions.Format;
import com.github.sommeri.less4j.core.compiler.expressions.Function;
import com.github.sommeri.less4j.core.compiler.expressions.FunctionsPackage;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StringFunctions
implements FunctionsPackage {
    protected static final String ESCAPE = "escape";
    protected static final String E = "e";
    protected static final String FORMAT = "%";
    private static Map<String, Function> FUNCTIONS = new HashMap<String, Function>();
    private final ProblemsHandler problemsHandler;

    public StringFunctions(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    @Override
    public boolean canEvaluate(FunctionExpression input, List<Expression> parameters) {
        return FUNCTIONS.containsKey(input.getName());
    }

    @Override
    public Expression evaluate(FunctionExpression input, List<Expression> parameters, Expression evaluatedParameter) {
        if (!this.canEvaluate(input, parameters)) {
            return input;
        }
        Function function = FUNCTIONS.get(input.getName());
        return function.evaluate(parameters, this.problemsHandler, input, evaluatedParameter);
    }

    static {
        FUNCTIONS.put(ESCAPE, new Escape());
        FUNCTIONS.put(E, new E());
        FUNCTIONS.put(FORMAT, new Format());
    }
}

