/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.NestedSelectorAppender;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class Selector
extends ASTCssNode
implements Cloneable {
    private SelectorCombinator leadingCombinator;
    private SelectorPart head;
    private Selector right;

    public Selector(HiddenTokenAwareTree token) {
        super(token);
    }

    public Selector(HiddenTokenAwareTree token, SelectorCombinator leadingCombinator, SelectorPart head) {
        this(token, leadingCombinator, head, null);
    }

    public Selector(HiddenTokenAwareTree token, SelectorCombinator leadingCombinator, SelectorPart head, Selector right) {
        super(token);
        this.leadingCombinator = leadingCombinator;
        this.head = head;
        this.right = right;
    }

    public boolean hasLeadingCombinator() {
        return this.leadingCombinator != null;
    }

    public SelectorCombinator getLeadingCombinator() {
        return this.leadingCombinator;
    }

    public void setLeadingCombinator(SelectorCombinator leadingCombinator) {
        this.leadingCombinator = leadingCombinator;
    }

    public SelectorPart getHead() {
        return this.head;
    }

    public Selector getRight() {
        return this.right;
    }

    public void setHead(SelectorPart head) {
        this.head = head;
    }

    public void setRight(Selector right) {
        this.right = right;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.leadingCombinator, this.head, this.right);
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.SELECTOR;
    }

    @Override
    public Selector clone() {
        Selector clone = (Selector)super.clone();
        clone.setLeadingCombinator(this.getLeadingCombinator() == null ? null : this.getLeadingCombinator().clone());
        clone.setHead(this.getHead().clone());
        clone.setRight(!this.hasRight() ? null : this.getRight().clone());
        clone.configureParentToAllChilds();
        return clone;
    }

    public Selector getRightestPart() {
        if (!this.hasRight()) {
            return this;
        }
        return this.getRight().getRightestPart();
    }

    public boolean hasRight() {
        return this.getRight() != null;
    }

    public boolean isCombined() {
        return this.getRight() != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Selector [");
        builder.append(this.leadingCombinator);
        builder.append(this.head);
        builder.append(" ");
        builder.append(this.right);
        builder.append("]");
        return builder.toString();
    }

    public NestedSelectorAppender findFirstAppender() {
        if (this.getHead().isAppender()) {
            return (NestedSelectorAppender)this.getHead();
        }
        if (!this.hasRight()) {
            return null;
        }
        return this.getRight().findFirstAppender();
    }

    public boolean containsAppender() {
        return this.findFirstAppender() != null;
    }

    public boolean isReusableSelector() {
        if (this.isCombined()) {
            if (!this.getHead().isAppender()) {
                return false;
            }
            return this.getRight().hasReusableHead() && !this.getRight().isCombined();
        }
        return this.hasReusableHead();
    }

    private boolean hasReusableHead() {
        return this.getHead().isClassesAndIdsOnlySelector();
    }

    public SimpleSelector asReusableSelector() {
        if (!this.isCombined()) {
            return (SimpleSelector)this.getHead();
        }
        return (SimpleSelector)this.getRight().getHead();
    }
}

