/*
 * Decompiled with CFR 0.152.
 */
package com.github.approval.utils;

import java.util.Locale;

public abstract class CrossPlatformCommand<T> {
    private static String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);

    static void setOS(String newOs) {
        os = newOs.toLowerCase(Locale.ENGLISH);
    }

    protected abstract T onWindows();

    protected abstract T onUnix();

    protected T onMac() {
        return this.onUnix();
    }

    protected T onSolaris() {
        return this.onUnix();
    }

    public T execute() {
        if (CrossPlatformCommand.isWindows()) {
            return this.onWindows();
        }
        if (CrossPlatformCommand.isMac()) {
            return this.onMac();
        }
        if (CrossPlatformCommand.isUnix()) {
            return this.onUnix();
        }
        if (CrossPlatformCommand.isSolaris()) {
            return this.onSolaris();
        }
        throw new IllegalStateException("Invalid operating system " + os);
    }

    public static boolean isWindows() {
        return os.contains("win");
    }

    public static boolean isMac() {
        return os.contains("mac");
    }

    public static boolean isUnix() {
        return os.contains("nix") || os.contains("nux") || os.contains("aix");
    }

    public static boolean isSolaris() {
        return os.contains("sunos") || os.contains("sun os");
    }
}

