/*
 * Decompiled with CFR 0.152.
 */
package com.github.approval.reporters;

import com.github.approval.Reporter;
import com.github.approval.reporters.ExecutableDifferenceReporter;
import com.github.approval.reporters.SwingInteractiveReporter;
import com.github.approval.utils.CrossPlatformCommand;
import java.io.File;

public final class WindowsReporters {
    private static final Reporter NOTEPAD_PLUS_PLUS = SwingInteractiveReporter.wrap(new WindowsExecutableReporter("cmd /C notepad++", "cmd /C notepad++", "notepad++"){

        @Override
        protected String[] buildApproveNewCommand(File approvalDestination, File fileForVerification) {
            return new String[]{this.getApprovalCommand(), approvalDestination.getAbsolutePath()};
        }
    });
    private static final ExecutableDifferenceReporter BEYOND_COMPARE = new WindowsExecutableReporter("cmd /C BCompare", "cmd /C BCompare", "BCompare");
    private static final ExecutableDifferenceReporter TORTOISE_IMAGE_DIFF = new WindowsExecutableReporter("cmd /C TortoiseIDiff", "cmd /C TortoiseIDiff", "TortoiseIDiff");
    private static final ExecutableDifferenceReporter TORTOISE_TEXT_DIFF = new WindowsExecutableReporter("cmd /C TortoiseMerge", "cmd /C TortoiseMerge", "TortoiseMerge");
    private static final ExecutableDifferenceReporter WIN_MERGE = new WindowsExecutableReporter("cmd /C WinMergeU", "cmd /C WinMergeU", "WinMergeU");

    private WindowsReporters() {
    }

    public static Reporter notepadPlusPlus() {
        return NOTEPAD_PLUS_PLUS;
    }

    public static Reporter beyondCompare() {
        return BEYOND_COMPARE;
    }

    public static Reporter tortoiseImage() {
        return TORTOISE_IMAGE_DIFF;
    }

    public static Reporter tortoiseText() {
        return TORTOISE_TEXT_DIFF;
    }

    public static Reporter winMerge() {
        return WIN_MERGE;
    }

    public static class WindowsExecutableReporter
    extends ExecutableDifferenceReporter {
        public WindowsExecutableReporter(String approvalCommand, String diffCommand, String executable) {
            super(approvalCommand, diffCommand, executable);
        }

        @Override
        public boolean canApprove(File fileForApproval) {
            return super.canApprove(fileForApproval) && CrossPlatformCommand.isWindows();
        }
    }
}

