/*
 * Decompiled with CFR 0.152.
 */
package com.github.approval.pathmappers;

import com.github.approval.FullPathMapper;
import com.github.approval.PathMapper;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class JunitPathMapper
implements TestRule,
PathMapper,
FullPathMapper {
    private final Path parentPath;
    private Path currentTestPath;

    public JunitPathMapper(Path parentPath) {
        this.parentPath = parentPath;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                JunitPathMapper.this.currentTestPath = JunitPathMapper.this.parentPath.resolve(description.getClassName().replace(".", File.separator)).resolve(description.getMethodName());
                try {
                    base.evaluate();
                }
                finally {
                    JunitPathMapper.this.currentTestPath = null;
                }
            }
        };
    }

    Path getCurrentTestPath() {
        return this.currentTestPath;
    }

    @Nonnull
    public Path getApprovalPath(Object value) {
        return Paths.get(this.currentTestPath + ".approved", new String[0]);
    }

    @Nonnull
    public Path getPath(@Nullable Object value, Path approvalFilePath) {
        return this.currentTestPath.resolve(approvalFilePath);
    }
}

