/*
 * Decompiled with CFR 0.152.
 */
package com.github.approval.converters;

import com.github.approval.converters.AbstractStringConverter;
import com.github.approval.converters.Converter;
import java.lang.reflect.Array;
import javax.annotation.Nonnull;

public final class Converters {
    public static final Converter<Byte> BYTE = Converters.of();
    public static final Converter<String> STRING = Converters.of();
    public static final Converter<Integer> INTEGER = Converters.of();
    public static final Converter<Short> SHORT = Converters.of();
    public static final Converter<Long> LONG = Converters.of();
    public static final Converter<Float> FLOAT = Converters.of();
    public static final Converter<Boolean> BOOLEAN = Converters.of();
    public static final Converter<Double> DOUBLE = Converters.of();
    public static final Converter<Character> CHAR = Converters.of();
    public static final Converter<int[]> INTEGER_ARRAY = Converters.ofArray();
    public static final Converter<byte[]> BYTE_ARRAY = Converters.ofArray();
    public static final Converter<long[]> LONG_ARRAY = Converters.ofArray();
    public static final Converter<short[]> SHORT_ARRAY = Converters.ofArray();
    public static final Converter<double[]> DOUBLE_ARRAY = Converters.ofArray();
    public static final Converter<boolean[]> BOOLEAN_ARRAY = Converters.ofArray();
    public static final Converter<char[]> CHAR_ARRAY = Converters.ofArray();
    public static final Converter<float[]> FLOAT_ARRAY = Converters.ofArray();
    public static final Converter<String[]> STRING_ARRAY = Converters.ofArray();

    private Converters() {
    }

    static <T> Converter<T> ofArray() {
        return new AbstractStringConverter<T>(){

            @Override
            @Nonnull
            protected String getStringForm(Object value) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    builder.append("[").append(i).append("] = ").append(String.valueOf(Array.get(value, i))).append("\n");
                }
                return builder.toString();
            }
        };
    }

    static <T> Converter<T> of() {
        return new AbstractStringConverter<T>(){

            @Override
            @Nonnull
            protected String getStringForm(T value) {
                return value.toString();
            }
        };
    }
}

