/*
 * Decompiled with CFR 0.152.
 */
package com.github.miachm.sods;

import com.github.miachm.sods.Cell;
import com.github.miachm.sods.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Sheet
implements Cloneable,
Comparable<Sheet> {
    private List<List<Cell>> cells = new ArrayList<List<Cell>>();
    private String name;
    private int numColumns = 1;
    private Map<Integer, Double> columnWidth = new TreeMap<Integer, Double>();
    private Map<Integer, Double> rowHeight = new TreeMap<Integer, Double>();

    public Sheet(String name) {
        this.name = name;
        this.cells.add(new ArrayList());
        Cell cell = new Cell();
        cell.setValue("");
        this.cells.get(0).add(cell);
    }

    public void appendRow() {
        this.appendRows(1);
    }

    public void appendRows(int howmany) {
        this.insertRowsAfter(this.getMaxRows() - 1, howmany);
    }

    public void appendColumn() {
        this.appendColumns(1);
    }

    public void appendColumns(int howmany) {
        this.insertColumnsAfter(this.getMaxColumns() - 1, howmany);
    }

    public void clear() {
        this.getDataRange().clear();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void deleteColumn(int column) {
        this.deleteColumns(column, 1);
    }

    public void deleteColumns(int column, int howmany) {
        if (column + howmany > this.getMaxColumns()) {
            throw new IndexOutOfBoundsException("Column " + column + " plus " + howmany + " is out of bounds (" + this.getMaxColumns() + ")");
        }
        for (List<Cell> row : this.cells) {
            for (int i = 0; i < howmany; ++i) {
                row.remove(column);
            }
        }
        this.numColumns -= howmany;
    }

    public void deleteRow(int row) {
        this.deleteRows(row, 1);
    }

    public void deleteRows(int row, int howmany) {
        if (row > this.getMaxRows()) {
            throw new IndexOutOfBoundsException("Row " + row + " is out of bounds (" + this.getMaxRows() + ")");
        }
        for (int i = 0; i < howmany; ++i) {
            this.cells.remove(row);
        }
    }

    public Double getColumnWidth(int column) {
        return this.columnWidth.get(column);
    }

    public Double getRowHeight(int row) {
        return this.rowHeight.get(row);
    }

    public Range getDataRange() {
        return this.getRange(0, 0, this.getMaxRows(), this.getMaxColumns());
    }

    public int getMaxColumns() {
        return this.cells.isEmpty() ? this.numColumns : this.cells.get(0).size();
    }

    public int getMaxRows() {
        return this.cells.size();
    }

    public String getName() {
        return this.name;
    }

    public Range getRange(int row, int column) {
        return this.getRange(row, column, 1, 1);
    }

    public Range getRange(int row, int column, int numRows) {
        return this.getRange(row, column, numRows, 1);
    }

    public Range getRange(int row, int column, int numRows, int numColumns) {
        return new Range(this, row, column, numRows, numColumns);
    }

    Cell getCell(int row, int column) {
        return this.cells.get(row).get(column);
    }

    public void insertColumnAfter(int afterPosition) {
        this.insertColumnsAfter(afterPosition, 1);
    }

    public void insertColumnBefore(int beforePosition) {
        this.insertColumnsBefore(beforePosition, 1);
    }

    public void insertColumnsAfter(int columnIndex, int howmany) {
        this.insertColumnsBefore(columnIndex + 1, howmany);
    }

    public void insertColumnsBefore(int columnIndex, int howmany) {
        if (columnIndex - 1 > this.getMaxColumns()) {
            throw new IndexOutOfBoundsException("Column " + columnIndex + " is out of bounds (" + this.getMaxColumns() + ")");
        }
        for (List<Cell> row : this.cells) {
            for (int i = 0; i < howmany; ++i) {
                row.add(columnIndex, new Cell());
            }
        }
        this.numColumns += howmany;
    }

    public void insertRowAfter(int afterPosition) {
        this.insertRowsAfter(afterPosition, 1);
    }

    public void insertRowBefore(int beforePosition) {
        this.insertRowsBefore(beforePosition, 1);
    }

    public void insertRowsBefore(int rowIndex, int howmany) {
        if (rowIndex - 1 > this.getMaxRows()) {
            throw new IndexOutOfBoundsException("Row " + rowIndex + " is out of bounds (" + this.getMaxRows() + ")");
        }
        for (int i = 0; i < howmany; ++i) {
            ArrayList<Cell> row = new ArrayList<Cell>();
            for (int j = 0; j < this.numColumns; ++j) {
                row.add(new Cell());
            }
            this.cells.add(rowIndex, row);
        }
    }

    public void insertRowsAfter(int rowIndex, int howmany) {
        this.insertRowsBefore(rowIndex + 1, howmany);
    }

    public void setColumnWidth(int column, Double width) {
        if (column < 0 || column >= this.numColumns) {
            throw new IndexOutOfBoundsException("Error, index out of bounds");
        }
        if (width != null) {
            if (width < 0.0) {
                throw new IllegalArgumentException("Width can't be negative!");
            }
            this.columnWidth.put(column, width);
        } else {
            this.columnWidth.remove(column);
        }
    }

    public void setColumnWidths(int column, int numColumns, Double width) {
        for (int i = 0; i < numColumns; ++i) {
            this.setColumnWidth(column + i, width);
        }
    }

    public void setRowHeight(int row, Double height) {
        if (row < 0 || row >= this.getMaxRows()) {
            throw new IndexOutOfBoundsException("Error, index out of bounds (" + row + ")");
        }
        if (height != null) {
            if (height < 0.0) {
                throw new IllegalArgumentException("Height can't be negative!");
            }
            this.rowHeight.put(row, height);
        } else {
            this.rowHeight.remove(row);
        }
    }

    public void setRowHeights(int row, int numRows, Double height) {
        for (int i = 0; i < numRows; ++i) {
            this.setRowHeight(row + i, height);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sheet sheet = (Sheet)o;
        if (!this.cells.equals(sheet.cells)) {
            return false;
        }
        if (!this.name.equals(sheet.name)) {
            return false;
        }
        if (!this.columnWidth.equals(sheet.columnWidth)) {
            return false;
        }
        return this.rowHeight.equals(sheet.rowHeight);
    }

    public int hashCode() {
        int result = this.cells.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.columnWidth.hashCode();
        result = 31 * result + this.rowHeight.hashCode();
        return result;
    }

    @Override
    public int compareTo(Sheet o) {
        return this.name.compareTo(o.getName());
    }

    public String toString() {
        return "Sheet{\ncells=" + this.getDataRange().toString() + ",\nname='" + this.name + '\'' + ",\ncolumnWidth=" + this.columnWidth + '}';
    }
}

