package com.github.markzhai.uiframework.navigator;

import android.app.Activity;
import android.support.v4.app.Fragment;

import com.github.markzhai.uiframework.navigator.backstack.AbstractFragment;

import java.util.Map;

/**
 * 导航选项类，包含界面类，及启动界面的默认桉树
 *
 * @author alimusic.wireless
 * @version 0.0.1
 */
public class NavigatorOptions {
    /**
     * Activity类
     */
    private Class<? extends Activity> mActivityClazz;
    /**
     * Fragment类
     */
    private Class<? extends AbstractFragment> mFragmentClazz;
    /**
     * 启动界面的默认参数
     */
    private Map<String, String> mDefaultParams;

    private FragmentLauncher mFragmentLauncher;
    private ActivityLauncher mActivityLauncher;

    /**
     * 设置activity界面类
     *
     * @param clazz activity类
     */
    public void setOpenActivityClass(Class<? extends Activity> clazz) {
        this.mActivityClazz = clazz;
    }

    /**
     * 设置Fragment界面类
     *
     * @param clazz fragment类
     */
    public void setOpenFragmentClass(Class<? extends AbstractFragment> clazz) {
        this.mFragmentClazz = clazz;
    }

    /**
     * 获取Activity界面类
     *
     * @return activity类
     */
    public Class<? extends Activity> getOpenActivityClass() {
        return this.mActivityClazz;
    }

    /**
     * 获取Fragment界面类
     *
     * @return fragment类
     */
    public Class<? extends Fragment> getOpenFragmentClass() {
        return this.mFragmentClazz;
    }

    /**
     * 设置默认界面启动参数
     *
     * @param defaultParams map参数
     */
    public void setDefaultParams(Map<String, String> defaultParams) {
        this.mDefaultParams = defaultParams;
    }

    /**
     * 获取默认界面启动参数
     *
     * @return map参数
     */
    public Map<String, String> getDefaultParams() {
        return this.mDefaultParams;
    }


    public FragmentLauncher getFragmentLauncher() {
        return mFragmentLauncher;
    }

    public void setFragmentLauncher(FragmentLauncher fragmentLauncher) {
        this.mFragmentLauncher = fragmentLauncher;
    }

    public ActivityLauncher getActivityLauncher() {
        return mActivityLauncher;
    }

    public void setActivityLauncher(ActivityLauncher activityLauncher) {
        this.mActivityLauncher = activityLauncher;
    }

}
