package com.github.markzhai.uiframework.common;

import android.database.AbstractCursor;
import android.os.Bundle;

public class BundleCursor extends AbstractCursor {

    private final Bundle mExtras;

    public BundleCursor() {
        this(null);
    }

    public BundleCursor(Bundle bundle) {
        mExtras = bundle != null ? new Bundle(bundle) : new Bundle();
    }

    @Override
    public Bundle getExtras() {
        return mExtras;
    }

    // ---------- empty methods ----------
    @Override
    public int getCount() {
        return 0;
    }

    @Override
    public String[] getColumnNames() {
        return new String[0];
    }

    @Override
    public String getString(int column) {
        return null;
    }

    @Override
    public short getShort(int column) {
        return 0;
    }

    @Override
    public int getInt(int column) {
        return 0;
    }

    @Override
    public long getLong(int column) {
        return 0;
    }

    @Override
    public float getFloat(int column) {
        return 0;
    }

    @Override
    public double getDouble(int column) {
        return 0;
    }

    @Override
    public boolean isNull(int column) {
        return false;
    }
}
