package com.github.markzhai.uiframework.callback;

import android.app.Activity;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.View;

/**
 * Fragment生命周期
 * <p/>
 * Created by zhaiyifan on 2015/7/31.
 */
public interface IFragmentLifecycleCallback {
    void registerFragmentLifecycleCallbacks(FragmentLifecycleCallbacks callback);

    void unregisterFragmentLifecycleCallbacks(FragmentLifecycleCallbacks callback);

    void registerFragmentViewCallbacks(FragmentViewCallbacks callback);

    void unregisterFragmentViewCallbacks(FragmentViewCallbacks callback);

    // fragment lifecycle
    interface FragmentLifecycleCallbacks {
        void onFragmentAttached(Fragment fragment, Activity activity);

        void onFragmentCreated(Fragment fragment, Bundle savedInstanceState);

        void onFragmentStarted(Fragment fragment);

        void onFragmentResumed(Fragment fragment);

        void onFragmentPaused(Fragment fragment);

        void onFragmentStopped(Fragment fragment);

        void onFragmentSaveInstanceState(Fragment fragment, Bundle outState);

        void onFragmentDestroyed(Fragment fragment);

        void onFragmentDetached(Fragment fragment);
    }

    interface FragmentViewCallbacks {
        void onFragmentViewCreated(Fragment fragment, View view, Bundle savedInstanceState);
    }
}
