/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.PatternExpr;
import com.github.javaparser.ast.expr.TypePatternExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.GenericVisitorWithDefaults;
import com.github.javaparser.symbolsolver.javaparsermodel.PatternVariableResult;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedList;

public class PatternVariableVisitor
extends GenericVisitorWithDefaults<PatternVariableResult, Void> {
    public PatternVariableResult defaultAction(Node node, Void unused) {
        return new PatternVariableResult();
    }

    public PatternVariableResult visit(BinaryExpr expression, Void unused) {
        if (expression.getOperator().equals((Object)BinaryExpr.Operator.AND)) {
            return PatternVariableVisitor.getVariablesIntroducedByAnd(expression);
        }
        if (expression.getOperator().equals((Object)BinaryExpr.Operator.OR)) {
            return PatternVariableVisitor.getVariablesIntroducedByOr(expression);
        }
        return new PatternVariableResult();
    }

    private static PatternVariableResult getVariablesIntroducedByAnd(BinaryExpr expression) {
        PatternVariableVisitor variableVisitor = new PatternVariableVisitor();
        PatternVariableResult introducedByLeft = (PatternVariableResult)expression.getLeft().accept((GenericVisitor)variableVisitor, null);
        PatternVariableResult introducedByRight = (PatternVariableResult)expression.getRight().accept((GenericVisitor)variableVisitor, null);
        introducedByLeft.addVariablesIntroducedIfTrue(introducedByRight.getVariablesIntroducedIfTrue());
        introducedByLeft.clearVariablesIntroducedIfFalse();
        return introducedByLeft;
    }

    private static PatternVariableResult getVariablesIntroducedByOr(BinaryExpr expression) {
        PatternVariableVisitor variableVisitor = new PatternVariableVisitor();
        PatternVariableResult introducedByLeft = (PatternVariableResult)expression.getLeft().accept((GenericVisitor)variableVisitor, null);
        PatternVariableResult introducedByRight = (PatternVariableResult)expression.getRight().accept((GenericVisitor)variableVisitor, null);
        introducedByLeft.addVariablesIntroducedIfFalse(introducedByRight.getVariablesIntroducedIfFalse());
        introducedByLeft.clearVariablesIntroducedIfTrue();
        return introducedByLeft;
    }

    public PatternVariableResult visit(UnaryExpr expr, Void unused) {
        if (expr.getOperator().equals((Object)UnaryExpr.Operator.LOGICAL_COMPLEMENT)) {
            return PatternVariableVisitor.getVariablesIntroducedByLogicalComplement(expr);
        }
        return new PatternVariableResult();
    }

    private static PatternVariableResult getVariablesIntroducedByLogicalComplement(UnaryExpr unaryExpr) {
        PatternVariableVisitor variableVisitor = new PatternVariableVisitor();
        PatternVariableResult introducedByChild = (PatternVariableResult)unaryExpr.getExpression().accept((GenericVisitor)variableVisitor, null);
        introducedByChild.swapTrueAndFalse();
        return introducedByChild;
    }

    public PatternVariableResult visit(InstanceOfExpr instanceOfExpr, Void unused) {
        LinkedList<TypePatternExpr> variablesIntroducedIfTrue = new LinkedList<TypePatternExpr>();
        LinkedList<TypePatternExpr> variablesIntroducedIfFalse = new LinkedList<TypePatternExpr>();
        instanceOfExpr.getPattern().ifPresent(patternExpr -> {
            ArrayDeque<PatternExpr> patternQueue = new ArrayDeque<PatternExpr>();
            patternQueue.add((PatternExpr)patternExpr);
            while (!patternQueue.isEmpty()) {
                PatternExpr toCheck = (PatternExpr)patternQueue.remove();
                if (toCheck.isTypePatternExpr()) {
                    variablesIntroducedIfTrue.add(toCheck.asTypePatternExpr());
                    continue;
                }
                if (toCheck.isRecordPatternExpr()) {
                    patternQueue.addAll((Collection<PatternExpr>)toCheck.asRecordPatternExpr().getPatternList());
                    continue;
                }
                throw new IllegalStateException("Found illegal pattern type in InstanceOf" + toCheck.getClass().getCanonicalName());
            }
        });
        return new PatternVariableResult(variablesIntroducedIfTrue, variablesIntroducedIfFalse);
    }

    public PatternVariableResult visit(EnclosedExpr enclosedExpr, Void unused) {
        return (PatternVariableResult)enclosedExpr.getInner().accept((GenericVisitor)this, (Object)unused);
    }
}

