/*
 * Decompiled with CFR 0.152.
 */
package smile.json;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ReusableBuilder;
import scala.math.Ordered;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import smile.json.JsArray;
import smile.json.JsArray$;
import smile.json.JsCounter;
import smile.json.JsDouble;
import smile.json.JsDouble$;
import smile.json.JsInt;
import smile.json.JsInt$;
import smile.json.JsLong;
import smile.json.JsNull$;
import smile.json.JsObject;
import smile.json.JsObject$;
import smile.json.JsObjectId$;
import smile.json.JsString;
import smile.json.JsString$;
import smile.json.JsUUID$;
import smile.json.JsValue;
import smile.json.JsonParser$;
import smile.json.ParserInput;
import smile.json.package$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0005\u0005Uw!\u0002\u001b6\u0011\u0003Qd!\u0002\u001f6\u0011\u0003i\u0004\"\u0002#\u0002\t\u0003)\u0005\"\u0002$\u0002\t\u00039e\u0001\u0002)\u0002\u0001EC\u0001B\u0018\u0003\u0003\u0006\u0004%\ta\u0018\u0005\tQ\u0012\u0011\t\u0011)A\u0005A\"A\u0011\u000e\u0002BC\u0002\u0013\u0005q\f\u0003\u0005k\t\t\u0005\t\u0015!\u0003a\u0011\u0015!E\u0001\"\u0001l\u000f\u001d\u0001\u0018!!A\t\u0002E4q\u0001U\u0001\u0002\u0002#\u0005!\u000fC\u0003E\u0017\u0011\u00051\u0010C\u0004}\u0017E\u0005I\u0011A?\t\u0013\u0005E1\"!A\u0005\n\u0005Ma!\u0002\u001f6\u0001\u0005\u0005\u0002\u0002\u0003'\u0010\u0005\u0003\u0005\u000b\u0011B'\t\r\u0011{A\u0011AA\u0012\u0011!\tIc\u0004Q\u0001\n\u0005-\u0002\u0002CA\u0019\u001f\u0001\u0006K!a\r\t\u0015\u0005er\u00021A\u0001B\u0003&\u0001\nC\u0004\u0002<=!\t!!\u0010\t\u0013\u0005}rB1A\u0005\u000e\u0005\u0005\u0003\u0002CA$\u001f\u0001\u0006i!a\u0011\t\u000f\u0005%s\u0002\"\u0003\u0002L!9\u00111K\b\u0005\n\u0005U\u0003bBA/\u001f\u0011%\u0011Q\u000b\u0005\b\u0003?zA\u0011BA+\u0011\u001d\t\tg\u0004C\u0005\u0003GBq!!\u001b\u0010\t\u0013\tY\u0005C\u0004\u0002l=!I!a\u0013\t\u000f\u00055t\u0002\"\u0003\u0002L!9\u0011qN\b\u0005\n\u0005-\u0003bBA9\u001f\u0011%\u0011Q\u000b\u0005\b\u0003gzA\u0011BA+\u0011\u001d\t)h\u0004C\u0005\u0003+Bq!a\u001e\u0010\t\u0013\t)\u0006C\u0004\u0002z=!I!a\u0013\t\u000f\u0005mt\u0002\"\u0003\u0002L!9\u0011qQ\b\u0005\n\u0005U\u0003bBAE\u001f\u0011%\u00111\n\u0005\b\u0003\u0017{A\u0011BA+\u0011\u001d\tii\u0004C\u0005\u0003+Bq!a$\u0010\t\u0013\tY\u0005C\u0004\u0002\u0014>!I!!&\t\u000f\u0005=u\u0002\"\u0003\u0002\u001c\"9\u0011qT\b\u0005\n\u0005U\u0003bBAQ\u001f\u0011%\u00111\u0015\u0005\b\u0003O{A\u0011BAU\u0011\u001d\tik\u0004C\u0005\u0003_C\u0011\"!3\u0010#\u0003%I!a3\t\u0013\u0005=w\"%A\u0005\n\u0005E\u0017A\u0003&t_:\u0004\u0016M]:fe*\u0011agN\u0001\u0005UN|gNC\u00019\u0003\u0015\u0019X.\u001b7f\u0007\u0001\u0001\"aO\u0001\u000e\u0003U\u0012!BS:p]B\u000b'o]3s'\t\ta\b\u0005\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005I\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\nQ!\u00199qYf$\"\u0001S&\u0011\u0005mJ\u0015B\u0001&6\u0005\u001dQ5OV1mk\u0016DQ\u0001T\u0002A\u00025\u000bQ!\u001b8qkR\u0004\"a\u000f(\n\u0005=+$a\u0003)beN,'/\u00138qkR\u0014\u0001\u0003U1sg&tw-\u0012=dKB$\u0018n\u001c8\u0014\u0005\u0011\u0011\u0006CA*\\\u001d\t!\u0016L\u0004\u0002V16\taK\u0003\u0002Xs\u00051AH]8pizJ\u0011!Q\u0005\u00035\u0002\u000bq\u0001]1dW\u0006<W-\u0003\u0002];\n\u0001\"+\u001e8uS6,W\t_2faRLwN\u001c\u0006\u00035\u0002\u000bqa];n[\u0006\u0014\u00180F\u0001a!\t\tWM\u0004\u0002cGB\u0011Q\u000bQ\u0005\u0003I\u0002\u000ba\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011A\rQ\u0001\tgVlW.\u0019:zA\u00051A-\u001a;bS2\fq\u0001Z3uC&d\u0007\u0005F\u0002m]>\u0004\"!\u001c\u0003\u000e\u0003\u0005AQAX\u0005A\u0002\u0001Dq![\u0005\u0011\u0002\u0003\u0007\u0001-\u0001\tQCJ\u001c\u0018N\\4Fq\u000e,\u0007\u000f^5p]B\u0011QnC\n\u0004\u0017y\u001a\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003\tIwNC\u0001y\u0003\u0011Q\u0017M^1\n\u0005i,(\u0001D*fe&\fG.\u001b>bE2,G#A9\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005q(F\u00011\u0000W\t\t\t\u0001\u0005\u0003\u0002\u0004\u00055QBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0006\u0001\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0011Q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001D<sSR,'+\u001a9mC\u000e,GCAA\u000b!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000eo\u0006!A.\u00198h\u0013\u0011\ty\"!\u0007\u0003\r=\u0013'.Z2u'\tya\b\u0006\u0003\u0002&\u0005\u001d\u0002CA\u001e\u0010\u0011\u0015a\u0015\u00031\u0001N\u0003\t\u0019(\r\u0005\u0003\u0002\u0018\u00055\u0012\u0002BA\u0018\u00033\u0011Qb\u0015;sS:<')^5mI\u0016\u0014\u0018AC2veN|'o\u00115beB\u0019q(!\u000e\n\u0007\u0005]\u0002I\u0001\u0003DQ\u0006\u0014\u0018a\u00026t-\u0006dW/Z\u0001\ra\u0006\u00148/\u001a&t-\u0006dW/\u001a\u000b\u0002\u0011\u0006\u0019QiT%\u0016\u0005\u0005\rsBAA#9\r\u0001q\u0000\u0000\u0001\u0005\u000b>K\u0005%A\u0003wC2,X\r\u0006\u0002\u0002NA\u0019q(a\u0014\n\u0007\u0005E\u0003I\u0001\u0003V]&$\u0018!\u00024bYN,GCAA,!\ry\u0014\u0011L\u0005\u0004\u00037\u0002%a\u0002\"p_2,\u0017M\\\u0001\u0005]VdG.\u0001\u0003ueV,\u0017a\u00039beN,7\u000b\u001e:j]\u001e$2\u0001SA3\u0011\u0019\t9\u0007\ba\u0001A\u0006\t1/\u0001\u0004pE*,7\r^\u0001\u0006CJ\u0014\u0018-_\u0001\u0007]Vl'-\u001a:\u0002\u0007%tG/\u0001\u0003ge\u0006\u001c\u0017aA3ya\u0006!An\u001c8h\u0003\u001d\u0019w.\u001e8uKJ\fqb\u001c8f\u001fJluN]3ES\u001eLGo]\u0001\u0011u\u0016\u0014xn\u0014:N_J,G)[4jiND3AJA@!\u0011\t\t)a!\u000e\u0005\u0005%\u0011\u0002BAC\u0003\u0013\u0011q\u0001^1jYJ,7-A\u0003E\u0013\u001eKE+\u0001\u0004tiJLgnZ\u0001\u0005G\"\f'/A\u0004fg\u000e\f\u0007/\u001a3\u0002\u0005]\u001c\bfA\u0016\u0002\u0000\u0005\u00111\r\u001b\u000b\u0005\u0003/\n9\nC\u0004\u0002\u001a2\u0002\r!a\r\u0002\u0003\r$B!a\u0016\u0002\u001e\"9\u0011\u0011T\u0017A\u0002\u0005M\u0012aB1em\u0006t7-Z\u0001\tCB\u0004XM\u001c3T\u0005R!\u0011qKAS\u0011\u001d\tIj\fa\u0001\u0003g\tqA]3rk&\u0014X\r\u0006\u0003\u0002N\u0005-\u0006bBAMa\u0001\u0007\u00111G\u0001\u0005M\u0006LG\u000e\u0006\u0005\u00022\u0006]\u00161XAc!\ry\u00141W\u0005\u0004\u0003k\u0003%a\u0002(pi\"Lgn\u001a\u0005\u0007\u0003s\u000b\u0004\u0019\u00011\u0002\rQ\f'oZ3u\u0011%\ti,\rI\u0001\u0002\u0004\ty,\u0001\u0004dkJ\u001cxN\u001d\t\u0004\u007f\u0005\u0005\u0017bAAb\u0001\n\u0019\u0011J\u001c;\t\u0013\u0005\u001d\u0017\u0007%AA\u0002\u0005M\u0012!C3se>\u00148\t[1s\u000391\u0017-\u001b7%I\u00164\u0017-\u001e7uII*\"!!4+\u0007\u0005}v0\u0001\bgC&dG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005M'fAA\u001a\u007f\u0002")
public class JsonParser {
    private final ParserInput input;
    private final StringBuilder sb;
    private char cursorChar;
    private JsValue jsValue;

    public static JsValue apply(ParserInput parserInput) {
        return JsonParser$.MODULE$.apply(parserInput);
    }

    public JsValue parseJsValue() {
        this.ws();
        this.value();
        this.require('\uffff');
        return this.jsValue;
    }

    private final char EOI() {
        return '\uffff';
    }

    private void value() {
        int mark = this.input.cursor();
        char c = this.cursorChar;
        switch (c) {
            case 'f': {
                this.simpleValue$1(this.false(), package$.MODULE$.JsFalse(), mark);
                break;
            }
            case 'n': {
                this.simpleValue$1(this.null(), JsNull$.MODULE$, mark);
                break;
            }
            case 't': {
                this.simpleValue$1(this.true(), package$.MODULE$.JsTrue(), mark);
                break;
            }
            case '{': {
                this.advance();
                this.object();
                break;
            }
            case '[': {
                this.advance();
                this.array();
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.number();
                break;
            }
            case '\"': {
                this.string();
                this.jsValue = this.sb.length() == 0 ? JsString$.MODULE$.empty() : this.parseString(this.sb.toString());
                break;
            }
            default: {
                throw this.fail("JSON Value", this.fail$default$2(), this.fail$default$3());
            }
        }
    }

    private boolean false() {
        return this.advance() && this.ch('a') && this.ch('l') && this.ch('s') && this.ws('e');
    }

    private boolean null() {
        return this.advance() && this.ch('u') && this.ch('l') && this.ws('l');
    }

    private boolean true() {
        return this.advance() && this.ch('r') && this.ch('u') && this.ws('e');
    }

    private JsValue parseString(String s) {
        return s.length() == JsObjectId$.MODULE$.formatLength() && JsObjectId$.MODULE$.regex().pattern().matcher(s).matches() ? JsObjectId$.MODULE$.apply(s.substring(9, 33)) : (s.length() == JsUUID$.MODULE$.formatLength() && JsUUID$.MODULE$.regex().pattern().matcher(s).matches() ? JsUUID$.MODULE$.apply(s) : new JsString(s));
    }

    private void object() {
        JsObject jsObject;
        this.ws();
        if (this.cursorChar != '}') {
            Map map = Predef$.MODULE$.Map().empty();
            map = this.members$1(map);
            this.require('}');
            jsObject = JsObject$.MODULE$.apply((Map<String, JsValue>)map);
        } else {
            this.advance();
            jsObject = JsObject$.MODULE$.apply((Seq<Tuple2<String, JsValue>>)Nil$.MODULE$);
        }
        this.jsValue = jsObject;
        this.ws();
    }

    private void array() {
        JsArray jsArray;
        this.ws();
        if (this.cursorChar != ']') {
            ReusableBuilder list = scala.package$.MODULE$.Vector().newBuilder();
            this.values$1(list);
            this.require(']');
            jsArray = JsArray$.MODULE$.apply((Seq<JsValue>)((Seq)list.result()));
        } else {
            this.advance();
            jsArray = JsArray$.MODULE$.apply((Seq<JsValue>)Nil$.MODULE$);
        }
        this.jsValue = jsArray;
        this.ws();
    }

    private void number() {
        JsValue jsValue;
        int start = this.input.cursor();
        char startChar = this.cursorChar;
        this.ch('-');
        this.int();
        boolean hasFrac = this.frac();
        boolean hasExp = this.exp();
        boolean hasLong = this.long();
        boolean hasCounter = this.counter();
        if (startChar == '0' && this.input.cursor() - start == 1) {
            jsValue = JsInt$.MODULE$.zero();
        } else {
            String s = String.valueOf(this.input.sliceCharArray(start, this.input.cursor()));
            if (hasFrac || hasExp) {
                double n = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s));
                double d = n;
                JsDouble jsDouble = 0.0 == d ? JsDouble$.MODULE$.zero() : (1.0 == d ? JsDouble$.MODULE$.one() : new JsDouble(n));
                jsValue = jsDouble;
            } else {
                jsValue = hasLong ? new JsLong(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s.substring(0, s.length() - 1)))) : (hasCounter ? new JsCounter(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s.substring(0, s.length() - 1)))) : JsonParser.liftedTree1$1(s));
            }
        }
        this.jsValue = jsValue;
        this.ws();
    }

    private void int() {
        block0: {
            if (this.ch('0')) break block0;
            this.oneOrMoreDigits();
        }
    }

    private boolean frac() {
        boolean bl;
        if (this.ch('.')) {
            this.oneOrMoreDigits();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean exp() {
        boolean bl;
        if (this.ch('e') || this.ch('E')) {
            boolean bl2 = this.ch('-') || this.ch('+');
            this.oneOrMoreDigits();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean long() {
        return this.ch('l') || this.ch('L');
    }

    private boolean counter() {
        return this.ch('c') || this.ch('C');
    }

    private void oneOrMoreDigits() {
        if (!this.DIGIT()) {
            throw this.fail("DIGIT", this.fail$default$2(), this.fail$default$3());
        }
        this.zeroOrMoreDigits();
    }

    private void zeroOrMoreDigits() {
        while (this.DIGIT()) {
        }
    }

    private boolean DIGIT() {
        return this.cursorChar >= '0' && this.cursorChar <= '9' && this.advance();
    }

    private void string() {
        if (this.cursorChar != '\"') {
            throw this.fail("'\"'", this.fail$default$2(), this.fail$default$3());
        }
        this.cursorChar = this.input.nextUtf8Char();
        this.sb.setLength(0);
        while (this.char()) {
            this.cursorChar = this.input.nextUtf8Char();
        }
        this.require('\"');
        this.ws();
    }

    private boolean char() {
        boolean bl;
        if ((1L << this.cursorChar & (long)(31 - this.cursorChar >> 31) & 0x7FFFFFFBEFFFFFFFL) != 0L) {
            bl = this.appendSB(this.cursorChar);
        } else {
            char c = this.cursorChar;
            switch (c) {
                case '\"': 
                case '\uffff': {
                    bl = false;
                    break;
                }
                case '\\': {
                    this.advance();
                    bl = this.escaped();
                    break;
                }
                default: {
                    if (c >= ' ' && this.appendSB(c)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    private boolean escaped() {
        boolean bl;
        char c = this.cursorChar;
        switch (c) {
            case '\"': 
            case '/': 
            case '\\': {
                bl = this.appendSB(this.cursorChar);
                break;
            }
            case 'b': {
                bl = this.appendSB('\b');
                break;
            }
            case 'f': {
                bl = this.appendSB('\f');
                break;
            }
            case 'n': {
                bl = this.appendSB('\n');
                break;
            }
            case 'r': {
                bl = this.appendSB('\r');
                break;
            }
            case 't': {
                bl = this.appendSB('\t');
                break;
            }
            case 'u': {
                this.advance();
                bl = this.unicode$1();
                break;
            }
            default: {
                throw this.fail("JSON escape sequence", this.fail$default$2(), this.fail$default$3());
            }
        }
        return bl;
    }

    private void ws() {
        while ((1L << this.cursorChar & (long)(this.cursorChar - 64 >> 31) & 0x100002600L) != 0L) {
            this.advance();
        }
    }

    private boolean ch(char c) {
        boolean bl;
        if (this.cursorChar == c) {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean ws(char c) {
        boolean bl;
        if (this.ch(c)) {
            this.ws();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean advance() {
        this.cursorChar = this.input.nextChar();
        return true;
    }

    private boolean appendSB(char c) {
        this.sb.append(c);
        return true;
    }

    private void require(char c) {
        if (!this.ch(c)) {
            throw this.fail(new StringBuilder(2).append("'").append(c).append("'").toString(), this.fail$default$2(), this.fail$default$3());
        }
    }

    private Nothing$ fail(String target, int cursor, char errorChar) {
        String string;
        ParserInput.Line line = this.input.getLine(cursor);
        if (line == null) {
            throw new MatchError((Object)line);
        }
        int lineNr = line.lineNr();
        int col = line.column();
        String text = line.text();
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)lineNr), (Object)BoxesRunTime.boxToInteger((int)col), (Object)text);
        Tuple3 tuple32 = tuple3;
        int lineNr2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int col2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        String text2 = (String)tuple32._3();
        if (errorChar != '\uffff') {
            String c2 = Character.isISOControl(errorChar) ? StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%04x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errorChar)})) : ((Object)BoxesRunTime.boxToCharacter((char)errorChar)).toString();
            string = new StringBuilder(12).append("character '").append(c2).append("'").toString();
        } else {
            string = "end-of-input";
        }
        String unexpected = string;
        String string2 = target;
        String string3 = "'\uffff'";
        String expected = (string2 == null ? string3 != null : !string2.equals(string3)) ? target : "end-of-input";
        String summary = new StringBuilder(57).append("Unexpected ").append(unexpected).append(" at input index ").append(cursor).append(" (line ").append(lineNr2).append(", position ").append(col2).append("), expected ").append(expected).toString();
        String sanitizedText = StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(text2), (Function1 & Serializable)c -> BoxesRunTime.boxToCharacter((char)JsonParser.$anonfun$fail$1(BoxesRunTime.unboxToChar((Object)c))));
        String detail = new StringBuilder(4).append("\n").append(sanitizedText).append("\n").append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), col2 - 1)).append("^\n").toString();
        throw new ParsingException(summary, detail);
    }

    private int fail$default$2() {
        return this.input.cursor();
    }

    private char fail$default$3() {
        return this.cursorChar;
    }

    private final void simpleValue$1(boolean matched, JsValue value, int mark$1) {
        if (!matched) {
            throw this.fail("JSON Value", mark$1, this.fail$default$3());
        }
        this.jsValue = value;
    }

    private final Map members$1(Map map) {
        Map nextMap;
        while (true) {
            this.string();
            this.require(':');
            this.ws();
            String key = this.sb.toString();
            this.value();
            nextMap = (Map)map.updated((Object)key, (Object)this.jsValue);
            if (!this.ws(',')) break;
            map = nextMap;
        }
        return nextMap;
    }

    private final void values$1(ReusableBuilder list$1) {
        do {
            this.value();
            list$1.$plus$eq((Object)this.jsValue);
        } while (this.ws(','));
    }

    private static final JsValue liftedTree1$1(String s$1) {
        Ordered<JsLong> ordered;
        try {
            int n;
            int n2 = n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s$1));
            switch (n2) {
                case 0: {
                    ordered = JsInt$.MODULE$.zero();
                    break;
                }
                case 1: {
                    ordered = JsInt$.MODULE$.one();
                    break;
                }
                default: {
                    ordered = new JsInt(n);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            ordered = new JsLong(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s$1)));
        }
        return ordered;
    }

    private final int hexValue$1(char c) {
        int n;
        if ('0' <= c && c <= '9') {
            n = c - 48;
        } else if ('a' <= c && c <= 'f') {
            n = c - 87;
        } else if ('A' <= c && c <= 'F') {
            n = c - 55;
        } else {
            throw this.fail("hex digit", this.fail$default$2(), this.fail$default$3());
        }
        return n;
    }

    private final boolean unicode$1() {
        int value = this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        return this.appendSB((char)value);
    }

    public static final /* synthetic */ char $anonfun$fail$1(char c) {
        return Character.isISOControl(c) ? (char)'?' : (char)c;
    }

    public JsonParser(ParserInput input) {
        this.input = input;
        this.sb = new StringBuilder();
        this.cursorChar = input.nextChar();
    }

    public static class ParsingException
    extends RuntimeException {
        private final String summary;
        private final String detail;

        public String summary() {
            return this.summary;
        }

        public String detail() {
            return this.detail;
        }

        public ParsingException(String summary, String detail) {
            this.summary = summary;
            this.detail = detail;
            super(summary.isEmpty() ? detail : (detail.isEmpty() ? summary : new StringBuilder(1).append(summary).append(":").append(detail).toString()));
        }
    }
}

