/*
 * Decompiled with CFR 0.152.
 */
package smile.validation.metric;

import smile.math.MathEx;
import smile.validation.metric.RegressionMetric;

public class R2
implements RegressionMetric {
    private static final long serialVersionUID = 2L;
    public static final R2 instance = new R2();

    @Override
    public double score(double[] truth, double[] prediction) {
        return R2.of(truth, prediction);
    }

    public static double of(double[] truth, double[] prediction) {
        if (truth.length != prediction.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, prediction.length));
        }
        double RSS2 = 0.0;
        double TSS = 0.0;
        double ybar = MathEx.mean((double[])truth);
        int n = truth.length;
        for (int i = 0; i < n; ++i) {
            double r = truth[i] - prediction[i];
            RSS2 += r * r;
            double t = truth[i] - ybar;
            TSS += t * t;
        }
        return 1.0 - RSS2 / TSS;
    }

    public String toString() {
        return "R2";
    }
}

