/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.data.type.StructType;
import smile.math.special.Beta;
import smile.regression.LinearModel;
import smile.tensor.Cholesky;
import smile.tensor.DenseMatrix;
import smile.tensor.QR;
import smile.tensor.Vector;

public class OLS {
    private static final Logger logger = LoggerFactory.getLogger(OLS.class);

    private OLS() {
    }

    public static LinearModel fit(Formula formula, DataFrame data) {
        return OLS.fit(formula, data, new Options());
    }

    public static LinearModel fit(Formula formula, DataFrame data, Options options) {
        int p;
        formula = formula.expand(data.schema());
        StructType schema = formula.bind(data.schema());
        DenseMatrix X = formula.matrix(data);
        double[] y = formula.y(data).toDoubleArray();
        int n = X.nrow();
        if (n <= (p = X.ncol())) {
            throw new IllegalArgumentException(String.format("The input matrix is not over determined: %d rows, %d columns", n, p));
        }
        QR qr = null;
        Vector w = switch (options.method.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                Vector var10_9;
                yield var10_9 = X.copy().svd().solve(y);
            }
            case 0 -> {
                Vector var10_9;
                try {
                    qr = X.copy().qr();
                    yield var10_9 = qr.solve(y);
                }
                catch (RuntimeException e) {
                    logger.warn("Matrix is not of full rank, try SVD instead");
                    yield var10_9 = X.copy().svd().solve(y);
                }
            }
        };
        LinearModel model = new LinearModel(formula, schema, X, y, w, 0.0);
        if (options.stderr || options.recursive) {
            DenseMatrix inv;
            Cholesky cholesky = qr == null ? X.ata().cholesky() : qr.toCholesky();
            model.V = inv = cholesky.inverse();
            if (options.stderr) {
                double[][] ttest = new double[p][4];
                model.ttest = ttest;
                for (int i = 0; i < p; ++i) {
                    double t;
                    double se;
                    ttest[i][0] = w.get(i);
                    ttest[i][1] = se = model.error * Math.sqrt(inv.get(i, i));
                    ttest[i][2] = t = w.get(i) / se;
                    ttest[i][3] = Beta.regularizedIncompleteBetaFunction((double)(0.5 * (double)model.df), (double)0.5, (double)((double)model.df / ((double)model.df + t * t)));
                }
            }
        }
        return model;
    }

    public record Options(Method method, boolean stderr, boolean recursive) {
        public Options() {
            this(Method.QR, true, true);
        }

        public Properties toProperties() {
            Properties props = new Properties();
            props.setProperty("smile.ols.method", this.method.toString());
            props.setProperty("smile.ols.standard_error", Boolean.toString(this.stderr));
            props.setProperty("smile.ols.recursive", Boolean.toString(this.recursive));
            return props;
        }

        public static Options of(Properties props) {
            Method method = Method.valueOf(props.getProperty("smile.ols.method", "QR"));
            boolean stderr = Boolean.parseBoolean(props.getProperty("smile.ols.standard_error", "true"));
            boolean recursive = Boolean.parseBoolean(props.getProperty("smile.ols.recursive", "true"));
            return new Options(method, stderr, recursive);
        }
    }

    public static enum Method {
        QR,
        SVD;

    }
}

