/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.selection;

import java.util.Arrays;
import java.util.stream.IntStream;
import smile.classification.ClassLabels;
import smile.data.DataFrame;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.ValueVector;
import smile.math.MathEx;

public record SumSquaresRatio(String feature, double ratio) implements Comparable<SumSquaresRatio>
{
    @Override
    public int compareTo(SumSquaresRatio other) {
        return Double.compare(this.ratio, other.ratio);
    }

    @Override
    public String toString() {
        return String.format("SumSquaresRatio(%s, %.4f)", this.feature, this.ratio);
    }

    public static SumSquaresRatio[] fit(DataFrame data, String clazz) {
        ValueVector y = data.column(clazz);
        ClassLabels codec = ClassLabels.fit(y);
        if (codec.k < 2) {
            throw new UnsupportedOperationException("Invalid number of classes: " + codec.k);
        }
        int n = data.size();
        int k = codec.k;
        int[] nc = new int[k];
        double[] condmu = new double[k];
        for (int i2 = 0; i2 < n; ++i2) {
            int yi;
            int n2 = yi = codec.y[i2];
            nc[n2] = nc[n2] + 1;
        }
        StructType schema = data.schema();
        return (SumSquaresRatio[])IntStream.range(0, schema.length()).filter(i -> {
            StructField field = schema.field(i);
            return !field.name().equals(clazz) && field.isNumeric();
        }).mapToObj(j -> {
            int i;
            StructField field = schema.field(j);
            ValueVector xj = data.column(j);
            double mu = 0.0;
            Arrays.fill(condmu, 0.0);
            for (i = 0; i < n; ++i) {
                int yi = codec.y[i];
                double xij = xj.getDouble(i);
                mu += xij;
                int n2 = yi;
                condmu[n2] = condmu[n2] + xij;
            }
            mu /= (double)n;
            for (i = 0; i < k; ++i) {
                int n3 = i;
                condmu[n3] = condmu[n3] / (double)nc[i];
            }
            double wss = 0.0;
            double bss = 0.0;
            for (int i2 = 0; i2 < n; ++i2) {
                int yi = codec.y[i2];
                double xij = xj.getDouble(i2);
                bss += MathEx.pow2((double)(condmu[yi] - mu));
                wss += MathEx.pow2((double)(xij - condmu[yi]));
            }
            return new SumSquaresRatio(field.name(), bss / wss);
        }).toArray(SumSquaresRatio[]::new);
    }
}

