/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import smile.clustering.Partitioning;
import smile.math.distance.Distance;
import smile.neighbor.KDTree;
import smile.neighbor.LinearSearch;
import smile.neighbor.Neighbor;
import smile.neighbor.RNNSearch;

public class DBSCAN<T>
extends Partitioning {
    private static final long serialVersionUID = 2L;
    private final int minPoints;
    private final double radius;
    private final RNNSearch<T, T> nns;
    private final boolean[] core;

    public DBSCAN(int k, int[] group, boolean[] core, int minPoints, double radius, RNNSearch<T, T> nns) {
        super(k, group);
        this.minPoints = minPoints;
        this.radius = radius;
        this.nns = nns;
        this.core = core;
    }

    public int minPoints() {
        return this.minPoints;
    }

    public double radius() {
        return this.radius;
    }

    public static DBSCAN<double[]> fit(double[][] data, int minPts, double radius) {
        return DBSCAN.fit(data, new KDTree(data, (Object[])data), minPts, radius);
    }

    public static <T> DBSCAN<T> fit(T[] data, Distance<T> distance, int minPts, double radius) {
        return DBSCAN.fit(data, LinearSearch.of((Object[])data, distance), minPts, radius);
    }

    public static <T> DBSCAN<T> fit(T[] data, RNNSearch<T, T> nns, int minPts, double radius) {
        if (minPts < 1) {
            throw new IllegalArgumentException("Invalid minPts: " + minPts);
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Invalid radius: " + radius);
        }
        int QUEUED = -2;
        int UNDEFINED = -1;
        int k = 0;
        int n = data.length;
        boolean[] core = new boolean[n];
        int[] group = new int[n];
        Arrays.fill(group, -1);
        for (int i = 0; i < data.length; ++i) {
            if (group[i] != -1) continue;
            ArrayList<Neighbor> neighbors = new ArrayList<Neighbor>();
            nns.search(data[i], radius, neighbors);
            if (neighbors.size() < minPts) {
                group[i] = Integer.MAX_VALUE;
                continue;
            }
            group[i] = k;
            core[i] = true;
            for (Neighbor neighbor : neighbors) {
                if (group[neighbor.index()] != -1) continue;
                group[neighbor.index()] = -2;
            }
            for (int j = 0; j < neighbors.size(); ++j) {
                Neighbor neighbor;
                neighbor = (Neighbor)neighbors.get(j);
                int index = neighbor.index();
                if (group[index] == Integer.MAX_VALUE) {
                    group[index] = k;
                }
                if (group[index] != -1 && group[index] != -2) continue;
                group[index] = k;
                ArrayList secondaryNeighbors = new ArrayList();
                nns.search(neighbor.key(), radius, secondaryNeighbors);
                if (secondaryNeighbors.size() < minPts) continue;
                core[neighbor.index()] = true;
                for (Neighbor secondaryNeighbor : secondaryNeighbors) {
                    int label = group[secondaryNeighbor.index()];
                    if (label == -1) {
                        group[secondaryNeighbor.index()] = -2;
                    }
                    if (label != -1 && label != Integer.MAX_VALUE) continue;
                    neighbors.add(secondaryNeighbor);
                }
            }
            ++k;
        }
        return new DBSCAN<T>(k, group, core, minPts, radius, nns);
    }

    public int predict(T x) {
        ArrayList neighbors = new ArrayList();
        this.nns.search(x, this.radius, neighbors);
        Collections.sort(neighbors);
        for (Neighbor neighbor : neighbors) {
            if (!this.core[neighbor.index()]) continue;
            return this.group[neighbor.index()];
        }
        return Integer.MAX_VALUE;
    }
}

